/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.service;

import com.nedap.archie.rm.datavalues.DvIdentifier;
import com.nedap.archie.rm.generic.PartyIdentified;
import com.nedap.archie.rm.generic.PartyProxy;
import com.nedap.archie.rm.support.identification.GenericId;
import com.nedap.archie.rm.support.identification.ObjectId;
import com.nedap.archie.rm.support.identification.PartyRef;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.ehrbase.api.definitions.ServerConfig;
import org.ehrbase.api.service.TenantService;
import org.ehrbase.dao.access.interfaces.I_DomainAccess;
import org.ehrbase.dao.access.jooq.party.PersistedPartyIdentified;
import org.ehrbase.dao.access.support.ServiceDataAccess;
import org.ehrbase.service.CacheKey;
import org.ehrbase.service.IAuthenticationFacade;
import org.ehrbase.service.IUserService;
import org.ehrbase.service.KnowledgeCacheService;
import org.ehrbase.util.UuidGenerator;
import org.jooq.DSLContext;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.stereotype.Service;

@Service
public class UserService
implements IUserService {
    private final IAuthenticationFacade authenticationFacade;
    private final TenantService tenantService;
    private final I_DomainAccess dataAccess;
    private final Cache userIdCache;

    public UserService(IAuthenticationFacade authenticationFacade, TenantService tenantService, KnowledgeCacheService knowledgeCacheService, DSLContext context, ServerConfig serverConfig, CacheManager cacheManager) {
        this.authenticationFacade = authenticationFacade;
        this.tenantService = tenantService;
        this.dataAccess = new ServiceDataAccess(context, knowledgeCacheService, knowledgeCacheService, serverConfig);
        this.userIdCache = cacheManager.getCache("userIdCache");
    }

    @Override
    public UUID getCurrentUserId() {
        CacheKey<String> key = CacheKey.of(this.authenticationFacade.getAuthentication().getName(), this.tenantService.getCurrentTenantIdentifier());
        return (UUID)this.userIdCache.get(key, () -> this.getOrCreateCurrentUserIdSnyc(key));
    }

    private UUID getOrCreateCurrentUserIdSnyc(CacheKey<String> key) {
        Optional<UUID> existingUser = new PersistedPartyIdentified(this.dataAccess).findInternalUserId(key.getVal());
        if (existingUser.isEmpty()) {
            return this.createUserInternal(key);
        }
        return existingUser.get();
    }

    private UUID createUserInternal(CacheKey<String> key) {
        DvIdentifier identifier = new DvIdentifier();
        identifier.setId(key.getVal());
        identifier.setIssuer("EHRbase");
        identifier.setAssigner("EHRbase");
        identifier.setType("EHRbase Security Authentication User");
        PartyRef externalRef = new PartyRef((ObjectId)new GenericId(UuidGenerator.randomUUID().toString(), "DEMOGRAPHIC"), "User", "PARTY");
        PartyIdentified user = new PartyIdentified(externalRef, "EHRbase Internal " + key.getVal(), List.of(identifier));
        return new PersistedPartyIdentified(this.dataAccess).store((PartyProxy)user, key.getTenantId());
    }
}

