/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.compiler;

import java.util.List;
import java.util.Stack;

class WhereClauseUtil {
    private List<Object> expression;
    private String unbalanced;

    WhereClauseUtil(List<Object> expression) {
        this.expression = expression;
    }

    boolean isBalancedBlocks() {
        Stack<Object> stack = new Stack<Object>();
        for (Object item : this.expression) {
            if (item.toString().length() == 1 && item.toString().matches("\\(|}|\\[")) {
                stack.push(item);
                continue;
            }
            if (item.toString().length() != 1 || !item.toString().matches("\\)|\\{|\\]")) continue;
            if (stack.empty()) {
                return false;
            }
            if (this.isBalanced(stack.pop(), item)) continue;
            return false;
        }
        return stack.empty();
    }

    private boolean isBalanced(Object fromStack, Object actual) {
        boolean result = false;
        if (actual.toString().equals(")")) {
            result = fromStack.toString().equals("(");
        } else if (actual.toString().equals("]")) {
            result = fromStack.toString().equals("[");
        }
        if (actual.toString().equals("}")) {
            result = fromStack.toString().equals("{");
        }
        if (!result) {
            this.unbalanced = actual.toString();
        }
        return result;
    }

    String getUnbalanced() {
        return this.unbalanced;
    }
}

