/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.sql.binding;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.aql.definition.I_VariableDefinition;
import org.ehrbase.aql.definition.LateralJoinDefinition;
import org.ehrbase.aql.definition.LateralVariable;
import org.ehrbase.aql.definition.VariableDefinition;
import org.ehrbase.aql.sql.PathResolver;
import org.ehrbase.aql.sql.binding.LateralJoins;
import org.ehrbase.aql.sql.binding.SetReturningFunction;
import org.ehrbase.aql.sql.binding.TaggedStringBuilder;
import org.ehrbase.aql.sql.binding.WhereJsQueryExpression;
import org.ehrbase.aql.sql.binding.WhereVariable;
import org.ehrbase.aql.sql.queryimpl.IQueryImpl;
import org.ehrbase.aql.sql.queryimpl.JsonbEntryQuery;
import org.ehrbase.aql.sql.queryimpl.MultiFields;
import org.ehrbase.aql.sql.queryimpl.MultiFieldsMap;
import org.ehrbase.aql.sql.queryimpl.UnknownVariableException;
import org.ehrbase.aql.sql.queryimpl.VariablePath;
import org.ehrbase.aql.sql.queryimpl.value_field.ISODateTime;
import org.jooq.Condition;
import org.jooq.impl.DSL;

public class WhereBinder {
    private static final String VALUETYPE_EXPR_VALUE = "/value,value";
    public static final String EXISTS = "EXISTS";
    public static final String MATCHES = "MATCHES";
    public static final String NOT = "NOT";
    public static final String IS = "IS";
    public static final String TRUE = "TRUE";
    public static final String FALSE = "FALSE";
    public static final String NULL = "NULL";
    public static final String UNKNOWN = "UNKNOWN";
    public static final String DISTINCT = "DISTINCT";
    public static final String FROM = "FROM";
    public static final String BETWEEN = "BETWEEN";
    private static final Set<String> SQL_OPERATORS = Set.of("=", "!=", ">", ">=", "<", "<=", "MATCHES", "EXISTS", "NOT", "IS", "TRUE", "FALSE", "NULL", "UNKNOWN", "DISTINCT", "FROM", "BETWEEN", "(", ")", "{", "}");
    private static final Pattern SQL_CONDITIONAL_FUNCTIONAL_OPERATOR_PATTERN = Pattern.compile("(?i)(like|ilike|substr|in|not in)");
    public static final String OR = "OR";
    public static final String XOR = "XOR";
    public static final String AND = "AND";
    public static final String IN = "IN";
    public static final String ANY = "ANY";
    public static final String SOME = "SOME";
    public static final String ALL = "ALL";
    private final List<Object> whereClause;
    private boolean requiresJSQueryClosure = false;
    private boolean isFollowedBySQLConditionalOperator = false;
    private final WhereVariable whereVariable;

    public WhereBinder(List<Object> whereClause, PathResolver pathResolver) {
        this.whereClause = whereClause;
        this.whereVariable = new WhereVariable(pathResolver);
    }

    private TaggedStringBuilder buildWhereCondition(ExistsMode existsMode, int whereCursor, MultiFieldsMap multiFieldsMap, int selectCursor, MultiFieldsMap multiSelectFieldsMap, TaggedStringBuilder taggedBuffer, List<Object> item) throws UnknownVariableException {
        for (Object part : item) {
            TaggedStringBuilder taggedStringBuilder;
            if (part instanceof String) {
                taggedBuffer.append((String)part);
                continue;
            }
            if (part instanceof VariableDefinition) {
                taggedStringBuilder = this.whereVariable.encodeWhereVariable(existsMode, this.isFollowedBySQLConditionalOperator, whereCursor, multiFieldsMap, selectCursor, multiSelectFieldsMap, (VariableDefinition)part, null);
                this.isFollowedBySQLConditionalOperator = this.whereVariable.isFollowedBySQLConditionalOperator();
                if (taggedStringBuilder == null) continue;
                taggedBuffer.append(taggedStringBuilder.toString());
                taggedBuffer.setTagField(taggedStringBuilder.getTagField());
                continue;
            }
            if (!(part instanceof List)) continue;
            taggedStringBuilder = this.buildWhereCondition(existsMode, whereCursor, multiFieldsMap, selectCursor, multiSelectFieldsMap, taggedBuffer, (List)part);
            taggedBuffer.append(taggedStringBuilder.toString());
            taggedBuffer.setTagField(taggedStringBuilder.getTagField());
        }
        return taggedBuffer;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Condition bind(String templateId, int whereCursor, MultiFieldsMap multiWhereFieldsMap, int selectCursor, MultiFieldsMap multiSelectFieldsMap) throws UnknownVariableException {
        boolean unresolvedVariable = false;
        if (this.whereClause.isEmpty()) {
            return null;
        }
        TaggedStringBuilder taggedBuffer = new TaggedStringBuilder();
        ArrayList<Object> whereItems = new ArrayList<Object>(this.whereClause);
        boolean notExists = false;
        boolean inSubqueryOperator = false;
        ExistsMode inExists = ExistsMode.UNSET;
        for (int cursor = 0; cursor < whereItems.size(); ++cursor) {
            TaggedStringBuilder taggedStringBuilder;
            Object e = whereItems.get(cursor);
            if (e instanceof String) {
                switch (((String)e).trim().toUpperCase()) {
                    case "OR": 
                    case "XOR": 
                    case "AND": {
                        taggedBuffer = new WhereJsQueryExpression(taggedBuffer, this.requiresJSQueryClosure, this.isFollowedBySQLConditionalOperator).closure();
                        taggedBuffer.append(" " + e + " ");
                        break;
                    }
                    case "NOT": {
                        if (whereItems.get(cursor + 1).toString().equalsIgnoreCase(EXISTS)) {
                            notExists = true;
                            inExists = ExistsMode.NOT_EXISTS;
                            break;
                        }
                        taggedBuffer = new WhereJsQueryExpression(taggedBuffer, this.requiresJSQueryClosure, this.isFollowedBySQLConditionalOperator).closure();
                        taggedBuffer.append(" " + e + " ");
                        break;
                    }
                    case "IN": 
                    case "ANY": 
                    case "SOME": 
                    case "ALL": {
                        if (((String)e).trim().toUpperCase().matches("ANY|SOME|ALL")) {
                            inSubqueryOperator = true;
                        }
                        taggedBuffer.append((String)e);
                        break;
                    }
                    case "EXISTS": {
                        whereItems.add(cursor + 2, notExists ? "IS " : "IS NOT ");
                        whereItems.add(cursor + 3, NULL);
                        notExists = false;
                        if (!inExists.equals((Object)ExistsMode.UNSET)) break;
                        inExists = ExistsMode.EXISTS;
                        break;
                    }
                    default: {
                        ISODateTime isoDateTime = new ISODateTime(((String)e).replace("'", ""));
                        if (isoDateTime.isValidDateTimeExpression()) {
                            long timestamp = isoDateTime.toTimeStamp() / 1000L;
                            int lastValuePos = taggedBuffer.lastIndexOf(VALUETYPE_EXPR_VALUE);
                            if (lastValuePos > 0) {
                                taggedBuffer.replaceLast(VALUETYPE_EXPR_VALUE, "/value,epoch_offset");
                            }
                            this.isFollowedBySQLConditionalOperator = true;
                            Object object = this.hackItem(taggedBuffer, Long.toString(timestamp), "numeric");
                            taggedBuffer.append((String)object);
                            break;
                        }
                        Object object = this.hackItem(taggedBuffer, (String)e, null);
                        taggedBuffer.append((String)object);
                        break;
                    }
                }
                continue;
            }
            if (e instanceof Long) {
                Object object = this.hackItem(taggedBuffer, e.toString(), null);
                taggedBuffer.append(object.toString());
                continue;
            }
            if (e instanceof I_VariableDefinition) {
                block35: {
                    String expanded;
                    taggedStringBuilder = new TaggedStringBuilder();
                    if (this.isFollowedBySQLConditionalOperator(cursor)) {
                        TaggedStringBuilder encodedVar = this.whereVariable.encodeWhereVariable(inExists, this.isFollowedBySQLConditionalOperator, whereCursor, multiWhereFieldsMap, selectCursor, multiSelectFieldsMap, (I_VariableDefinition)e, null);
                        this.isFollowedBySQLConditionalOperator = this.whereVariable.isFollowedBySQLConditionalOperator();
                        inExists = this.whereVariable.inExists();
                        expanded = this.expandForLateral(templateId, encodedVar, (I_VariableDefinition)e, multiSelectFieldsMap);
                        if (StringUtils.isNotBlank((CharSequence)expanded)) {
                            taggedStringBuilder.append(expanded);
                            break block35;
                        } else {
                            unresolvedVariable = true;
                            break;
                        }
                    }
                    if (new VariablePath(((I_VariableDefinition)e).getPath()).hasPredicate()) {
                        TaggedStringBuilder variableSQL = this.whereVariable.encodeWhereVariable(inExists, this.isFollowedBySQLConditionalOperator, whereCursor, multiWhereFieldsMap, selectCursor, multiSelectFieldsMap, (I_VariableDefinition)e, null);
                        this.isFollowedBySQLConditionalOperator = this.whereVariable.isFollowedBySQLConditionalOperator();
                        inExists = this.whereVariable.inExists();
                        expanded = this.expandForLateral(templateId, variableSQL, (I_VariableDefinition)e, multiSelectFieldsMap);
                        if (StringUtils.isNotBlank((CharSequence)expanded)) {
                            taggedStringBuilder.append(this.encodeForSubquery(expanded, inSubqueryOperator));
                            inSubqueryOperator = false;
                            this.isFollowedBySQLConditionalOperator = true;
                            this.requiresJSQueryClosure = false;
                            break block35;
                        } else {
                            unresolvedVariable = true;
                            break;
                        }
                    }
                    String expanded2 = this.expandForLateral(templateId, this.whereVariable.encodeWhereVariable(inExists, this.isFollowedBySQLConditionalOperator, whereCursor, multiWhereFieldsMap, selectCursor, multiSelectFieldsMap, (I_VariableDefinition)e, null), (I_VariableDefinition)e, multiSelectFieldsMap);
                    this.isFollowedBySQLConditionalOperator = this.whereVariable.isFollowedBySQLConditionalOperator();
                    inExists = this.whereVariable.inExists();
                    if (StringUtils.isNotBlank((CharSequence)expanded2)) {
                        taggedStringBuilder.append(this.encodeForSubquery(expanded2, inSubqueryOperator));
                        inSubqueryOperator = false;
                    } else {
                        unresolvedVariable = true;
                        break;
                    }
                }
                taggedBuffer.append(taggedStringBuilder.toString());
                taggedBuffer.setTagField(taggedStringBuilder.getTagField());
                continue;
            }
            if (!(e instanceof List)) continue;
            taggedStringBuilder = this.buildWhereCondition(inExists, whereCursor, multiWhereFieldsMap, selectCursor, multiSelectFieldsMap, taggedBuffer, (List)e);
            taggedBuffer.append(taggedStringBuilder.toString());
            taggedBuffer.setTagField(taggedStringBuilder.getTagField());
        }
        if (!unresolvedVariable) {
            taggedBuffer = new WhereJsQueryExpression(taggedBuffer, this.requiresJSQueryClosure, this.isFollowedBySQLConditionalOperator).closure();
            return DSL.condition((String)taggedBuffer.toString());
        }
        return DSL.falseCondition();
    }

    private String encodeForSubquery(String sqlExpression, boolean inSubqueryOperator) {
        if (inSubqueryOperator) {
            return "(SELECT " + sqlExpression + ")";
        }
        return sqlExpression;
    }

    private boolean isFollowedBySQLConditionalOperator(int cursor) {
        Object nextToken;
        if (cursor < this.whereClause.size() - 1 && (nextToken = this.whereClause.get(cursor + 1)) instanceof String && SQL_CONDITIONAL_FUNCTIONAL_OPERATOR_PATTERN.matcher(((String)nextToken).trim()).matches()) {
            this.isFollowedBySQLConditionalOperator = true;
            return true;
        }
        this.isFollowedBySQLConditionalOperator = false;
        return false;
    }

    private String compositionNameValue(String symbol) {
        String token = null;
        for (int lcursor = 0; lcursor < this.whereClause.size() - 1; ++lcursor) {
            if (!(this.whereClause.get(lcursor) instanceof VariableDefinition) || !((VariableDefinition)this.whereClause.get(lcursor)).getIdentifier().equals(symbol) || !((VariableDefinition)this.whereClause.get(lcursor)).getPath().equals("name/value")) continue;
            Object nextToken = this.whereClause.get(lcursor + 1);
            if (nextToken instanceof String && !nextToken.equals("=")) {
                throw new IllegalArgumentException("name/value for CompositionAttribute must be an equality");
            }
            nextToken = this.whereClause.get(lcursor + 2);
            if (!(nextToken instanceof String)) continue;
            token = (String)nextToken;
            break;
        }
        return token;
    }

    private Object hackItem(TaggedStringBuilder taggedBuffer, String item, String castAs) {
        if (castAs != null) {
            int variableInitial;
            int variableClosure;
            if (this.isFollowedBySQLConditionalOperator && (variableClosure = taggedBuffer.lastIndexOf("}'")) > 0 && (variableInitial = taggedBuffer.lastIndexOf("\"ehr\".\"entry\".\"entry\" #>>")) >= 0 && variableInitial < variableClosure) {
                taggedBuffer.insert(variableClosure + "}'".length(), ")::" + castAs);
                taggedBuffer.insert(variableInitial, "(");
            }
            return item;
        }
        if (SQL_OPERATORS.contains(item.toUpperCase())) {
            return " " + item + " ";
        }
        if (taggedBuffer.toString().contains("composition_join") && item.contains("::")) {
            return item.split("::")[0] + "'";
        }
        if (this.requiresJSQueryClosure && !this.isFollowedBySQLConditionalOperator && taggedBuffer.indexOf("#") > 0 && item.contains("'")) {
            return item.replace("'", "\"");
        }
        return item;
    }

    private String expandForCondition(TaggedStringBuilder taggedStringBuilder) {
        Object wrapped;
        if (taggedStringBuilder == null) {
            return null;
        }
        switch (taggedStringBuilder.getTagField()) {
            case JSQUERY: {
                wrapped = JsonbEntryQuery.JSQUERY_COMPOSITION_OPEN + taggedStringBuilder;
                this.requiresJSQueryClosure = true;
                break;
            }
            case SQLQUERY: {
                wrapped = taggedStringBuilder.toString();
                break;
            }
            default: {
                throw new IllegalArgumentException("Uninitialized tag passed in query expression");
            }
        }
        return wrapped;
    }

    private String expandForLateral(String templateId, TaggedStringBuilder encodedVar, I_VariableDefinition variableDefinition, MultiFieldsMap multiSelectFieldsMap) {
        boolean isAlreadyCast;
        Object expanded = this.expandForCondition(encodedVar);
        if (SetReturningFunction.isUsed((String)expanded)) {
            isAlreadyCast = false;
            MultiFields selectFields = multiSelectFieldsMap.get(variableDefinition.getIdentifier(), variableDefinition.getPath());
            if (selectFields != null && selectFields.getVariableDefinition().getLateralJoinDefinitions(templateId) != null) {
                LateralJoinDefinition lateralJoinDefinition = this.reconciliateWithAliasedTable((String)expanded, selectFields.getVariableDefinition(), templateId);
                if (lateralJoinDefinition == null) {
                    return null;
                }
                variableDefinition.setLateralJoinTable(templateId, lateralJoinDefinition);
                variableDefinition.setAlias(new LateralVariable(lateralJoinDefinition.getTable().getName(), lateralJoinDefinition.getLateralVariable()).alias());
            } else {
                multiSelectFieldsMap.matchingLateralJoin(templateId, (String)expanded).ifPresentOrElse(lj -> LateralJoins.reuse(lj, templateId, variableDefinition), () -> LateralJoins.create(templateId, encodedVar, variableDefinition, IQueryImpl.Clause.WHERE));
            }
            expanded = variableDefinition.getAlias();
        } else {
            isAlreadyCast = true;
        }
        if (this.whereVariable.hasRightMostJsonbExpression()) {
            expanded = (String)expanded + this.whereVariable.getRightMostJsonbExpression();
        }
        if (variableDefinition.getSelectType() != null && !isAlreadyCast) {
            expanded = "(" + (String)expanded + ")::" + variableDefinition.getSelectType().getCastTypeName() + " ";
        }
        return expanded;
    }

    private LateralJoinDefinition reconciliateWithAliasedTable(String expanded, I_VariableDefinition variableDefinition, String templateId) {
        Set<LateralJoinDefinition> definedLateralJoins = variableDefinition.getLateralJoinDefinitions(templateId);
        for (LateralJoinDefinition lateralJoinDefinition : definedLateralJoins) {
            if (!lateralJoinDefinition.getSqlExpression().replace("\n", "").replace(" ", "").contains(expanded.substring(0, expanded.length() - 1).substring(1).replace("\n", "").replace(" ", ""))) continue;
            return lateralJoinDefinition;
        }
        return null;
    }

    static enum ExistsMode {
        NOT_EXISTS,
        EXISTS,
        UNSET;

    }
}

