/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.dao.access.jooq;

import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.util.AbstractMap;
import java.util.UUID;
import org.ehrbase.dao.access.interfaces.I_CompositionHistoryAccess;
import org.ehrbase.dao.access.interfaces.I_DomainAccess;
import org.ehrbase.dao.access.support.DataAccess;
import org.ehrbase.dao.access.util.TransactionTime;
import org.ehrbase.jooq.pg.Tables;
import org.ehrbase.jooq.pg.tables.records.CompositionHistoryRecord;
import org.jooq.Condition;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.Table;

public class CompositionHistoryAccess
extends DataAccess
implements I_CompositionHistoryAccess {
    private CompositionHistoryRecord record;

    public CompositionHistoryAccess(I_DomainAccess domainAccess, String tenantIdentifier) {
        super(domainAccess);
        this.record = (CompositionHistoryRecord)domainAccess.getContext().newRecord((Table)Tables.COMPOSITION_HISTORY);
        this.record.setNamespace(tenantIdentifier);
    }

    @Override
    public DataAccess getDataAccess() {
        return this;
    }

    @Override
    public UUID commit(Timestamp transactionTime) {
        this.record.setSysTransaction(transactionTime);
        return this.commit();
    }

    @Override
    public UUID commit() {
        if (this.record.getSysTransaction() == null) {
            this.record.setSysTransaction(TransactionTime.millis());
            this.record.setSysPeriod(new AbstractMap.SimpleEntry<OffsetDateTime, Object>(OffsetDateTime.now(), null));
        }
        if (this.record.insert() == 1) {
            return this.record.getId();
        }
        return null;
    }

    @Override
    public Boolean update(Timestamp transactionTime) {
        return null;
    }

    @Override
    public Boolean update(Timestamp transactionTime, boolean force) {
        return null;
    }

    @Override
    public Boolean update() {
        int num = this.getContext().update((Table)Tables.COMPOSITION_HISTORY).set((Record)this.record).where(Tables.COMPOSITION_HISTORY.ID.eq((Object)this.record.getId()).and(Tables.COMPOSITION_HISTORY.SYS_TRANSACTION.eq((Object)this.record.getSysTransaction()))).execute();
        return num >= 1;
    }

    @Override
    public Boolean update(Boolean force) {
        return null;
    }

    @Override
    public Integer delete() {
        Condition condition = Tables.COMPOSITION_HISTORY.ID.eq((Object)this.record.getId()).and(Tables.COMPOSITION_HISTORY.SYS_TRANSACTION.eq((Object)this.record.getSysTransaction()));
        return this.getContext().delete((Table)Tables.COMPOSITION_HISTORY).where(condition).execute();
    }

    public static I_CompositionHistoryAccess retrieveByVersion(I_DomainAccess domainAccess, UUID compositionId, int version) {
        return CompositionHistoryAccess.retrieveByIdx(domainAccess, compositionId, version);
    }

    public static I_CompositionHistoryAccess retrieveLatest(I_DomainAccess domainAccess, UUID compositionId) {
        return CompositionHistoryAccess.retrieveByIdx(domainAccess, compositionId, 0);
    }

    private static I_CompositionHistoryAccess retrieveByIdx(I_DomainAccess domainAccess, UUID compositionId, int idx) {
        Result historyRecordsRes = domainAccess.getContext().selectFrom((Table)Tables.COMPOSITION_HISTORY).where(Tables.COMPOSITION_HISTORY.ID.eq((Object)compositionId)).orderBy((OrderField)(idx == 0 ? Tables.COMPOSITION_HISTORY.SYS_TRANSACTION.desc() : Tables.COMPOSITION_HISTORY.SYS_TRANSACTION.asc())).fetch();
        if (historyRecordsRes.isEmpty()) {
            return null;
        }
        CompositionHistoryRecord rec = (CompositionHistoryRecord)historyRecordsRes.get(idx == 0 ? idx : idx - 1);
        CompositionHistoryAccess historyAccess = new CompositionHistoryAccess(domainAccess, rec.getNamespace());
        historyAccess.setRecord(rec);
        return historyAccess;
    }

    @Override
    public void setRecord(CompositionHistoryRecord record) {
        this.record = record;
    }

    @Override
    public CompositionHistoryRecord getRecord() {
        return this.record;
    }

    @Override
    public void setInContribution(UUID contribution) {
        this.record.setInContribution(contribution);
    }

    @Override
    public void setHasAudit(UUID audit) {
        this.record.setHasAudit(audit);
    }

    @Override
    public Timestamp getSysTransaction() {
        return this.record == null ? null : this.record.getSysTransaction();
    }

    @Override
    public UUID getContributionId() {
        return this.record == null ? null : this.record.getInContribution();
    }

    @Override
    public UUID getId() {
        return this.record == null ? null : this.record.getId();
    }
}

