/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.dao.access.jooq;

import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.composition.EventContext;
import com.nedap.archie.rm.datastructures.ItemStructure;
import com.nedap.archie.rm.datavalues.DvCodedText;
import com.nedap.archie.rm.datavalues.DvIdentifier;
import com.nedap.archie.rm.datavalues.DvText;
import com.nedap.archie.rm.datavalues.quantity.DvInterval;
import com.nedap.archie.rm.datavalues.quantity.DvOrdered;
import com.nedap.archie.rm.datavalues.quantity.datetime.DvDateTime;
import com.nedap.archie.rm.generic.Participation;
import com.nedap.archie.rm.generic.PartyIdentified;
import com.nedap.archie.rm.generic.PartyProxy;
import com.nedap.archie.rm.support.identification.ObjectId;
import com.nedap.archie.rm.support.identification.PartyRef;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.apache.commons.collections4.CollectionUtils;
import org.ehrbase.api.definitions.ServerConfig;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.dao.access.interfaces.I_ContextAccess;
import org.ehrbase.dao.access.interfaces.I_DomainAccess;
import org.ehrbase.dao.access.jooq.party.PersistedObjectId;
import org.ehrbase.dao.access.jooq.party.PersistedPartyProxy;
import org.ehrbase.dao.access.support.DataAccess;
import org.ehrbase.dao.access.util.TransactionTime;
import org.ehrbase.jooq.pg.Tables;
import org.ehrbase.jooq.pg.tables.records.EventContextHistoryRecord;
import org.ehrbase.jooq.pg.tables.records.EventContextRecord;
import org.ehrbase.jooq.pg.tables.records.ParticipationHistoryRecord;
import org.ehrbase.jooq.pg.tables.records.ParticipationRecord;
import org.ehrbase.jooq.pg.tables.records.PartyIdentifiedRecord;
import org.ehrbase.jooq.pg.udt.records.DvCodedTextRecord;
import org.ehrbase.serialisation.dbencoding.RawJson;
import org.ehrbase.service.RecordedDvCodedText;
import org.ehrbase.service.RecordedDvDateTime;
import org.ehrbase.service.RecordedDvText;
import org.ehrbase.util.UuidGenerator;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.InsertQuery;
import org.jooq.JSONB;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.Table;
import org.jooq.UpdateQuery;
import org.jooq.exception.DataAccessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextAccess
extends DataAccess
implements I_ContextAccess {
    private static final String DB_INCONSISTENCY = "DB inconsistency";
    private final Logger log = LoggerFactory.getLogger(ContextAccess.class);
    private final List<ParticipationRecord> participations = new ArrayList<ParticipationRecord>();
    private EventContextRecord eventContextRecord;

    public ContextAccess(DSLContext context, ServerConfig serverConfig, EventContext eventContext, String tenantIdentifier) {
        super(context, null, null, serverConfig);
        if (eventContext == null) {
            return;
        }
        this.eventContextRecord = (EventContextRecord)context.newRecord((Table)Tables.EVENT_CONTEXT);
        this.setRecordFields(UuidGenerator.randomUUID(), eventContext, tenantIdentifier);
    }

    private ContextAccess(I_DomainAccess domainAccess) {
        super(domainAccess);
    }

    public static I_ContextAccess retrieveInstance(I_DomainAccess domainAccess, UUID id) {
        ContextAccess contextAccess = new ContextAccess(domainAccess);
        contextAccess.eventContextRecord = (EventContextRecord)domainAccess.getContext().fetchOne((Table)Tables.EVENT_CONTEXT, Tables.EVENT_CONTEXT.ID.eq((Object)id));
        return contextAccess;
    }

    public static I_ContextAccess retrieveInstance(I_DomainAccess domainAccess, Result<?> records) {
        ContextAccess contextAccess = new ContextAccess(domainAccess);
        EventContextRecord eventContextRecord = (EventContextRecord)domainAccess.getContext().newRecord((Table)Tables.EVENT_CONTEXT);
        eventContextRecord.setStartTime((Timestamp)records.getValue(0, "context_start_time"));
        eventContextRecord.setStartTimeTzid((String)records.getValue(0, "context_start_time_tzid"));
        eventContextRecord.setEndTime((Timestamp)records.getValue(0, "context_end_time"));
        eventContextRecord.setEndTimeTzid((String)records.getValue(0, "context_end_time_tzid"));
        eventContextRecord.setLocation((String)records.getValue(0, "context_location"));
        eventContextRecord.setOtherContext((JSONB)records.getValue(0, "context_other_context"));
        return contextAccess;
    }

    public static EventContext retrieveHistoricalEventContext(I_DomainAccess domainAccess, UUID compositionId, Timestamp transactionTime) {
        PartyIdentifiedRecord partyIdentifiedRecord;
        EventContextHistoryRecord eventContextHistoryRecord = (EventContextHistoryRecord)domainAccess.getContext().fetchAny((Table)Tables.EVENT_CONTEXT_HISTORY, Tables.EVENT_CONTEXT_HISTORY.COMPOSITION_ID.eq((Object)compositionId).and(Tables.EVENT_CONTEXT_HISTORY.SYS_TRANSACTION.eq((Object)transactionTime)));
        if (eventContextHistoryRecord == null) {
            return null;
        }
        PartyIdentified healthCareFacility = null;
        if (eventContextHistoryRecord.getFacility() != null && (partyIdentifiedRecord = (PartyIdentifiedRecord)domainAccess.getContext().fetchOne((Table)Tables.PARTY_IDENTIFIED, Tables.PARTY_IDENTIFIED.ID.eq((Object)eventContextHistoryRecord.getFacility()))) != null) {
            ArrayList<DvIdentifier> identifiers = new ArrayList<DvIdentifier>();
            domainAccess.getContext().fetch((Table)Tables.IDENTIFIER, Tables.IDENTIFIER.PARTY.eq((Object)partyIdentifiedRecord.getId())).forEach(record -> {
                DvIdentifier dvIdentifier = new DvIdentifier();
                dvIdentifier.setIssuer(record.getIssuer());
                dvIdentifier.setAssigner(record.getAssigner());
                dvIdentifier.setId(record.getIdValue());
                dvIdentifier.setType(record.getTypeName());
                identifiers.add(dvIdentifier);
            });
            healthCareFacility = ContextAccess.getPartyIdentifiedFromRecord(partyIdentifiedRecord, identifiers);
        }
        ArrayList participationList = new ArrayList();
        domainAccess.getContext().fetch((Table)Tables.PARTICIPATION_HISTORY, Tables.PARTICIPATION_HISTORY.EVENT_CONTEXT.eq((Object)eventContextHistoryRecord.getId()).and(Tables.PARTICIPATION_HISTORY.SYS_TRANSACTION.eq((Object)transactionTime))).forEach(historyRecord -> {
            PartyProxy performer = new PersistedPartyProxy(domainAccess).retrieve(historyRecord.getPerformer());
            DvInterval<DvDateTime> startTime = ContextAccess.getStartTimeInterval(historyRecord);
            DvCodedText mode = historyRecord.getMode() != null ? (DvCodedText)new RecordedDvCodedText().fromDB((Record)historyRecord, (Field<DvCodedTextRecord>)Tables.PARTICIPATION_HISTORY.MODE) : null;
            Participation participation = new Participation(performer, (DvText)new RecordedDvCodedText().fromDB((Record)historyRecord, (Field<DvCodedTextRecord>)Tables.PARTICIPATION_HISTORY.FUNCTION), mode, startTime);
            participationList.add(participation);
        });
        DvCodedText setting = (DvCodedText)new RecordedDvCodedText().fromDB((Record)eventContextHistoryRecord, (Field<DvCodedTextRecord>)Tables.EVENT_CONTEXT_HISTORY.SETTING);
        return new EventContext(healthCareFacility, new RecordedDvDateTime().decodeDvDateTime(eventContextHistoryRecord.getStartTime(), eventContextHistoryRecord.getStartTimeTzid()), new RecordedDvDateTime().decodeDvDateTime(eventContextHistoryRecord.getEndTime(), eventContextHistoryRecord.getEndTimeTzid()), participationList.isEmpty() ? null : participationList, eventContextHistoryRecord.getLocation(), setting, null);
    }

    private static PartyIdentified getPartyIdentifiedFromRecord(PartyIdentifiedRecord partyIdentifiedRecord, List<DvIdentifier> identifiers) {
        PartyRef partyRef = null;
        if (partyIdentifiedRecord.getPartyRefValue() != null && partyIdentifiedRecord.getPartyRefScheme() != null) {
            ObjectId objectID = new PersistedObjectId().fromDB(partyIdentifiedRecord);
            partyRef = new PartyRef(objectID, partyIdentifiedRecord.getPartyRefNamespace(), partyIdentifiedRecord.getPartyRefType());
        }
        PartyIdentified healthCareFacility = new PartyIdentified(partyRef, partyIdentifiedRecord.getName(), identifiers.isEmpty() ? null : identifiers);
        return healthCareFacility;
    }

    @Override
    public void setRecordFields(UUID id, EventContext eventContext, String tenantIdentifier) {
        RecordedDvDateTime recordedDvDateTime = new RecordedDvDateTime(eventContext.getStartTime());
        this.eventContextRecord.setStartTime(recordedDvDateTime.toTimestamp());
        this.eventContextRecord.setNamespace(tenantIdentifier);
        recordedDvDateTime.zoneId().ifPresent(arg_0 -> ((EventContextRecord)this.eventContextRecord).setStartTimeTzid(arg_0));
        if (eventContext.getEndTime() != null) {
            recordedDvDateTime = new RecordedDvDateTime(eventContext.getEndTime());
            this.eventContextRecord.setEndTime(recordedDvDateTime.toTimestamp());
            recordedDvDateTime.zoneId().ifPresent(arg_0 -> ((EventContextRecord)this.eventContextRecord).setEndTimeTzid(arg_0));
        }
        this.eventContextRecord.setId(id != null ? id : UuidGenerator.randomUUID());
        if (eventContext.getHealthCareFacility() != null) {
            UUID healthcareFacilityId = new PersistedPartyProxy(this).getOrCreate((PartyProxy)eventContext.getHealthCareFacility(), tenantIdentifier);
            this.eventContextRecord.setFacility(healthcareFacilityId);
        }
        if (eventContext.getLocation() != null) {
            this.eventContextRecord.setLocation(eventContext.getLocation());
        }
        new RecordedDvCodedText().toDB((Record)this.eventContextRecord, (Field<DvCodedTextRecord>)Tables.EVENT_CONTEXT.SETTING, eventContext.getSetting());
        this.participations.clear();
        if (eventContext.getParticipations() != null) {
            for (Participation participation : eventContext.getParticipations()) {
                PartyProxy setPerformer;
                ParticipationRecord participationRecord = (ParticipationRecord)this.getContext().newRecord((Table)Tables.PARTICIPATION);
                participationRecord.setEventContext(this.eventContextRecord.getId());
                new RecordedDvText().toDB((Record)participationRecord, (Field<DvCodedTextRecord>)Tables.PARTICIPATION.FUNCTION, participation.getFunction());
                if (participation.getMode() != null) {
                    new RecordedDvCodedText().toDB((Record)participationRecord, (Field<DvCodedTextRecord>)Tables.PARTICIPATION.MODE, participation.getMode());
                }
                if (participation.getTime() != null) {
                    DvDateTime upper;
                    DvDateTime lower = (DvDateTime)participation.getTime().getLower();
                    if (lower != null) {
                        recordedDvDateTime = new RecordedDvDateTime(lower);
                        participationRecord.setTimeLower(recordedDvDateTime.toTimestamp());
                        recordedDvDateTime.zoneId().ifPresent(arg_0 -> ((ParticipationRecord)participationRecord).setTimeLowerTz(arg_0));
                    }
                    if ((upper = (DvDateTime)participation.getTime().getUpper()) != null) {
                        recordedDvDateTime = new RecordedDvDateTime(upper);
                        participationRecord.setTimeUpper(recordedDvDateTime.toTimestamp());
                        recordedDvDateTime.zoneId().ifPresent(arg_0 -> ((ParticipationRecord)participationRecord).setTimeUpperTz(arg_0));
                    }
                }
                if (!((setPerformer = participation.getPerformer()) instanceof PartyIdentified)) {
                    this.log.warn("Set performer is using unsupported type: {}", (Object)setPerformer);
                    break;
                }
                PartyIdentified performer = (PartyIdentified)setPerformer;
                UUID performerUuid = new PersistedPartyProxy(this).getOrCreate((PartyProxy)performer, tenantIdentifier);
                participationRecord.setPerformer(performerUuid);
                participationRecord.setNamespace(tenantIdentifier);
                this.participations.add(participationRecord);
            }
        }
        if (eventContext.getOtherContext() != null && CollectionUtils.isNotEmpty((Collection)eventContext.getOtherContext().getItems())) {
            this.eventContextRecord.setOtherContext(JSONB.valueOf((String)new RawJson().marshal((RMObject)eventContext.getOtherContext())));
        }
    }

    @Override
    public UUID commit(Timestamp transactionTime) {
        int result;
        this.eventContextRecord.setSysTransaction(transactionTime);
        InsertQuery insertQuery = this.getContext().insertQuery((Table)Tables.EVENT_CONTEXT);
        insertQuery.addValue((Field)Tables.EVENT_CONTEXT.ID, (Object)this.eventContextRecord.getId());
        insertQuery.addValue((Field)Tables.EVENT_CONTEXT.COMPOSITION_ID, (Object)this.eventContextRecord.getCompositionId());
        insertQuery.addValue((Field)Tables.EVENT_CONTEXT.START_TIME, (Object)this.eventContextRecord.getStartTime());
        insertQuery.addValue((Field)Tables.EVENT_CONTEXT.START_TIME_TZID, (Object)this.eventContextRecord.getStartTimeTzid());
        insertQuery.addValue((Field)Tables.EVENT_CONTEXT.END_TIME, (Object)this.eventContextRecord.getEndTime());
        insertQuery.addValue((Field)Tables.EVENT_CONTEXT.END_TIME_TZID, (Object)this.eventContextRecord.getEndTimeTzid());
        insertQuery.addValue((Field)Tables.EVENT_CONTEXT.FACILITY, (Object)this.eventContextRecord.getFacility());
        insertQuery.addValue((Field)Tables.EVENT_CONTEXT.LOCATION, (Object)this.eventContextRecord.getLocation());
        insertQuery.addValue((Field)Tables.EVENT_CONTEXT.NAMESPACE, (Object)this.eventContextRecord.getNamespace());
        if (this.eventContextRecord.getOtherContext() != null) {
            insertQuery.addValue((Field)Tables.EVENT_CONTEXT.OTHER_CONTEXT, (Object)this.eventContextRecord.getOtherContext());
        }
        insertQuery.addValue((Field)Tables.EVENT_CONTEXT.SETTING, (Object)this.eventContextRecord.getSetting());
        insertQuery.addValue((Field)Tables.EVENT_CONTEXT.SYS_TRANSACTION, (Object)this.eventContextRecord.getSysTransaction());
        try {
            result = insertQuery.execute();
        }
        catch (DataAccessException e) {
            throw new InternalServerException("Problem executing database operation", (Throwable)e);
        }
        if (result < 1) {
            throw new IllegalArgumentException("Context commit failed");
        }
        if (!this.participations.isEmpty()) {
            this.participations.forEach(participation -> {
                participation.setEventContext(this.eventContextRecord.getId());
                participation.setSysTransaction(transactionTime);
                participation.store();
            });
        }
        return this.eventContextRecord.getId();
    }

    @Override
    public UUID commit() {
        return this.commit(TransactionTime.millis());
    }

    @Override
    public Boolean update(Timestamp transactionTime) {
        boolean result;
        this.getContext().deleteFrom((Table)Tables.PARTICIPATION).where(Tables.PARTICIPATION.EVENT_CONTEXT.eq((Object)this.getId())).execute();
        for (ParticipationRecord participationRecord : this.participations) {
            participationRecord.setSysTransaction(transactionTime);
            try {
                participationRecord.setId(UuidGenerator.randomUUID());
                participationRecord.store();
            }
            catch (DataAccessException e) {
                throw new InternalServerException(DB_INCONSISTENCY, (Throwable)e);
            }
        }
        this.eventContextRecord.changed((Field)Tables.EVENT_CONTEXT.SYS_PERIOD, false);
        this.eventContextRecord.setSysTransaction(transactionTime);
        UpdateQuery updateQuery = this.getContext().updateQuery((Table)Tables.EVENT_CONTEXT);
        updateQuery.addValue((Field)Tables.EVENT_CONTEXT.COMPOSITION_ID, (Object)this.eventContextRecord.getCompositionId());
        updateQuery.addValue((Field)Tables.EVENT_CONTEXT.START_TIME, (Object)this.eventContextRecord.getStartTime());
        updateQuery.addValue((Field)Tables.EVENT_CONTEXT.START_TIME_TZID, (Object)this.eventContextRecord.getStartTimeTzid());
        updateQuery.addValue((Field)Tables.EVENT_CONTEXT.END_TIME, (Object)this.eventContextRecord.getEndTime());
        updateQuery.addValue((Field)Tables.EVENT_CONTEXT.END_TIME_TZID, (Object)this.eventContextRecord.getEndTimeTzid());
        updateQuery.addValue((Field)Tables.EVENT_CONTEXT.FACILITY, (Object)this.eventContextRecord.getFacility());
        updateQuery.addValue((Field)Tables.EVENT_CONTEXT.LOCATION, (Object)this.eventContextRecord.getLocation());
        if (this.eventContextRecord.getOtherContext() != null) {
            updateQuery.addValue((Field)Tables.EVENT_CONTEXT.OTHER_CONTEXT, (Object)this.eventContextRecord.getOtherContext());
        }
        updateQuery.addValue((Field)Tables.EVENT_CONTEXT.SETTING, (Object)this.eventContextRecord.getSetting());
        updateQuery.addValue((Field)Tables.EVENT_CONTEXT.SYS_TRANSACTION, (Object)this.eventContextRecord.getSysTransaction());
        updateQuery.addConditions(Tables.EVENT_CONTEXT.ID.eq((Object)this.getId()));
        try {
            result = updateQuery.execute() > 0;
        }
        catch (DataAccessException e) {
            throw new InternalServerException("Problem when updating DB entry", (Throwable)e);
        }
        return result;
    }

    @Override
    public Boolean update(Timestamp transactionTime, boolean force) {
        if (force) {
            this.eventContextRecord.changed(true);
            this.eventContextRecord.changed((Field)Tables.EVENT_CONTEXT.SYS_PERIOD, false);
            for (ParticipationRecord participationRecord : this.participations) {
                participationRecord.changed(true);
                participationRecord.changed((Field)Tables.PARTICIPATION.SYS_PERIOD, false);
            }
        }
        return this.update(transactionTime);
    }

    @Override
    @Deprecated
    public Boolean update() {
        throw new InternalServerException("INTERNAL: Invalid updateComposition call to updateComposition without Transaction time and/or force flag arguments");
    }

    @Override
    @Deprecated
    public Boolean update(Boolean force) {
        throw new InternalServerException("INTERNAL: Invalid updateComposition call to updateComposition without Transaction time and/or force flag arguments");
    }

    @Override
    public Integer delete() {
        int count = 0;
        count += this.getContext().delete((Table)Tables.PARTICIPATION).where(Tables.PARTICIPATION.EVENT_CONTEXT.eq((Object)this.eventContextRecord.getId())).execute();
        return count += this.eventContextRecord.delete();
    }

    @Override
    public EventContext mapRmEventContext() {
        PartyIdentifiedRecord partyIdentifiedRecord = (PartyIdentifiedRecord)this.getContext().fetchOne((Table)Tables.PARTY_IDENTIFIED, Tables.PARTY_IDENTIFIED.ID.eq((Object)this.eventContextRecord.getFacility()));
        PartyIdentified healthCareFacility = null;
        if (partyIdentifiedRecord != null) {
            ArrayList<DvIdentifier> identifiers = new ArrayList<DvIdentifier>();
            this.getContext().fetch((Table)Tables.IDENTIFIER, Tables.IDENTIFIER.PARTY.eq((Object)partyIdentifiedRecord.getId())).forEach(record -> {
                DvIdentifier dvIdentifier = new DvIdentifier();
                dvIdentifier.setIssuer(record.getIssuer());
                dvIdentifier.setAssigner(record.getAssigner());
                dvIdentifier.setId(record.getIdValue());
                dvIdentifier.setType(record.getTypeName());
                identifiers.add(dvIdentifier);
            });
            healthCareFacility = ContextAccess.getPartyIdentifiedFromRecord(partyIdentifiedRecord, identifiers);
        }
        ArrayList participationList = new ArrayList();
        this.getContext().fetch((Table)Tables.PARTICIPATION, Tables.PARTICIPATION.EVENT_CONTEXT.eq((Object)this.eventContextRecord.getId())).forEach(participationRecord -> {
            PartyProxy performer = new PersistedPartyProxy(this).retrieve(participationRecord.getPerformer());
            DvInterval<DvDateTime> startTime = ContextAccess.getStartTimeInterval(participationRecord);
            DvCodedText mode = participationRecord.getMode() != null ? (DvCodedText)new RecordedDvCodedText().fromDB((Record)participationRecord, (Field<DvCodedTextRecord>)Tables.PARTICIPATION.MODE) : null;
            Participation participation = new Participation(performer, (DvText)new RecordedDvCodedText().fromDB((Record)participationRecord, (Field<DvCodedTextRecord>)Tables.PARTICIPATION.FUNCTION), mode, startTime);
            participationList.add(participation);
        });
        DvCodedText concept = (DvCodedText)new RecordedDvCodedText().fromDB((Record)this.eventContextRecord, (Field<DvCodedTextRecord>)Tables.EVENT_CONTEXT.SETTING);
        ItemStructure otherContext = null;
        if (this.eventContextRecord.getOtherContext() != null) {
            otherContext = (ItemStructure)new RawJson().unmarshal(this.eventContextRecord.getOtherContext().data(), ItemStructure.class);
        }
        return new EventContext(healthCareFacility, new RecordedDvDateTime().decodeDvDateTime(this.eventContextRecord.getStartTime(), this.eventContextRecord.getStartTimeTzid()), new RecordedDvDateTime().decodeDvDateTime(this.eventContextRecord.getEndTime(), this.eventContextRecord.getEndTimeTzid()), participationList.isEmpty() ? null : participationList, this.eventContextRecord.getLocation(), concept, otherContext);
    }

    private static DvInterval<DvDateTime> getStartTimeInterval(ParticipationHistoryRecord historyRecord) {
        if (historyRecord.getTimeLower() != null) {
            return new DvInterval((DvOrdered)new RecordedDvDateTime().decodeDvDateTime(historyRecord.getTimeLower(), historyRecord.getTimeLowerTz()), (DvOrdered)new RecordedDvDateTime().decodeDvDateTime(historyRecord.getTimeUpper(), historyRecord.getTimeUpperTz()));
        }
        return null;
    }

    private static DvInterval<DvDateTime> getStartTimeInterval(ParticipationRecord participationRecord) {
        if (participationRecord.getTimeLower() != null) {
            return new DvInterval((DvOrdered)new RecordedDvDateTime().decodeDvDateTime(participationRecord.getTimeLower(), participationRecord.getTimeLowerTz()), (DvOrdered)new RecordedDvDateTime().decodeDvDateTime(participationRecord.getTimeUpper(), participationRecord.getTimeUpperTz()));
        }
        return null;
    }

    @Override
    public String getOtherContextJson() {
        if (this.eventContextRecord.getOtherContext() == null) {
            return null;
        }
        return this.eventContextRecord.getOtherContext().data();
    }

    @Override
    public void setCompositionId(UUID compositionId) {
        this.eventContextRecord.setCompositionId(compositionId);
    }

    @Override
    public UUID getId() {
        return this.eventContextRecord.getId();
    }

    @Override
    public boolean isVoid() {
        return this.eventContextRecord == null;
    }

    @Override
    public DataAccess getDataAccess() {
        return this;
    }
}

