/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.ehr.knowledge;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.ehrbase.aql.containment.JsonPathQueryResult;
import org.ehrbase.ehr.knowledge.TemplateMetaData;
import org.ehrbase.webtemplate.parser.NodeId;
import org.openehr.schemas.v1.OPERATIONALTEMPLATE;

public interface I_KnowledgeCache {
    public static final String TEMPLATE_ID = "templateId";

    public Set<String> getAllTemplateIds();

    public String addOperationalTemplate(InputStream var1, String var2);

    public String addOperationalTemplate(OPERATIONALTEMPLATE var1, String var2);

    public List<TemplateMetaData> listAllOperationalTemplates() throws IOException;

    public Optional<OPERATIONALTEMPLATE> retrieveOperationalTemplate(String var1);

    public Optional<OPERATIONALTEMPLATE> retrieveOperationalTemplate(UUID var1);

    public boolean deleteOperationalTemplate(OPERATIONALTEMPLATE var1);

    public JsonPathQueryResult resolveForTemplate(String var1, Collection<NodeId> var2);

    public ConceptValue getConceptByConceptId(int var1, String var2, BiFunction<Integer, String, ConceptValue> var3);

    public ConceptValue getConceptById(UUID var1, Function<UUID, ConceptValue> var2);

    public ConceptValue getConceptByDescription(String var1, String var2, BiFunction<String, String, ConceptValue> var3);

    public TerritoryValue getTerritoryCodeByTwoLetterCode(String var1, Function<String, TerritoryValue> var2);

    public LanguageValue getLanguageByCode(String var1, Function<String, LanguageValue> var2);

    public static class TerritoryValue
    implements Serializable {
        private final int code;
        private final String twoletter;
        private final String threeletter;
        private final String text;

        public TerritoryValue(int code, String twoletter, String threeletter, String text) {
            this.code = code;
            this.twoletter = twoletter;
            this.threeletter = threeletter;
            this.text = text;
        }

        public int getCode() {
            return this.code;
        }

        public String getTwoletter() {
            return this.twoletter;
        }

        public String getThreeletter() {
            return this.threeletter;
        }

        public String getText() {
            return this.text;
        }
    }

    public static class LanguageValue
    implements Serializable {
        private final String code;
        private final String description;

        public LanguageValue(String code, String description) {
            this.code = code;
            this.description = description;
        }

        public String getCode() {
            return this.code;
        }

        public String getDescription() {
            return this.description;
        }
    }

    public static class ConceptValue
    implements Serializable {
        private final UUID id;
        private final int conceptId;
        private final String description;
        private final String language;

        public ConceptValue(UUID id, int conceptId, String description, String language) {
            this.id = id;
            this.conceptId = conceptId;
            this.description = description;
            this.language = language;
        }

        public UUID getId() {
            return this.id;
        }

        public int getConceptId() {
            return this.conceptId;
        }

        public String getDescription() {
            return this.description;
        }

        public String getLanguage() {
            return this.language;
        }
    }
}

