/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.repository;

import com.nedap.archie.rm.datavalues.DvCodedText;
import com.nedap.archie.rm.datavalues.DvText;
import com.nedap.archie.rm.generic.AuditDetails;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Optional;
import java.util.UUID;
import org.ehrbase.api.exception.UnexpectedSwitchCaseException;
import org.ehrbase.api.service.TenantService;
import org.ehrbase.jooq.pg.enums.ContributionChangeType;
import org.ehrbase.jooq.pg.enums.ContributionDataType;
import org.ehrbase.jooq.pg.enums.ContributionState;
import org.ehrbase.jooq.pg.tables.Contribution;
import org.ehrbase.jooq.pg.tables.records.AuditDetailsRecord;
import org.ehrbase.jooq.pg.tables.records.ContributionRecord;
import org.ehrbase.service.IUserService;
import org.ehrbase.service.PartyService;
import org.ehrbase.service.SystemService;
import org.ehrbase.util.UuidGenerator;
import org.jooq.DSLContext;
import org.jooq.Table;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class ContributionRepository {
    private final DSLContext context;
    private final SystemService systemService;
    private final IUserService userService;
    private final PartyService partyService;
    private final TenantService tenantService;

    public ContributionRepository(DSLContext context, SystemService systemService, IUserService userService, PartyService partyService, TenantService tenantService) {
        this.context = context;
        this.systemService = systemService;
        this.userService = userService;
        this.partyService = partyService;
        this.tenantService = tenantService;
    }

    @Transactional
    public UUID createDefault(UUID ehrId, ContributionDataType contributionType, ContributionChangeType contributionChangeType) {
        UUID auditDetailsRecordId = this.createDefaultAudit(contributionChangeType);
        ContributionRecord contributionRecord = (ContributionRecord)this.context.newRecord((Table)Contribution.CONTRIBUTION);
        contributionRecord.setId(UuidGenerator.randomUUID());
        contributionRecord.setEhrId(ehrId);
        contributionRecord.setContributionType(contributionType);
        contributionRecord.setState(ContributionState.complete);
        contributionRecord.setHasAudit(auditDetailsRecordId);
        contributionRecord.setNamespace(this.tenantService.getCurrentTenantIdentifier());
        contributionRecord.store();
        return contributionRecord.getId();
    }

    @Transactional
    public UUID createDefaultAudit(ContributionChangeType contributionChangeType) {
        AuditDetailsRecord auditDetailsRecord = (AuditDetailsRecord)this.context.newRecord((Table)org.ehrbase.jooq.pg.tables.AuditDetails.AUDIT_DETAILS);
        auditDetailsRecord.setId(UuidGenerator.randomUUID());
        auditDetailsRecord.setTimeCommitted(Timestamp.from(Instant.now()));
        auditDetailsRecord.setTimeCommittedTzid(ZonedDateTime.now().getZone().getId());
        auditDetailsRecord.setSystemId(this.systemService.getSystemUuid());
        auditDetailsRecord.setCommitter(this.userService.getCurrentUserId());
        auditDetailsRecord.setChangeType(contributionChangeType);
        auditDetailsRecord.setNamespace(this.tenantService.getCurrentTenantIdentifier());
        auditDetailsRecord.store();
        return auditDetailsRecord.getId();
    }

    @Transactional
    public UUID createAudit(AuditDetails auditDetails) {
        AuditDetailsRecord auditDetailsRecord = (AuditDetailsRecord)this.context.newRecord((Table)org.ehrbase.jooq.pg.tables.AuditDetails.AUDIT_DETAILS);
        auditDetailsRecord.setId(UuidGenerator.randomUUID());
        auditDetailsRecord.setTimeCommitted(Timestamp.from(Instant.now()));
        auditDetailsRecord.setTimeCommittedTzid(ZonedDateTime.now().getZone().getId());
        auditDetailsRecord.setSystemId(this.systemService.getSystemUuid());
        auditDetailsRecord.setCommitter(this.partyService.findOrCreateParty(auditDetails.getCommitter()));
        auditDetailsRecord.setChangeType(this.to(auditDetails.getChangeType()));
        auditDetailsRecord.setDescription((String)Optional.ofNullable(auditDetails.getDescription()).map(DvText::getValue).orElse(null));
        auditDetailsRecord.setNamespace(this.tenantService.getCurrentTenantIdentifier());
        auditDetailsRecord.store();
        return auditDetailsRecord.getId();
    }

    private ContributionChangeType to(DvCodedText changeType) {
        return switch (changeType.getDefiningCode().getCodeString()) {
            case "249" -> ContributionChangeType.creation;
            case "250" -> ContributionChangeType.amendment;
            case "251" -> ContributionChangeType.modification;
            case "252" -> ContributionChangeType.synthesis;
            case "253" -> ContributionChangeType.Unknown;
            case "523" -> ContributionChangeType.deleted;
            default -> throw new UnexpectedSwitchCaseException(changeType.toString());
        };
    }
}

