/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.service;

import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.changecontrol.OriginalVersion;
import com.nedap.archie.rm.composition.Composition;
import com.nedap.archie.rm.datatypes.CodePhrase;
import com.nedap.archie.rm.datavalues.DvCodedText;
import com.nedap.archie.rm.datavalues.quantity.datetime.DvDateTime;
import com.nedap.archie.rm.ehr.VersionedComposition;
import com.nedap.archie.rm.generic.Attestation;
import com.nedap.archie.rm.generic.AuditDetails;
import com.nedap.archie.rm.generic.RevisionHistory;
import com.nedap.archie.rm.generic.RevisionHistoryItem;
import com.nedap.archie.rm.support.identification.HierObjectId;
import com.nedap.archie.rm.support.identification.ObjectId;
import com.nedap.archie.rm.support.identification.ObjectRef;
import com.nedap.archie.rm.support.identification.ObjectVersionId;
import com.nedap.archie.rm.support.identification.UIDBasedId;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.ehrbase.api.definitions.ServerConfig;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.api.exception.InvalidApiParameterException;
import org.ehrbase.api.exception.ObjectNotFoundException;
import org.ehrbase.api.exception.PreconditionFailedException;
import org.ehrbase.api.exception.UnexpectedSwitchCaseException;
import org.ehrbase.api.exception.UnprocessableEntityException;
import org.ehrbase.api.exception.ValidationException;
import org.ehrbase.api.service.CompositionService;
import org.ehrbase.api.service.EhrService;
import org.ehrbase.api.service.TenantService;
import org.ehrbase.api.service.ValidationService;
import org.ehrbase.dao.access.interfaces.I_AttestationAccess;
import org.ehrbase.dao.access.interfaces.I_CompositionAccess;
import org.ehrbase.dao.access.interfaces.I_ConceptAccess;
import org.ehrbase.dao.access.interfaces.I_DomainAccess;
import org.ehrbase.dao.access.interfaces.I_EntryAccess;
import org.ehrbase.dao.access.jooq.AttestationAccess;
import org.ehrbase.jooq.pg.Tables;
import org.ehrbase.response.ehrscape.CompositionDto;
import org.ehrbase.response.ehrscape.CompositionFormat;
import org.ehrbase.response.ehrscape.StructuredString;
import org.ehrbase.response.ehrscape.StructuredStringFormat;
import org.ehrbase.serialisation.flatencoding.FlatFormat;
import org.ehrbase.serialisation.flatencoding.FlatJasonProvider;
import org.ehrbase.serialisation.jsonencoding.CanonicalJson;
import org.ehrbase.serialisation.xmlencoding.CanonicalXML;
import org.ehrbase.service.BaseServiceImp;
import org.ehrbase.service.KnowledgeCacheService;
import org.ehrbase.webtemplate.model.WebTemplate;
import org.ehrbase.webtemplate.templateprovider.TemplateProvider;
import org.jooq.DSLContext;
import org.jooq.Table;
import org.openehr.schemas.v1.OPERATIONALTEMPLATE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class CompositionServiceImp
extends BaseServiceImp
implements CompositionService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ValidationService validationService;
    private final KnowledgeCacheService knowledgeCacheService;
    private final EhrService ehrService;
    private final TenantService tenantService;

    public CompositionServiceImp(KnowledgeCacheService knowledgeCacheService, ValidationService validationService, EhrService ehrService, DSLContext context, ServerConfig serverConfig, TenantService tenantService) {
        super(knowledgeCacheService, context, serverConfig);
        this.validationService = validationService;
        this.ehrService = ehrService;
        this.knowledgeCacheService = knowledgeCacheService;
        this.tenantService = tenantService;
    }

    public Optional<UUID> create(UUID ehrId, Composition objData, UUID systemId, UUID committerId, String description) {
        UUID compositionId = this.createInternal(ehrId, objData, systemId, committerId, description, null, null);
        return Optional.of(compositionId);
    }

    public Optional<UUID> create(UUID ehrId, Composition objData, UUID contribution, UUID audit) {
        UUID compositionId = this.createInternal(ehrId, objData, null, null, null, contribution, audit);
        return Optional.of(compositionId);
    }

    public Optional<UUID> create(UUID ehrId, Composition objData) {
        return this.create(ehrId, objData, this.getSystemUuid(), this.getCurrentUserId(), null);
    }

    private UUID createInternal(UUID ehrId, Composition composition, UUID systemId, UUID committerId, String description, UUID contributionId, UUID audit) {
        UUID compositionId;
        this.ehrService.checkEhrExistsAndIsModifiable(ehrId);
        try {
            this.validationService.check(composition);
        }
        catch (org.ehrbase.validation.ValidationException e) {
            throw new UnprocessableEntityException(e.getMessage());
        }
        catch (UnprocessableEntityException | ValidationException e) {
            throw e;
        }
        catch (IllegalArgumentException e) {
            throw new ValidationException((Exception)e);
        }
        catch (Exception e) {
            throw new InternalServerException((Throwable)e);
        }
        UIDBasedId uIDBasedId = composition.getUid();
        if (uIDBasedId instanceof ObjectVersionId) {
            ObjectVersionId objectVersionId = (ObjectVersionId)uIDBasedId;
            if (!"1".equals(objectVersionId.getVersionTreeId().getValue())) {
                throw new PreconditionFailedException("Provided Id %s has a invalid Version. Expect Version 1".formatted(composition.getUid()));
            }
            if (!Objects.equals(this.getDataAccess().getServerConfig().getNodename(), objectVersionId.getCreatingSystemId().getValue())) {
                throw new PreconditionFailedException("Mismatch of creating_system_id: %s !=: %s".formatted(objectVersionId.getCreatingSystemId().getValue(), this.getDataAccess().getServerConfig().getNodename()));
            }
            I_DomainAccess domainAccess = this.getDataAccess();
            UUID versionedObjectId = UUID.fromString(objectVersionId.getObjectId().getValue());
            if (domainAccess.getContext().fetchExists((Table)Tables.COMPOSITION, Tables.COMPOSITION.ID.eq((Object)versionedObjectId)) || domainAccess.getContext().fetchExists((Table)Tables.COMPOSITION_HISTORY, Tables.COMPOSITION_HISTORY.ID.eq((Object)versionedObjectId))) {
                throw new PreconditionFailedException("Provided Id %s already exists".formatted(composition.getUid()));
            }
        } else if (composition.getUid() != null) {
            throw new PreconditionFailedException("Provided Id %s is not a ObjectVersionId".formatted(composition.getUid()));
        }
        String tenantIdentifier = this.tenantService.getCurrentTenantIdentifier();
        try {
            I_CompositionAccess compositionAccess = I_CompositionAccess.getNewInstance(this.getDataAccess(), composition, ehrId, tenantIdentifier);
            I_EntryAccess entryAccess = I_EntryAccess.getNewInstance(this.getDataAccess(), Objects.requireNonNull(composition.getArchetypeDetails().getTemplateId()).getValue(), 0, compositionAccess.getId(), composition, tenantIdentifier);
            compositionAccess.setContent(entryAccess);
            if (contributionId != null) {
                compositionAccess.setContributionId(contributionId);
                compositionId = compositionAccess.commit(LocalDateTime.now(), contributionId, audit);
            } else {
                if (committerId == null || systemId == null) {
                    throw new InternalServerException("Error on internal contribution handling for composition creation.");
                }
                compositionId = compositionAccess.commit(LocalDateTime.now(), committerId, systemId, description);
            }
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalServerException((Throwable)e);
        }
        this.logger.debug("Composition created: id={}", (Object)compositionId);
        return compositionId;
    }

    public Optional<UUID> update(UUID ehrId, ObjectVersionId targetObjId, Composition objData, UUID systemId, UUID committerId, String description) {
        UUID compoId = this.internalUpdate(ehrId, UUID.fromString(targetObjId.getObjectId().getValue()), objData, systemId, committerId, description, null, null);
        return Optional.of(compoId);
    }

    public Optional<UUID> update(UUID ehrId, ObjectVersionId targetObjId, Composition objData, UUID contribution, UUID audit) {
        UUID compoId = this.internalUpdate(ehrId, UUID.fromString(targetObjId.getObjectId().getValue()), objData, null, null, null, contribution, audit);
        return Optional.of(compoId);
    }

    public Optional<UUID> update(UUID ehrId, ObjectVersionId targetObjId, Composition objData) {
        return this.update(ehrId, targetObjId, objData, this.getSystemUuid(), this.getCurrentUserId(), null);
    }

    private UUID internalUpdate(UUID ehrId, UUID compositionId, Composition composition, UUID systemId, UUID committerId, String description, UUID contributionId, UUID audit) {
        boolean result;
        this.ehrService.checkEhrExistsAndIsModifiable(ehrId);
        try {
            I_CompositionAccess compositionAccess = I_CompositionAccess.retrieveInstance(this.getDataAccess(), compositionId);
            if (compositionAccess == null) {
                throw new ObjectNotFoundException(I_CompositionAccess.class.getName(), "Could not find composition: " + compositionId);
            }
            this.checkCompositionIsInEhr(ehrId, compositionAccess);
            this.validationService.check(composition);
            String existingTemplateId = compositionAccess.getContent().getTemplateId();
            String inputTemplateId = composition.getArchetypeDetails().getTemplateId().getValue();
            if (!existingTemplateId.equals(inputTemplateId)) {
                if (!existingTemplateId.split("\\.")[0].equals(inputTemplateId.split("\\.")[0])) {
                    throw new InvalidApiParameterException("Can't update composition to have different template.");
                }
                int existingTemplateIdVersion = Integer.parseInt(existingTemplateId.split("\\.v")[1]);
                int inputTemplateIdVersion = Integer.parseInt(inputTemplateId.substring(inputTemplateId.lastIndexOf("\\.v") + 1));
                if (inputTemplateIdVersion < existingTemplateIdVersion) {
                    throw new InvalidApiParameterException("Can't update composition with wrong template version bump.");
                }
            }
            I_EntryAccess content = compositionAccess.getContent();
            content.setCompositionData(composition);
            compositionAccess.setContent(content);
            compositionAccess.setComposition(composition);
            if (contributionId != null) {
                compositionAccess.setContributionId(contributionId);
                result = compositionAccess.update(LocalDateTime.now(), contributionId, audit);
            } else {
                if (committerId == null || systemId == null) {
                    throw new InternalServerException("Failed to update composition, missing mandatory audit meta data.");
                }
                result = compositionAccess.update(LocalDateTime.now(), committerId, systemId, description, I_ConceptAccess.ContributionChangeType.MODIFICATION);
            }
        }
        catch (InvalidApiParameterException | ObjectNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalServerException((Throwable)e);
        }
        if (!result) {
            throw new InternalServerException("Update failed on composition:" + compositionId);
        }
        return compositionId;
    }

    private void checkCompositionIsInEhr(UUID ehrId, I_CompositionAccess compositionAccess) {
        if (!ehrId.equals(compositionAccess.getEhrid())) {
            throw new ObjectNotFoundException("COMPOSITION", String.format("EHR with id %s does not contain composition with id %s", ehrId, compositionAccess.getEhrid()));
        }
    }

    public void delete(UUID ehrId, ObjectVersionId targetObjId, UUID systemId, UUID committerId, String description) {
        this.internalDelete(ehrId, UUID.fromString(targetObjId.getObjectId().getValue()), systemId, committerId, description, null, null);
    }

    public void delete(UUID ehrId, ObjectVersionId targetObjId, UUID contribution, UUID audit) {
        this.internalDelete(ehrId, UUID.fromString(targetObjId.getObjectId().getValue()), null, null, null, contribution, audit);
    }

    public void delete(UUID ehrId, ObjectVersionId targetObjId) {
        this.delete(ehrId, targetObjId, this.getSystemUuid(), this.getCurrentUserId(), null);
    }

    private void internalDelete(UUID ehrId, UUID compositionId, UUID systemId, UUID committerId, String description, UUID contributionId, UUID audit) {
        int result;
        I_CompositionAccess compositionAccess;
        this.ehrService.checkEhrExistsAndIsModifiable(ehrId);
        try {
            compositionAccess = I_CompositionAccess.retrieveInstance(this.getDataAccess(), compositionId);
        }
        catch (Exception e) {
            throw new ObjectNotFoundException(I_CompositionAccess.class.getName(), "Error while retrieving composition", (Throwable)e);
        }
        if (compositionAccess == null) {
            throw new ObjectNotFoundException(I_CompositionAccess.class.getName(), "Could not find composition:" + compositionId);
        }
        this.checkCompositionIsInEhr(ehrId, compositionAccess);
        if (contributionId != null) {
            compositionAccess.setContributionId(contributionId);
            try {
                result = compositionAccess.delete(LocalDateTime.now(), contributionId, audit);
            }
            catch (Exception e) {
                throw new InternalServerException((Throwable)e);
            }
        }
        try {
            if (committerId == null || systemId == null) {
                throw new InternalServerException("Failed to update composition, missing mandatory audit meta data.");
            }
            result = compositionAccess.delete(LocalDateTime.now(), committerId, systemId, description);
        }
        catch (Exception e) {
            throw new InternalServerException((Throwable)e);
        }
        if (result <= 0) {
            throw new InternalServerException("Delete failed on composition:" + compositionAccess.getId());
        }
    }

    public Optional<Composition> retrieve(UUID ehrId, UUID compositionId, Integer version) throws InternalServerException {
        this.ehrService.checkEhrExists(ehrId);
        I_CompositionAccess compositionAccess = version != null ? I_CompositionAccess.retrieveCompositionVersion(this.getDataAccess(), compositionId, version) : I_CompositionAccess.retrieveCompositionVersion(this.getDataAccess(), compositionId, this.getLastVersionNumber(compositionId));
        if (compositionAccess != null) {
            this.checkCompositionIsInEhr(ehrId, compositionAccess);
        }
        return this.getComposition(compositionAccess);
    }

    public UUID getEhrId(UUID compositionId) {
        return I_CompositionAccess.getEhrId(this.getDataAccess(), compositionId);
    }

    private Optional<Composition> getComposition(I_CompositionAccess compositionAccess) {
        return Optional.ofNullable(compositionAccess).map(I_CompositionAccess::getContent).map(I_EntryAccess::getComposition);
    }

    public StructuredString serialize(CompositionDto composition, CompositionFormat format) {
        return switch (format) {
            case CompositionFormat.XML -> new StructuredString(new CanonicalXML().marshal((RMObject)composition.getComposition(), Boolean.valueOf(false)), StructuredStringFormat.XML);
            case CompositionFormat.JSON -> new StructuredString(new CanonicalJson().marshal((RMObject)composition.getComposition()), StructuredStringFormat.JSON);
            case CompositionFormat.FLAT -> new StructuredString(new FlatJasonProvider(new TemplateProvider(){

                public Optional<OPERATIONALTEMPLATE> find(String s) {
                    return CompositionServiceImp.this.knowledgeCacheService.retrieveOperationalTemplate(s);
                }

                public Optional<WebTemplate> buildIntrospect(String templateId) {
                    return Optional.ofNullable(CompositionServiceImp.this.knowledgeCacheService.getQueryOptMetaData(templateId));
                }
            }).buildFlatJson(FlatFormat.SIM_SDT, composition.getTemplateId()).marshal((RMObject)composition.getComposition()), StructuredStringFormat.JSON);
            case CompositionFormat.STRUCTURED -> new StructuredString(new FlatJasonProvider(new TemplateProvider(){

                public Optional<OPERATIONALTEMPLATE> find(String s) {
                    return CompositionServiceImp.this.knowledgeCacheService.retrieveOperationalTemplate(s);
                }

                public Optional<WebTemplate> buildIntrospect(String templateId) {
                    return Optional.ofNullable(CompositionServiceImp.this.knowledgeCacheService.getQueryOptMetaData(templateId));
                }
            }).buildFlatJson(FlatFormat.STRUCTURED, composition.getTemplateId()).marshal((RMObject)composition.getComposition()), StructuredStringFormat.JSON);
            default -> throw new UnexpectedSwitchCaseException((Enum)format);
        };
    }

    public Composition buildComposition(String content, CompositionFormat format, String templateId) {
        return switch (format) {
            case CompositionFormat.XML -> (Composition)new CanonicalXML().unmarshal(content, Composition.class);
            case CompositionFormat.JSON -> (Composition)new CanonicalJson().unmarshal(content, Composition.class);
            case CompositionFormat.FLAT -> new FlatJasonProvider(new TemplateProvider(){

                public Optional<OPERATIONALTEMPLATE> find(String s) {
                    return CompositionServiceImp.this.knowledgeCacheService.retrieveOperationalTemplate(s);
                }

                public Optional<WebTemplate> buildIntrospect(String templateId) {
                    return Optional.ofNullable(CompositionServiceImp.this.knowledgeCacheService.getQueryOptMetaData(templateId));
                }
            }).buildFlatJson(FlatFormat.SIM_SDT, templateId).unmarshal(content);
            case CompositionFormat.STRUCTURED -> new FlatJasonProvider(new TemplateProvider(){

                public Optional<OPERATIONALTEMPLATE> find(String s) {
                    return CompositionServiceImp.this.knowledgeCacheService.retrieveOperationalTemplate(s);
                }

                public Optional<WebTemplate> buildIntrospect(String templateId) {
                    return Optional.ofNullable(CompositionServiceImp.this.knowledgeCacheService.getQueryOptMetaData(templateId));
                }
            }).buildFlatJson(FlatFormat.STRUCTURED, templateId).unmarshal(content);
            default -> throw new UnexpectedSwitchCaseException((Enum)format);
        };
    }

    public Integer getLastVersionNumber(UUID compositionId) throws InternalServerException {
        try {
            return I_CompositionAccess.getLastVersionNumber(this.getDataAccess(), compositionId);
        }
        catch (Exception e) {
            throw new InternalServerException((Throwable)e);
        }
    }

    public Integer getVersionByTimestamp(UUID compositionId, LocalDateTime timestamp) {
        int version;
        try {
            version = I_CompositionAccess.getVersionFromTimeStamp(this.getDataAccess(), compositionId, Timestamp.valueOf(timestamp));
        }
        catch (ObjectNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalServerException((Throwable)e);
        }
        if (version <= 0) {
            throw new InternalServerException("Invalid version number calculated.");
        }
        return version;
    }

    public String getTemplateIdFromInputComposition(String content, CompositionFormat format) {
        Composition composition = this.buildComposition(content, format, null);
        if (composition.getArchetypeDetails() == null || composition.getArchetypeDetails().getTemplateId() == null) {
            return null;
        }
        return composition.getArchetypeDetails().getTemplateId().getValue();
    }

    public String retrieveTemplateId(UUID compositionId) {
        return I_EntryAccess.getTemplateIdFromEntry(this.getDataAccess(), compositionId);
    }

    public boolean exists(UUID versionedObjectId) {
        return I_CompositionAccess.exists(this.getDataAccess(), versionedObjectId);
    }

    public boolean isDeleted(UUID versionedObjectId) {
        return I_CompositionAccess.isDeleted(this.getDataAccess(), versionedObjectId);
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    public void adminDelete(UUID compositionId) {
        I_CompositionAccess compositionAccess = I_CompositionAccess.retrieveInstance(this.getDataAccess(), compositionId);
        if (compositionAccess != null) {
            compositionAccess.adminDelete();
        }
    }

    public VersionedComposition getVersionedComposition(UUID ehrId, UUID composition) {
        Optional<CompositionDto> dto = this.retrieve(ehrId, composition, 1).map(c -> CompositionService.from((UUID)ehrId, (Composition)c));
        VersionedComposition compo = new VersionedComposition();
        if (dto.isPresent()) {
            compo.setUid(new HierObjectId(dto.get().getUuid().toString()));
            compo.setOwnerId(new ObjectRef((ObjectId)new HierObjectId(dto.get().getEhrId().toString()), "local", "ehr"));
            Map<Integer, I_CompositionAccess> compos = I_CompositionAccess.getVersionMapOfComposition(this.getDataAccess(), composition);
            if (compos.containsKey(1)) {
                compo.setTimeCreated(new DvDateTime((TemporalAccessor)OffsetDateTime.of(compos.get(1).getSysTransaction().toLocalDateTime(), OffsetDateTime.now().getOffset())));
            } else {
                throw new InternalServerException("Inconsistent composition data, no version 1 available");
            }
        }
        return compo;
    }

    public RevisionHistory getRevisionHistoryOfVersionedComposition(UUID ehrUid, UUID composition) {
        int versions = this.getLastVersionNumber(composition);
        RevisionHistory revisionHistory = new RevisionHistory();
        for (int i = 1; i <= versions; ++i) {
            Optional<OriginalVersion<Composition>> compoVersion = this.getOriginalVersionComposition(ehrUid, composition, i);
            compoVersion.ifPresent(compositionOriginalVersion -> revisionHistory.addItem(this.revisionHistoryItemFromComposition((OriginalVersion<Composition>)compositionOriginalVersion)));
        }
        if (revisionHistory.getItems().isEmpty()) {
            throw new InternalServerException("Problem creating RevisionHistory");
        }
        return revisionHistory;
    }

    private RevisionHistoryItem revisionHistoryItemFromComposition(OriginalVersion<Composition> composition) {
        ObjectVersionId objectVersionId = composition.getUid();
        ArrayList<AuditDetails> auditDetailsList = new ArrayList<AuditDetails>();
        auditDetailsList.add(composition.getCommitAudit());
        if (composition.getAttestations() != null) {
            for (Attestation a : composition.getAttestations()) {
                AuditDetails newAudit = new AuditDetails(a.getSystemId(), a.getCommitter(), a.getTimeCommitted(), a.getChangeType(), a.getDescription());
                auditDetailsList.add(newAudit);
            }
        }
        return new RevisionHistoryItem(objectVersionId, auditDetailsList);
    }

    public Optional<OriginalVersion<Composition>> getOriginalVersionComposition(UUID ehrUid, UUID versionedObjectUid, int version) {
        if (version == 0 || I_CompositionAccess.getLastVersionNumber(this.getDataAccess(), versionedObjectUid) < version) {
            throw new ObjectNotFoundException("versioned_composition", "No VERSIONED_COMPOSITION with given version: " + version);
        }
        I_CompositionAccess compositionAccess = I_CompositionAccess.retrieveCompositionVersion(this.getDataAccess(), versionedObjectUid, version);
        if (compositionAccess == null) {
            return Optional.empty();
        }
        ObjectVersionId versionId = new ObjectVersionId(versionedObjectUid + "::" + this.getServerConfig().getNodename() + "::" + version);
        DvCodedText lifecycleState = new DvCodedText("complete", new CodePhrase("532"));
        AuditDetails commitAudit = compositionAccess.getAuditDetailsAccess().getAsAuditDetails();
        ObjectRef contribution = new ObjectRef((ObjectId)new HierObjectId(compositionAccess.getContributionId().toString()), "openehr", "contribution");
        List<UUID> attestationIdList = I_AttestationAccess.retrieveListOfAttestationsByRef(this.getDataAccess(), compositionAccess.getAttestationRef());
        ArrayList<Attestation> attestations = null;
        if (!attestationIdList.isEmpty()) {
            attestations = new ArrayList<Attestation>();
            for (UUID id : attestationIdList) {
                I_AttestationAccess a = new AttestationAccess(this.getDataAccess()).retrieveInstance(id);
                attestations.add(a.getAsAttestation());
            }
        }
        ObjectVersionId precedingVersionId = null;
        if (version > 1) {
            precedingVersionId = new ObjectVersionId(versionedObjectUid + "::" + this.getServerConfig().getNodename() + "::" + (version - 1));
        }
        Optional<Composition> compositionDto = this.retrieve(ehrUid, versionedObjectUid, version);
        Composition composition = null;
        if (compositionDto.isPresent()) {
            composition = compositionDto.get();
        }
        OriginalVersion versionComposition = new OriginalVersion(versionId, precedingVersionId, (Object)composition, lifecycleState, commitAudit, contribution, null, null, attestations);
        return Optional.of(versionComposition);
    }
}

