/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.service;

import com.nedap.archie.rm.generic.PartyProxy;
import java.util.Optional;
import java.util.UUID;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.api.service.TenantService;
import org.ehrbase.repository.PartyProxyRepository;
import org.ehrbase.service.CacheKey;
import org.ehrbase.service.IAuthenticationFacade;
import org.ehrbase.service.IUserService;
import org.ehrbase.service.PartyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Service;

@Service
public class PartyServiceImp
implements IUserService,
PartyService {
    private final IAuthenticationFacade authenticationFacade;
    private final TenantService tenantService;
    private final Cache userIdCache;
    private final PartyProxyRepository partyProxyRepository;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public PartyServiceImp(IAuthenticationFacade authenticationFacade, TenantService tenantService, CacheManager cacheManager, PartyProxyRepository partyProxyRepository) {
        this.authenticationFacade = authenticationFacade;
        this.tenantService = tenantService;
        this.partyProxyRepository = partyProxyRepository;
        this.userIdCache = cacheManager.getCache("userIdCache");
    }

    @Override
    public UUID getCurrentUserId() {
        CacheKey<String> key = CacheKey.of(this.authenticationFacade.getAuthentication().getName(), this.tenantService.getCurrentTenantIdentifier());
        return (UUID)this.userIdCache.get(key, () -> this.getOrCreateCurrentUserIdSync(key));
    }

    private UUID getOrCreateCurrentUserIdSync(CacheKey<String> key) {
        return this.partyProxyRepository.findInternalUserId(key.getVal()).or(() -> {
            try {
                return Optional.of(this.partyProxyRepository.createInternalUser((String)key.getVal()));
            }
            catch (DataIntegrityViolationException ex) {
                this.logger.info(ex.getMessage(), (Object)ex.getMessage());
                return this.partyProxyRepository.findInternalUserId((String)key.getVal());
            }
        }).orElseThrow(() -> new InternalServerException("Cannot create User"));
    }

    @Override
    public UUID findOrCreateParty(PartyProxy partyProxy) {
        return this.partyProxyRepository.findMatching(partyProxy).orElse(this.partyProxyRepository.create(partyProxy));
    }
}

