/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.tenant;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.ehrbase.api.annotations.TenantAware;
import org.ehrbase.api.aspect.TenantAspect;
import org.ehrbase.api.tenant.TenantAuthentication;
import org.ehrbase.api.tenant.TenantIdExtractionStrategy;
import org.ehrbase.tenant.DefaultTenantAuthentication;
import org.springframework.aop.aspectj.MethodInvocationProceedingJoinPoint;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

@Aspect
public class DefaultTenantAspect
implements TenantAspect {
    private List<TenantIdExtractionStrategy<?>> extractionStrategies;
    private static final Comparator<TenantIdExtractionStrategy<?>> PRIORITY_SORT = (s1, s2) -> s1.priority() - s2.priority();
    private static final String ERR_NON_TENANT_ID = "Fatal error, no tenant id avaliable";

    public DefaultTenantAspect() {
        this(new ArrayList());
    }

    public DefaultTenantAspect(List<TenantIdExtractionStrategy<?>> extractionStrategies) {
        extractionStrategies.sort(PRIORITY_SORT);
        this.extractionStrategies = extractionStrategies;
    }

    public <T> void addExtractionStrategy(TenantIdExtractionStrategy<T> strategy) {
        this.extractionStrategies.add(strategy);
        this.extractionStrategies.sort(PRIORITY_SORT);
    }

    @Pointcut(value="@within(tenantAnnotation)")
    public void matchTenantAnnotation(TenantAware tenantAnnotation) {
    }

    @Around(value="matchTenantAnnotation(tenantAnnotation)")
    public Object action(ProceedingJoinPoint pjp, TenantAware tenantAnnotation) throws Throwable {
        return this.action(pjp, List.of(tenantAnnotation));
    }

    public Object action(ProceedingJoinPoint pjp, List<Annotation> annotations) throws Throwable {
        annotations.stream().filter(a -> a instanceof TenantAware).map(a -> (TenantAware)a).findFirst().ifPresent(tenantAnnotation -> {
            if (this.isMethodTenantAware(pjp, (TenantAware)tenantAnnotation)) {
                Object[] args = pjp.getArgs();
                TenantAuthentication<?> tenant = Objects.requireNonNull(this.extract(args), ERR_NON_TENANT_ID);
                SecurityContext ctx = SecurityContextHolder.getContext();
                ctx.setAuthentication((Authentication)DefaultTenantAuthentication.of(tenant, a -> a.toString()));
            }
        });
        return pjp.proceed();
    }

    private boolean isMethodTenantAware(ProceedingJoinPoint pjp, TenantAware tenantAnnotation) {
        if (pjp instanceof MethodInvocationProceedingJoinPoint && ((MethodInvocationProceedingJoinPoint)pjp).getSignature() instanceof MethodSignature) {
            MethodInvocationProceedingJoinPoint mijp = (MethodInvocationProceedingJoinPoint)pjp;
            MethodSignature signature = (MethodSignature)mijp.getSignature();
            List<String> allVariants = List.of(signature.getMethod().getName(), signature.toShortString(), signature.toLongString(), signature.toString());
            for (String exclude : tenantAnnotation.exclude()) {
                if (!allVariants.contains(exclude)) continue;
                return false;
            }
        }
        return true;
    }

    private TenantAuthentication<?> extract(Object ... args) {
        Optional priorAuth = Optional.empty();
        for (TenantIdExtractionStrategy<?> strg : this.extractionStrategies) {
            Optional extract;
            if (!strg.accept(args) || !(extract = strg.extractWithPrior(priorAuth, args)).isPresent()) continue;
            priorAuth = extract;
        }
        return (TenantAuthentication)priorAuth.get();
    }

    public List<Class<? extends Annotation>> matchAnnotations() {
        return List.of(TenantAware.class);
    }
}

