/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.sql.binding;

import java.util.ArrayList;
import java.util.List;
import org.ehrbase.aql.definition.FuncParameter;
import org.ehrbase.aql.definition.I_VariableDefinition;
import org.ehrbase.aql.sql.binding.VariableDefinitions;

public class FunctionExpression {
    private final I_VariableDefinition functionDefinition;
    private final VariableDefinitions variables;

    FunctionExpression(VariableDefinitions variables, I_VariableDefinition functionDefinition) {
        this.variables = variables;
        this.functionDefinition = functionDefinition;
    }

    public String toString() {
        StringBuilder expression = new StringBuilder();
        for (FuncParameter parameter : this.functionDefinition.getFuncParameters()) {
            if (parameter.isVariable()) {
                if (this.variables.isDistinct(parameter.getValue())) {
                    expression.append("DISTINCT ");
                }
                expression.append("\"");
                expression.append(parameter.getValue());
                expression.append("\"");
                continue;
            }
            expression.append(parameter.getValue());
        }
        return expression.toString();
    }

    List<String> arguments() {
        ArrayList<String> args = new ArrayList<String>();
        for (FuncParameter parameter : this.functionDefinition.getFuncParameters()) {
            if (!parameter.isVariable()) continue;
            args.add(parameter.getValue());
        }
        return args;
    }
}

