/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.dao.access.interfaces;

import com.nedap.archie.rm.datatypes.CodePhrase;
import com.nedap.archie.rm.datavalues.DvCodedText;
import com.nedap.archie.rm.support.identification.TerminologyId;
import java.util.UUID;
import org.ehrbase.dao.access.interfaces.I_DomainAccess;
import org.ehrbase.ehr.knowledge.I_KnowledgeCache;
import org.ehrbase.jooq.pg.Tables;
import org.ehrbase.jooq.pg.tables.records.ConceptRecord;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Table;

public interface I_ConceptAccess {
    public static UUID fetchConcept(I_DomainAccess domainAccess, Integer conceptId, String language) {
        return I_ConceptAccess.getConceptByConceptId(domainAccess, conceptId, language).getId();
    }

    public static DvCodedText fetchConceptText(I_DomainAccess domainAccess, UUID uuid) {
        ConceptRecord conceptRecord = (ConceptRecord)domainAccess.getContext().fetchAny((Table)Tables.CONCEPT, Tables.CONCEPT.ID.eq((Object)uuid));
        I_KnowledgeCache.ConceptValue concept = I_ConceptAccess.getConceptByUuid(domainAccess, uuid);
        return new DvCodedText(concept.getDescription(), new CodePhrase(new TerminologyId("openehr"), Integer.toString(concept.getConceptId())));
    }

    public static String fetchConceptLiteral(I_DomainAccess domainAccess, Integer conceptId, String language) {
        return I_ConceptAccess.getConceptByConceptId(domainAccess, conceptId, language).getDescription();
    }

    public static String fetchConceptLiteral(I_DomainAccess domainAccess, UUID uuid) {
        return I_ConceptAccess.getConceptByUuid(domainAccess, uuid).getDescription();
    }

    public static UUID fetchContributionChangeType(I_DomainAccess domainAccess, String changeTypeStr) {
        ContributionChangeType contributionChangeType = ContributionChangeType.valueOf(changeTypeStr.toUpperCase());
        return I_ConceptAccess.fetchContributionChangeType(domainAccess, contributionChangeType);
    }

    public static UUID fetchContributionChangeType(I_DomainAccess domainAccess, ContributionChangeType contributionChangeType) {
        if (contributionChangeType == null) {
            return null;
        }
        int code = contributionChangeType.getCode();
        return I_ConceptAccess.getConceptByConceptId(domainAccess, code, "en").getId();
    }

    private static I_KnowledgeCache.ConceptValue getConceptByConceptId(I_DomainAccess domainAccess, int code, String language) {
        return domainAccess.getKnowledgeManager().getConceptByConceptId(code, language, (c, l) -> I_ConceptAccess.loadConcept(domainAccess, Tables.CONCEPT.CONCEPTID, c, language));
    }

    private static I_KnowledgeCache.ConceptValue getConceptByUuid(I_DomainAccess domainAccess, UUID uuid) {
        return domainAccess.getKnowledgeManager().getConceptById(uuid, u -> I_ConceptAccess.loadConcept(domainAccess, Tables.CONCEPT.ID, u, null));
    }

    private static I_KnowledgeCache.ConceptValue getConceptByDescription(I_DomainAccess domainAccess, String description, String language) {
        return domainAccess.getKnowledgeManager().getConceptByDescription(description, language, (d, l) -> I_ConceptAccess.loadConcept(domainAccess, Tables.CONCEPT.DESCRIPTION, d, language));
    }

    private static <T> I_KnowledgeCache.ConceptValue loadConcept(I_DomainAccess domainAccess, Field<T> field, T value, String language) {
        Condition condition = field.eq(value);
        if (language != null) {
            condition = condition.and(Tables.CONCEPT.LANGUAGE.equal((Object)language));
        }
        return domainAccess.getContext().fetchOptional((Table)Tables.CONCEPT, condition).map(r -> new I_KnowledgeCache.ConceptValue(r.getId(), r.getConceptid(), r.getDescription(), r.getLanguage())).orElseThrow();
    }

    public static enum ContributionChangeType {
        CREATION(249),
        AMENDMENT(250),
        MODIFICATION(251),
        SYNTHESIS(252),
        UNKNOWN(253),
        DELETED(523);

        final int code;

        private ContributionChangeType(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }
    }
}

