/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.dao.access.jooq;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.api.tenant.Tenant;
import org.ehrbase.dao.access.interfaces.I_TenantAccess;
import org.ehrbase.functional.ExceptionalSupplier;
import org.ehrbase.jooq.pg.Tables;
import org.ehrbase.jooq.pg.tables.records.TenantRecord;
import org.jooq.DSLContext;
import org.jooq.JSON;
import org.jooq.Result;
import org.jooq.Table;

public class TenantAccess
implements I_TenantAccess {
    private final TenantRecord record;
    private static Function<Map<String, Object>, String> mapToJson = map -> {
        if (map == null) {
            return null;
        }
        ExceptionalSupplier sup = () -> new ObjectMapper().writeValueAsString(map);
        return (String)sup.get();
    };
    private static Function<JSON, Map<String, Object>> jsonToMap = json -> {
        if (json == null || StringUtils.isEmpty((CharSequence)json.data())) {
            return Collections.emptyMap();
        }
        ExceptionalSupplier sup = () -> (Map)new ObjectMapper().readValue(json.data(), Map.class);
        return (Map)sup.get();
    };
    private static final String ERR_TENANT_ID = "Updating tenant id[%s] is not allowed";

    public TenantAccess(DSLContext ctx, Tenant tenant) {
        this(ctx, TenantAccess.initTenantRec(ctx, tenant));
    }

    private TenantAccess(DSLContext ctx, TenantRecord rec) {
        this.record = rec;
    }

    private static TenantRecord initTenantRec(DSLContext ctx, Tenant tenant) {
        TenantRecord rec = (TenantRecord)ctx.newRecord((Table)Tables.TENANT);
        rec.setTenantId(tenant.getTenantId());
        rec.setTenantName(tenant.getTenantName());
        String json = mapToJson.apply(tenant.getTenantProperties());
        rec.setTenantProperties(StringUtils.isNotBlank((CharSequence)json) ? JSON.json((String)json) : null);
        return rec;
    }

    @Override
    public Short commit() {
        this.record.store();
        return this.record.getId();
    }

    public static List<I_TenantAccess> getAll(DSLContext ctx) {
        Result allRecs = ctx.fetch((Table)Tables.TENANT);
        return StreamSupport.stream(allRecs.spliterator(), false).map(rec -> new TenantAccess(ctx, (TenantRecord)rec)).collect(Collectors.toList());
    }

    public static I_TenantAccess retrieveInstanceBy(DSLContext ctx, String tenantId) {
        return Optional.ofNullable((TenantRecord)ctx.fetchOne((Table)Tables.TENANT, Tables.TENANT.TENANT_ID.eq((Object)tenantId))).map(rec -> new TenantAccess(ctx, (TenantRecord)rec)).orElse(null);
    }

    public static Map<String, Short> getSysTenants(DSLContext ctx) {
        return ctx.fetch((Table)Tables.TENANT).stream().collect(Collectors.toMap(TenantRecord::getTenantId, TenantRecord::getId));
    }

    @Override
    public Tenant convert() {
        return new Tenant(){

            public String getTenantId() {
                return TenantAccess.this.record.getTenantId();
            }

            public String getTenantName() {
                return TenantAccess.this.record.getTenantName();
            }

            public Map<String, Object> getTenantProperties() {
                return jsonToMap.apply(TenantAccess.this.record.getTenantProperties());
            }
        };
    }

    @Override
    public Tenant update(Tenant tenant) {
        if (!this.record.getTenantId().equals(tenant.getTenantId())) {
            throw new InternalServerException(String.format(ERR_TENANT_ID, tenant.getTenantId()));
        }
        this.record.setTenantName(tenant.getTenantName());
        String json = mapToJson.apply(tenant.getTenantProperties());
        this.record.setTenantProperties(StringUtils.isNotBlank((CharSequence)json) ? JSON.json((String)json) : null);
        this.record.update();
        return this.convert();
    }
}

