/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.containment;

import java.util.ArrayList;
import java.util.List;
import org.ehrbase.aql.containment.JsonPathQueryResult;
import org.ehrbase.service.KnowledgeCacheService;
import org.ehrbase.webtemplate.parser.NodeId;

public class Templates {
    private final KnowledgeCacheService knowledgeCache;

    public Templates(KnowledgeCacheService knowledgeCache) {
        this.knowledgeCache = knowledgeCache;
    }

    public List<JsonPathQueryResult> resolve(List<NodeId> jsonQueryExpression) {
        if (jsonQueryExpression == null) {
            return null;
        }
        ArrayList<JsonPathQueryResult> jsonPathQueryResults = new ArrayList<JsonPathQueryResult>();
        for (String templateId : this.knowledgeCache.getAllTemplateIds()) {
            JsonPathQueryResult result = this.resolveForTemplate(templateId, jsonQueryExpression);
            if (result == null) continue;
            jsonPathQueryResults.add(result);
        }
        return jsonPathQueryResults;
    }

    public JsonPathQueryResult resolveForTemplate(String templateId, List<NodeId> jsonQueryExpression) {
        return this.knowledgeCache.resolveForTemplate(templateId, jsonQueryExpression);
    }

    public String rootArchetypeNodeId(String templateId) {
        try {
            return this.knowledgeCache.getQueryOptMetaData(templateId).getTree().getNodeId();
        }
        catch (RuntimeException e) {
            throw new IllegalStateException("Could not retrieve template meta data: " + e, e);
        }
    }
}

