/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.sql.queryimpl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.ehrbase.aql.definition.I_VariableDefinition;
import org.ehrbase.aql.sql.queryimpl.DefaultColumnId;
import org.ehrbase.aql.sql.queryimpl.IQueryImpl;
import org.ehrbase.aql.sql.queryimpl.NullField;
import org.ehrbase.aql.sql.queryimpl.QualifiedAqlField;
import org.ehrbase.aql.sql.queryimpl.UnknownVariableException;
import org.jooq.Field;

public class MultiFields {
    private final List<QualifiedAqlField> fields = new ArrayList<QualifiedAqlField>();
    private boolean useEntryTable = false;
    private String rootJsonKey;
    private final String templateId;
    private I_VariableDefinition variableDefinition;

    public MultiFields(I_VariableDefinition variableDefinition, List<QualifiedAqlField> fields, String templateId) {
        this.fields.addAll(fields);
        this.variableDefinition = variableDefinition;
        this.templateId = templateId;
    }

    public MultiFields(I_VariableDefinition variableDefinition, Field<?> field, String templateId) {
        this(variableDefinition, new QualifiedAqlField(field), templateId);
    }

    public static MultiFields asNull(I_VariableDefinition variableDefinition, String templateId, IQueryImpl.Clause clause) {
        String alias = variableDefinition.getAlias();
        if (clause.equals((Object)IQueryImpl.Clause.WHERE)) {
            alias = null;
        } else if (alias == null) {
            alias = DefaultColumnId.value(variableDefinition);
        }
        Field<?> nullField = new NullField(variableDefinition, alias).instance();
        return new MultiFields(variableDefinition, nullField, templateId);
    }

    public MultiFields(I_VariableDefinition variableDefinition, QualifiedAqlField field, String templateId) {
        this.fields.add(field);
        this.variableDefinition = variableDefinition;
        this.templateId = templateId;
    }

    public void setUseEntryTable(boolean useEntryTable) {
        this.useEntryTable = useEntryTable;
    }

    public boolean isUseEntryTable() {
        return this.useEntryTable;
    }

    public int fieldsSize() {
        return this.fields.size();
    }

    public QualifiedAqlField getQualifiedField(int index) {
        return this.fields.get(index);
    }

    public Iterator<QualifiedAqlField> iterator() {
        return this.fields.iterator();
    }

    public QualifiedAqlField getLastQualifiedField() throws UnknownVariableException {
        if (this.fieldsSize() > 0) {
            return this.fields.get(this.fieldsSize() - 1);
        }
        throw new UnknownVariableException(this.variableDefinition.getPath());
    }

    public QualifiedAqlField getQualifiedFieldOrLast(int index) throws UnknownVariableException {
        if (index >= this.fieldsSize()) {
            return this.getLastQualifiedField();
        }
        return this.getQualifiedField(index);
    }

    public int size() {
        return this.fields.size();
    }

    public boolean isEmpty() {
        return this.fields.isEmpty();
    }

    public String getRootJsonKey() {
        return this.rootJsonKey;
    }

    public void setRootJsonKey(String rootJsonKey) {
        this.rootJsonKey = rootJsonKey;
    }

    public I_VariableDefinition getVariableDefinition() {
        return this.variableDefinition;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public void replaceField(QualifiedAqlField originalField, Field newField) {
        int index = this.fields.indexOf(originalField);
        QualifiedAqlField originalAqlField = this.fields.get(index);
        QualifiedAqlField clonedQualifiedField = originalAqlField.duplicate();
        clonedQualifiedField.setField(newField);
        this.fields.set(this.fields.indexOf(originalField), clonedQualifiedField);
    }
}

