/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.sql.queryimpl.attribute.setting;

import java.util.Optional;
import java.util.UUID;
import org.ehrbase.aql.sql.queryimpl.AqlRoutines;
import org.ehrbase.aql.sql.queryimpl.attribute.FieldResolutionContext;
import org.ehrbase.aql.sql.queryimpl.attribute.GenericJsonPath;
import org.ehrbase.aql.sql.queryimpl.attribute.IRMObjectAttribute;
import org.ehrbase.aql.sql.queryimpl.attribute.JoinSetup;
import org.ehrbase.aql.sql.queryimpl.attribute.eventcontext.EventContextAttribute;
import org.ehrbase.aql.sql.queryimpl.value_field.GenericJsonField;
import org.ehrbase.jooq.pg.Routines;
import org.ehrbase.jooq.pg.tables.EventContext;
import org.jooq.Field;
import org.jooq.JSONB;
import org.jooq.SelectField;
import org.jooq.TableField;
import org.jooq.impl.DSL;

public class SettingAttribute
extends EventContextAttribute {
    protected Field tableField;
    protected Optional<String> jsonPath = Optional.empty();
    private boolean isJsonDataBlock = false;

    public SettingAttribute(FieldResolutionContext fieldContext, JoinSetup joinSetup) {
        super(fieldContext, joinSetup);
    }

    @Override
    public Field<?> sqlField() {
        if (this.jsonPath.isPresent()) {
            if (this.isJsonDataBlock) {
                return new GenericJsonField(this.fieldContext, this.joinSetup).forJsonPath(this.jsonPath.get()).eventContext((Field<UUID>)EventContext.EVENT_CONTEXT.ID);
            }
            Field jsonContextField = DSL.field(AqlRoutines.jsonpathItem(this.fieldContext.getContext().configuration(), (Field<JSONB>)Routines.jsDvCodedText2((Field)this.tableField).cast(JSONB.class), AqlRoutines.jsonpathParameters(new GenericJsonPath(this.jsonPath.get()).jqueryPath()))).cast(String.class);
            return this.as(DSL.field((SelectField)jsonContextField));
        }
        return null;
    }

    @Override
    public IRMObjectAttribute forTableField(TableField tableField) {
        this.tableField = tableField;
        return this;
    }

    public IRMObjectAttribute forJsonPath(String jsonPath) {
        this.jsonPath = Optional.of(jsonPath);
        return this;
    }

    public SettingAttribute setJsonDataBlock(boolean jsonDataBlock) {
        this.isJsonDataBlock = jsonDataBlock;
        return this;
    }
}

