/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.nedap.archie.json.JacksonUtil;
import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.changecontrol.Version;
import com.nedap.archie.rm.generic.AuditDetails;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.ehrbase.api.exception.UnexpectedSwitchCaseException;
import org.ehrbase.response.ehrscape.CompositionFormat;
import org.ehrbase.serialisation.jsonencoding.CanonicalJson;

public class ContributionServiceHelper {
    public static Map<String, Object> splitContent(String content, CompositionFormat format) {
        switch (format) {
            case JSON: {
                return new CanonicalJson().unmarshalToMap(content);
            }
        }
        throw new UnexpectedSwitchCaseException((Enum)format);
    }

    public static List<Version> extractVersionObjects(ArrayList listVersions, CompositionFormat format) {
        LinkedList<Version> versionsList = new LinkedList<Version>();
        switch (format) {
            case JSON: {
                for (Object version : listVersions) {
                    try {
                        String json = JacksonUtil.getObjectMapper().writeValueAsString(version);
                        RMObject versionRmObject = new CanonicalJson().unmarshal(json, RMObject.class);
                        if (versionRmObject instanceof Version) {
                            versionsList.add((Version)versionRmObject);
                            continue;
                        }
                        throw new IllegalArgumentException("Wrong input. At least one VERSION in this contribution is invalid.");
                    }
                    catch (JsonProcessingException e) {
                        throw new IllegalArgumentException("Error while processing given json input: " + e.getMessage());
                    }
                }
                break;
            }
            default: {
                throw new UnexpectedSwitchCaseException((Enum)format);
            }
        }
        return versionsList;
    }

    public static RMObject unmarshalMapContentToRmObject(LinkedHashMap content, CompositionFormat format) {
        switch (format) {
            case JSON: {
                String json = null;
                try {
                    json = JacksonUtil.getObjectMapper().writeValueAsString((Object)content);
                }
                catch (JsonProcessingException e) {
                    throw new IllegalArgumentException("Error while processing given json input: " + e.getMessage());
                }
                return new CanonicalJson().unmarshal(json, RMObject.class);
            }
        }
        throw new UnexpectedSwitchCaseException((Enum)format);
    }

    public static List<Version> parseVersions(String content, CompositionFormat format) {
        Map<String, Object> splitContent = ContributionServiceHelper.splitContent(content, format);
        Object versionsContent = splitContent.get("versions");
        if (!(versionsContent instanceof List)) {
            throw new IllegalArgumentException("Can't process input, possible malformed version payload");
        }
        List<Version> versions = ContributionServiceHelper.extractVersionObjects((ArrayList)versionsContent, format);
        return versions;
    }

    public static AuditDetails parseAuditDetails(String content, CompositionFormat format) {
        AuditDetails auditResult;
        Map<String, Object> splitContent = ContributionServiceHelper.splitContent(content, format);
        Object auditContent = splitContent.get("audit");
        switch (format) {
            case JSON: {
                try {
                    String json = JacksonUtil.getObjectMapper().writeValueAsString(auditContent);
                    auditResult = (AuditDetails)new CanonicalJson().unmarshal(json, AuditDetails.class);
                    break;
                }
                catch (JsonProcessingException e) {
                    throw new IllegalArgumentException("Error while processing given json input: " + e.getMessage());
                }
            }
            default: {
                throw new UnexpectedSwitchCaseException((Enum)format);
            }
        }
        return auditResult;
    }
}

