/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.service;

import com.nedap.archie.rm.directory.Folder;
import com.nedap.archie.rm.support.identification.HierObjectId;
import com.nedap.archie.rm.support.identification.ObjectVersionId;
import com.nedap.archie.rm.support.identification.UID;
import com.nedap.archie.rm.support.identification.UIDBasedId;
import com.nedap.archie.rm.support.identification.VersionTreeId;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.api.definitions.ServerConfig;
import org.ehrbase.api.exception.ObjectNotFoundException;
import org.ehrbase.api.exception.PreconditionFailedException;
import org.ehrbase.api.exception.StateConflictException;
import org.ehrbase.api.service.EhrService;
import org.ehrbase.dao.access.util.FolderUtils;
import org.ehrbase.jooq.pg.tables.records.EhrFolderHistoryRecord;
import org.ehrbase.jooq.pg.tables.records.EhrFolderRecord;
import org.ehrbase.repository.EhrFolderRepository;
import org.ehrbase.service.BaseServiceImp;
import org.ehrbase.service.InternalDirectoryService;
import org.ehrbase.service.KnowledgeCacheService;
import org.ehrbase.util.UuidGenerator;
import org.jooq.DSLContext;
import org.jooq.Result;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@Service
public class DirectoryServiceImp
extends BaseServiceImp
implements InternalDirectoryService {
    private final ServerConfig serverConfig;
    private final EhrService ehrService;
    private final EhrFolderRepository ehrFolderRepository;

    public DirectoryServiceImp(KnowledgeCacheService knowledgeCacheService, DSLContext context, ServerConfig serverConfig, EhrService ehrService, EhrFolderRepository ehrFolderRepository) {
        super(knowledgeCacheService, context, serverConfig);
        this.serverConfig = serverConfig;
        this.ehrService = ehrService;
        this.ehrFolderRepository = ehrFolderRepository;
    }

    public Optional<Folder> get(UUID ehrId, @Nullable ObjectVersionId folderId, @Nullable String path) {
        Object ehrFolderRecords;
        if (folderId == null) {
            ehrFolderRecords = this.ehrFolderRepository.getFolderHead(ehrId, 1);
        } else {
            VersionTreeId versionTreeId = folderId.getVersionTreeId();
            if (versionTreeId.isBranch()) {
                throw new UnsupportedOperationException("Version branching is not supported: %s".formatted(versionTreeId.getValue()));
            }
            if (!folderId.getCreatingSystemId().getValue().equals(this.serverConfig.getNodename())) {
                return Optional.empty();
            }
            int version = Integer.parseInt(versionTreeId.getValue());
            Result<EhrFolderHistoryRecord> byVersion = this.ehrFolderRepository.getByVersion(ehrId, version);
            ehrFolderRecords = this.ehrFolderRepository.fromHistory((List<EhrFolderHistoryRecord>)byVersion);
        }
        if (ehrFolderRecords.isEmpty()) {
            this.ehrService.checkEhrExists(ehrId);
            return Optional.empty();
        }
        Folder root = this.ehrFolderRepository.from((List<EhrFolderRecord>)ehrFolderRecords);
        if (folderId != null && !folderId.getRoot().equals((Object)root.getUid().getRoot())) {
            return Optional.empty();
        }
        return this.findByPath(root, StringUtils.split((String)path, (char)'/'));
    }

    public Optional<Folder> getByTime(UUID ehrId, OffsetDateTime time, @Nullable String path) {
        List<EhrFolderRecord> ehrFolderRecords = this.ehrFolderRepository.fromHistory((List<EhrFolderHistoryRecord>)this.ehrFolderRepository.getByTime(ehrId, time));
        if (ehrFolderRecords.isEmpty()) {
            return Optional.empty();
        }
        return this.findByPath(this.ehrFolderRepository.from(ehrFolderRecords), StringUtils.split((String)path, (char)'/'));
    }

    private Optional<Folder> findByPath(Folder root, String[] path) {
        if (ArrayUtils.isEmpty((Object[])path)) {
            return Optional.of(root);
        }
        if (root.getFolders() == null) {
            return Optional.empty();
        }
        return root.getFolders().stream().filter(sf -> sf.getNameAsString().equals(path[0])).findAny().flatMap(sf -> this.findByPath((Folder)sf, (String[])ArrayUtils.subarray((Object[])path, (int)1, (int)path.length)));
    }

    public Folder create(UUID ehrId, Folder folder) {
        return this.create(ehrId, folder, null, null);
    }

    @Override
    public Folder create(UUID ehrId, Folder folder, UUID contributionId, UUID auditId) {
        this.ehrService.checkEhrExistsAndIsModifiable(ehrId);
        if (this.ehrFolderRepository.hasDirectory(ehrId)) {
            throw new StateConflictException("EHR with id %s already contains a directory.".formatted(ehrId));
        }
        FolderUtils.checkSiblingNameConflicts(folder);
        this.updateUuid(folder, true, Optional.ofNullable(folder.getUid()).map(UIDBasedId::getRoot).map(UID::getValue).map(UUID::fromString).orElse(UuidGenerator.randomUUID()), 1);
        this.ehrFolderRepository.commit(this.ehrFolderRepository.toRecord(ehrId, folder), contributionId, auditId);
        return this.get(ehrId, null, null).get();
    }

    public Folder update(UUID ehrId, Folder folder, ObjectVersionId ifMatches) {
        return this.update(ehrId, folder, ifMatches, null, null);
    }

    @Override
    public Folder update(UUID ehrId, Folder folder, ObjectVersionId ifMatches, UUID contributionId, UUID auditId) {
        this.ehrService.checkEhrExistsAndIsModifiable(ehrId);
        if (!this.ehrFolderRepository.hasDirectory(ehrId)) {
            throw new PreconditionFailedException(String.format("EHR with id %s does not contain a directory.", ehrId.toString()));
        }
        FolderUtils.checkSiblingNameConflicts(folder);
        int version = Integer.parseInt(ifMatches.getVersionTreeId().getValue());
        this.updateUuid(folder, true, UUID.fromString(ifMatches.getObjectId().getValue()), version + 1);
        this.ehrFolderRepository.update(this.ehrFolderRepository.toRecord(ehrId, folder), contributionId, auditId);
        return this.get(ehrId, null, null).get();
    }

    public void delete(UUID ehrId, ObjectVersionId ifMatches) {
        this.delete(ehrId, ifMatches, null, null);
    }

    @Override
    public void delete(UUID ehrId, ObjectVersionId ifMatches, UUID contributionId, UUID auditId) {
        this.ehrService.checkEhrExistsAndIsModifiable(ehrId);
        if (!this.ehrFolderRepository.hasDirectory(ehrId)) {
            throw new PreconditionFailedException("EHR with id %s does not contain a directory.".formatted(ehrId));
        }
        this.ehrFolderRepository.delete(ehrId, UUID.fromString(ifMatches.getObjectId().getValue()), Integer.parseInt(ifMatches.getVersionTreeId().getValue()), 1, contributionId, auditId);
    }

    private void updateUuid(Folder folder, boolean root, UUID rootUuid, int version) {
        if (folder.getUid() == null || root) {
            if (root) {
                folder.setUid((UIDBasedId)new ObjectVersionId(rootUuid + "::" + this.serverConfig.getNodename() + "::" + version));
            } else {
                folder.setUid((UIDBasedId)new HierObjectId(UuidGenerator.randomUUID().toString()));
            }
        }
        if (folder.getFolders() != null) {
            folder.getFolders().forEach(folder1 -> this.updateUuid((Folder)folder1, false, rootUuid, version));
        }
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    public void adminDeleteFolder(UUID ehrId, UUID folderId) {
        if (!this.ehrService.hasEhr(ehrId)) {
            throw new ObjectNotFoundException("Admin Directory", "EHR with id %s does not exist".formatted(ehrId));
        }
        Result<EhrFolderRecord> latest = this.ehrFolderRepository.getFolderHead(ehrId, 1);
        if (latest.isNotEmpty()) {
            Folder from = this.ehrFolderRepository.from((List<EhrFolderRecord>)latest);
            if (!UUID.fromString(from.getUid().getRoot().getValue()).equals(folderId)) {
                throw new IllegalArgumentException("FolderIds do not match");
            }
            this.ehrFolderRepository.adminDelete(ehrId, 1);
        }
    }

    @Override
    public List<ObjectVersionId> findForContribution(UUID ehrId, UUID contributionId) {
        return this.ehrFolderRepository.findForContribution(ehrId, contributionId);
    }
}

