/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.service;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.xmlbeans.XmlException;
import org.ehrbase.api.exception.InvalidApiParameterException;
import org.ehrbase.api.exception.StateConflictException;
import org.ehrbase.api.service.TenantService;
import org.ehrbase.api.tenant.Tenant;
import org.ehrbase.aql.containment.JsonPathQueryResult;
import org.ehrbase.aql.containment.TemplateIdAqlTuple;
import org.ehrbase.aql.sql.queryimpl.ItemInfo;
import org.ehrbase.cache.CacheOptions;
import org.ehrbase.ehr.knowledge.I_KnowledgeCache;
import org.ehrbase.ehr.knowledge.TemplateMetaData;
import org.ehrbase.service.CacheKey;
import org.ehrbase.service.IntrospectService;
import org.ehrbase.service.TemplateStorage;
import org.ehrbase.tenant.DefaultTenantAuthentication;
import org.ehrbase.util.TemplateUtils;
import org.ehrbase.webtemplate.model.WebTemplate;
import org.ehrbase.webtemplate.model.WebTemplateNode;
import org.ehrbase.webtemplate.parser.NodeId;
import org.ehrbase.webtemplate.parser.OPTParser;
import org.openehr.schemas.v1.OPERATIONALTEMPLATE;
import org.openehr.schemas.v1.TemplateDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service
public class KnowledgeCacheService
implements I_KnowledgeCache,
IntrospectService {
    public static final String ELEMENT = "ELEMENT";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final TemplateStorage templateStorage;
    private final CacheOptions cacheOptions;
    private final Cache jsonPathQueryResultCache;
    private final Cache webTemplateCache;
    private final Cache fieldCache;
    private final Cache multivaluedCache;
    private final TenantService tenantService;
    private final Map<CacheKey<UUID>, String> idxCacheUuidToTemplateId = new ConcurrentHashMap<CacheKey<UUID>, String>();
    private final Map<String, CacheKey<UUID>> idxCacheTemplateIdToUuid = new ConcurrentHashMap<String, CacheKey<UUID>>();
    private final Cache conceptById;
    private final Cache conceptByConceptId;
    private final Cache conceptByDescription;
    private final Cache territoryCache;
    private final Cache languageCache;
    @Value(value="${system.allow-template-overwrite:false}")
    private boolean allowTemplateOverwrite;
    private static final int NUM_OF_PROC = Runtime.getRuntime().availableProcessors();
    private static final ExecutorService execService = Executors.newFixedThreadPool(NUM_OF_PROC);
    private static final String ERR_CACHE_ERROR = "An error occurred while caching template: {}";
    private static final String ERR_GEN_ERROR = "An error occurred while calculating queries for template: {}";

    public KnowledgeCacheService(TemplateStorage templateStorage, CacheManager cacheManager, CacheOptions cacheOptions, TenantService tenantService) {
        this.templateStorage = templateStorage;
        this.cacheOptions = cacheOptions;
        this.tenantService = tenantService;
        this.webTemplateCache = cacheManager.getCache("introspectCache");
        this.jsonPathQueryResultCache = cacheManager.getCache("queryCache");
        this.fieldCache = cacheManager.getCache("fieldsCache");
        this.multivaluedCache = cacheManager.getCache("multivaluedCache");
        this.conceptById = cacheManager.getCache("conceptCacheId");
        this.conceptByConceptId = cacheManager.getCache("conceptCacheConceptId");
        this.conceptByDescription = cacheManager.getCache("conceptCacheDescription");
        this.territoryCache = cacheManager.getCache("territoryCache");
        this.languageCache = cacheManager.getCache("languageCache");
    }

    @PostConstruct
    void init() throws InterruptedException {
        this.initializeCaches(this.cacheOptions.isPreInitialize());
    }

    private Future<?> initCachePerTenant(String tenantId) {
        SecCtxAwareRunnable runMe = new SecCtxAwareRunnable((Authentication)DefaultTenantAuthentication.of(tenantId)){

            @Override
            void doRun() {
                HashSet templateIds = new HashSet();
                KnowledgeCacheService.this.listAllOperationalTemplates().forEach(metadata -> {
                    OPERATIONALTEMPLATE template = metadata.getOperationaltemplate();
                    String templateId = TemplateUtils.getTemplateId(template);
                    templateIds.add(templateId);
                    try {
                        KnowledgeCacheService.this.putIntoCache(template, KnowledgeCacheService.this.tenantService.getCurrentSysTenant());
                    }
                    catch (RuntimeException e) {
                        KnowledgeCacheService.this.log.error(KnowledgeCacheService.ERR_CACHE_ERROR, (Object)templateId, (Object)e);
                    }
                });
                templateIds.forEach(templateId -> {
                    try {
                        KnowledgeCacheService.this.preBuildQueries((String)templateId, KnowledgeCacheService.this.cacheOptions.isPreBuildQueries());
                    }
                    catch (RuntimeException e) {
                        KnowledgeCacheService.this.log.error(KnowledgeCacheService.ERR_GEN_ERROR, templateId, (Object)e);
                    }
                });
            }
        };
        return execService.submit(runMe);
    }

    private void initializeCaches(boolean init) throws InterruptedException {
        if (!init) {
            return;
        }
        List tenants = this.tenantService.getAll();
        List<Future> collect = tenants.stream().map(Tenant::getTenantId).map(this::initCachePerTenant).collect(Collectors.toList());
        int i = 0;
        while (i < 16) {
            boolean res = collect.stream().map(Future::isDone).reduce(true, (a, b) -> a != false && b != false);
            if (res) {
                return;
            }
            i = Math.max(1, 2 * i);
            Thread.sleep((long)i * 1000L);
        }
        collect.forEach(f -> {
            if (!f.isDone()) {
                f.cancel(false);
            }
        });
    }

    @Override
    public Set<String> getAllTemplateIds() {
        return this.templateStorage.findAllTemplateIds();
    }

    @Override
    public String addOperationalTemplate(InputStream inputStream) {
        OPERATIONALTEMPLATE template = this.buildOperationalTemplate(inputStream);
        return this.addOperationalTemplateIntern(template, false);
    }

    private OPERATIONALTEMPLATE buildOperationalTemplate(InputStream content) {
        try {
            TemplateDocument document = TemplateDocument.Factory.parse((InputStream)content);
            return document.getTemplate();
        }
        catch (IOException | XmlException e) {
            throw new InvalidApiParameterException(e.getMessage());
        }
    }

    @Override
    public String addOperationalTemplate(OPERATIONALTEMPLATE template) {
        return this.addOperationalTemplateIntern(template, false);
    }

    private String addOperationalTemplateIntern(OPERATIONALTEMPLATE template, boolean overwrite) {
        String templateId;
        this.validateTemplate(template);
        try {
            templateId = TemplateUtils.getTemplateId(template);
        }
        catch (IllegalArgumentException a) {
            throw new InvalidApiParameterException("Invalid template input content");
        }
        if (!this.allowTemplateOverwrite && !overwrite && this.retrieveOperationalTemplate(templateId).isPresent()) {
            throw new StateConflictException("Operational template with this template ID already exists: " + templateId);
        }
        this.invalidateCache(template);
        this.templateStorage.storeTemplate(template, this.tenantService.getCurrentSysTenant());
        this.putIntoCache(template, this.tenantService.getCurrentSysTenant());
        this.preBuildQueries(templateId, this.cacheOptions.isPreBuildQueries());
        return templateId;
    }

    private void preBuildQueries(final String templateId, boolean preBuild) {
        if (!preBuild) {
            return;
        }
        this.getQueryOptMetaData(templateId).findAllContainmentCombinations().stream().filter(nodeIds -> !nodeIds.isEmpty() && nodeIds.size() <= this.cacheOptions.getPreBuildQueriesDepth()).forEach(nodeIds -> execService.submit(new SecCtxAwareRunnable(SecurityContextHolder.getContext().getAuthentication(), (Set)nodeIds){
            final /* synthetic */ Set val$nodeIds;
            {
                this.val$nodeIds = set;
                super(auth);
            }

            @Override
            void doRun() {
                KnowledgeCacheService.this.resolveForTemplate(templateId, this.val$nodeIds);
            }
        }));
    }

    private void putIntoCache(OPERATIONALTEMPLATE template, Short sysTenant) {
        String templateId = TemplateUtils.getTemplateId(template);
        UUID uid = TemplateUtils.getUid(template);
        try {
            this.idxCacheUuidToTemplateId.put(CacheKey.of(uid, sysTenant), templateId);
            this.idxCacheTemplateIdToUuid.put(templateId, CacheKey.of(uid, sysTenant));
            this.getQueryOptMetaData(templateId);
        }
        catch (RuntimeException e) {
            this.log.error("Invalid template {}", (Object)templateId);
            this.invalidateCache(template);
            throw e;
        }
    }

    public String adminUpdateOperationalTemplate(InputStream content) {
        OPERATIONALTEMPLATE template = this.buildOperationalTemplate(content);
        return this.addOperationalTemplateIntern(template, true);
    }

    private void invalidateCache(OPERATIONALTEMPLATE template) {
        this.webTemplateCache.evict(CacheKey.of(TemplateUtils.getUid(template), this.tenantService.getCurrentSysTenant()));
        this.jsonPathQueryResultCache.invalidate();
        this.fieldCache.invalidate();
        this.multivaluedCache.invalidate();
    }

    @Override
    public List<TemplateMetaData> listAllOperationalTemplates() {
        return this.templateStorage.listAllOperationalTemplates();
    }

    @Override
    public Optional<OPERATIONALTEMPLATE> retrieveOperationalTemplate(String key) {
        this.log.debug("retrieveOperationalTemplate({})", (Object)key);
        return Optional.ofNullable(this.getOperationaltemplateFromFileStorage(key));
    }

    @Override
    public Optional<OPERATIONALTEMPLATE> retrieveOperationalTemplate(UUID uuid) {
        return Optional.ofNullable(this.findTemplateIdByUuid(uuid)).flatMap(key -> this.retrieveOperationalTemplate((String)key));
    }

    @Override
    public boolean deleteOperationalTemplate(OPERATIONALTEMPLATE template) {
        boolean deleted = this.templateStorage.deleteTemplate(template.getTemplateId().getValue());
        if (deleted) {
            this.invalidateCache(template);
        }
        return deleted;
    }

    private String findTemplateIdByUuid(UUID uuid) {
        return this.idxCacheUuidToTemplateId.computeIfAbsent(CacheKey.of(uuid, this.tenantService.getCurrentSysTenant()), ck -> this.listAllOperationalTemplates().stream().filter(t -> t.getErrorList().isEmpty()).filter(t -> t.getOperationaltemplate().getUid().getValue().equals(((UUID)ck.getVal()).toString())).map(t -> t.getOperationaltemplate().getTemplateId().getValue()).findFirst().orElse(null));
    }

    private UUID findUuidByTemplateId(String templateId) {
        return (UUID)this.idxCacheTemplateIdToUuid.computeIfAbsent(templateId, id -> {
            OPERATIONALTEMPLATE templ = this.retrieveOperationalTemplate((String)id).orElseThrow(() -> new IllegalArgumentException(String.format("Unknown template %s", templateId)));
            return CacheKey.of(UUID.fromString(templ.getUid().getValue()), this.tenantService.getCurrentSysTenant());
        }).getVal();
    }

    @Override
    public WebTemplate getQueryOptMetaData(UUID uuid) {
        CacheKey<UUID> ck = CacheKey.of(uuid, this.tenantService.getCurrentSysTenant());
        return (WebTemplate)this.webTemplateCache.get(ck, () -> this.buildQueryOptMetaData(uuid));
    }

    @Override
    public WebTemplate getQueryOptMetaData(String templateId) {
        return this.getQueryOptMetaData(this.findUuidByTemplateId(templateId));
    }

    private WebTemplate buildQueryOptMetaData(UUID uuid) {
        Optional<Object> operationaltemplate;
        try {
            operationaltemplate = this.retrieveOperationalTemplate(uuid);
        }
        catch (Exception e) {
            this.log.warn(e.getMessage(), (Throwable)e);
            operationaltemplate = Optional.empty();
        }
        return operationaltemplate.map(this::buildQueryOptMetaData).orElseThrow(() -> new IllegalArgumentException("Could not retrieve  knowledgeCacheService.getKnowledgeCache() cache for template Uid:" + uuid));
    }

    private WebTemplate buildQueryOptMetaData(OPERATIONALTEMPLATE operationaltemplate) {
        this.log.info("Updating WebTemplate cache for template: {}", (Object)TemplateUtils.getTemplateId(operationaltemplate));
        try {
            return new OPTParser(operationaltemplate).parse();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Invalid template: %s", e.getMessage()));
        }
    }

    private OPERATIONALTEMPLATE getOperationaltemplateFromFileStorage(String filename) {
        Optional<OPERATIONALTEMPLATE> template = this.templateStorage.readOperationaltemplate(filename);
        template.ifPresent(existingTemplate -> this.idxCacheUuidToTemplateId.put(CacheKey.of(TemplateUtils.getUid(existingTemplate), this.tenantService.getCurrentSysTenant()), filename));
        return template.orElse(null);
    }

    public int deleteAllOperationalTemplates() {
        List<TemplateMetaData> templateList = this.templateStorage.listAllOperationalTemplates();
        if (templateList.isEmpty()) {
            return 0;
        }
        int deleted = 0;
        for (TemplateMetaData metaData : templateList) {
            if (!this.deleteOperationalTemplate(metaData.getOperationaltemplate())) continue;
            ++deleted;
        }
        return deleted;
    }

    @Override
    public JsonPathQueryResult resolveForTemplate(String templateId, Collection<NodeId> nodeIds) {
        Triple key = Triple.of((Object)templateId, (Object)this.tenantService.getCurrentSysTenant(), nodeIds);
        JsonPathQueryResult jsonPathQueryResult = (JsonPathQueryResult)this.jsonPathQueryResultCache.get((Object)key, () -> this.createJsonPathQueryResult((Triple<String, Short, Collection<NodeId>>)key));
        return jsonPathQueryResult.getTemplateId() != null ? jsonPathQueryResult : null;
    }

    private JsonPathQueryResult createJsonPathQueryResult(Triple<String, Short, Collection<NodeId>> key) {
        WebTemplate webTemplate = this.getQueryOptMetaData((String)key.getLeft());
        List<Object> webTemplateNodeList = new ArrayList<WebTemplateNode>();
        webTemplateNodeList.add(webTemplate.getTree());
        for (NodeId nodeId : (Collection)key.getRight()) {
            webTemplateNodeList = webTemplateNodeList.stream().map(n -> n.findMatching(f -> {
                if (f.getNodeId() == null) {
                    return false;
                }
                if (nodeId.getNodeId() == null) {
                    return nodeId.getClassName().equals(new NodeId(f.getNodeId()).getClassName());
                }
                return nodeId.equals((Object)new NodeId(f.getNodeId()));
            })).flatMap(Collection::stream).collect(Collectors.toList());
        }
        TreeSet<String> uniquePaths = new TreeSet<String>();
        webTemplateNodeList.stream().map(n -> n.getAqlPath(false)).forEach(uniquePaths::add);
        JsonPathQueryResult jsonPathQueryResult = !uniquePaths.isEmpty() ? new JsonPathQueryResult((String)key.getLeft(), uniquePaths) : new JsonPathQueryResult(null, Collections.emptyMap());
        return jsonPathQueryResult;
    }

    @Override
    public ItemInfo getInfo(String templateId, String aql) {
        TemplateIdAqlTuple key = new TemplateIdAqlTuple(templateId, aql, this.tenantService.getCurrentSysTenant());
        return (ItemInfo)this.fieldCache.get((Object)key, () -> this.createItemInfo(key));
    }

    private ItemInfo createItemInfo(TemplateIdAqlTuple key) {
        String keyAql;
        WebTemplate webTemplate = this.getQueryOptMetaData(key.getTemplateId());
        Optional node = webTemplate.findByAqlPath(keyAql = key.getAql());
        String type = node.isEmpty() ? null : (((WebTemplateNode)node.get()).getRmType().equals(ELEMENT) ? ((WebTemplateNode)((WebTemplateNode)node.get()).getChildren().get(0)).getRmType() : ((WebTemplateNode)node.get()).getRmType());
        String category = node.isEmpty() ? null : (keyAql.endsWith("/value") ? webTemplate.findByAqlPath(keyAql.replace("/value", "")).filter(n -> n.getRmType().equals(ELEMENT)).map(n -> ELEMENT).orElse("DATA_STRUCTURE") : "DATA_STRUCTURE");
        return new ItemInfo(type, category);
    }

    @Override
    public List<String> multiValued(String templateId) {
        return (List)this.multivaluedCache.get(CacheKey.of(templateId, this.tenantService.getCurrentSysTenant()), () -> this.getQueryOptMetaData(templateId).multiValued().stream().map(webTemplateNode -> webTemplateNode.getAqlPath(false)).collect(Collectors.toList()));
    }

    @Override
    public I_KnowledgeCache getKnowledge() {
        return this;
    }

    private void validateTemplate(OPERATIONALTEMPLATE template) {
        if (template == null) {
            throw new InvalidApiParameterException("Could not parse input template");
        }
        if (template.getConcept() == null || template.getConcept().isEmpty()) {
            throw new IllegalArgumentException("Supplied template has nil or empty concept");
        }
        if (template.getLanguage() == null || template.getLanguage().isNil()) {
            throw new IllegalArgumentException("Supplied template has nil or empty language");
        }
        if (template.getDefinition() == null || template.getDefinition().isNil()) {
            throw new IllegalArgumentException("Supplied template has nil or empty definition");
        }
        if (template.getDescription() == null || !template.getDescription().validate()) {
            throw new IllegalArgumentException("Supplied template has nil or empty description");
        }
        if (!TemplateUtils.isSupported(template)) {
            throw new IllegalArgumentException(MessageFormat.format("The supplied template is not supported (unsupported types: {0})", String.join((CharSequence)",", TemplateUtils.UNSUPPORTED_RM_TYPES)));
        }
    }

    @Override
    public I_KnowledgeCache.ConceptValue getConceptByConceptId(int conceptId, String language, BiFunction<Integer, String, I_KnowledgeCache.ConceptValue> provider) {
        I_KnowledgeCache.ConceptValue concept = (I_KnowledgeCache.ConceptValue)this.conceptByConceptId.get((Object)Pair.of((Object)conceptId, (Object)language), I_KnowledgeCache.ConceptValue.class);
        if (concept == null) {
            concept = provider.apply(conceptId, language);
            this.addConceptToCaches(concept);
        }
        return concept;
    }

    @Override
    public I_KnowledgeCache.ConceptValue getConceptById(UUID id, Function<UUID, I_KnowledgeCache.ConceptValue> provider) {
        I_KnowledgeCache.ConceptValue concept = (I_KnowledgeCache.ConceptValue)this.conceptById.get((Object)id, I_KnowledgeCache.ConceptValue.class);
        if (concept == null) {
            concept = provider.apply(id);
            this.addConceptToCaches(concept);
        }
        return concept;
    }

    @Override
    public I_KnowledgeCache.ConceptValue getConceptByDescription(String description, String language, BiFunction<String, String, I_KnowledgeCache.ConceptValue> provider) {
        I_KnowledgeCache.ConceptValue concept = (I_KnowledgeCache.ConceptValue)this.conceptByDescription.get((Object)Pair.of((Object)description, (Object)language), I_KnowledgeCache.ConceptValue.class);
        if (concept == null) {
            concept = provider.apply(description, language);
            this.addConceptToCaches(concept);
        }
        return concept;
    }

    private void addConceptToCaches(I_KnowledgeCache.ConceptValue concept) {
        this.conceptById.put((Object)concept.getId(), (Object)concept);
        this.conceptByConceptId.put((Object)Pair.of((Object)concept.getConceptId(), (Object)concept.getLanguage()), (Object)concept);
        this.conceptByDescription.put((Object)Pair.of((Object)concept.getDescription(), (Object)concept.getLanguage()), (Object)concept);
    }

    @Override
    public I_KnowledgeCache.TerritoryValue getTerritoryCodeByTwoLetterCode(String territoryAsString, Function<String, I_KnowledgeCache.TerritoryValue> provider) {
        return (I_KnowledgeCache.TerritoryValue)this.territoryCache.get((Object)territoryAsString, () -> (I_KnowledgeCache.TerritoryValue)provider.apply(territoryAsString));
    }

    @Override
    public I_KnowledgeCache.LanguageValue getLanguageByCode(String languageCode, Function<String, I_KnowledgeCache.LanguageValue> provider) {
        return (I_KnowledgeCache.LanguageValue)this.languageCache.get((Object)languageCode, () -> (I_KnowledgeCache.LanguageValue)provider.apply(languageCode));
    }

    private static abstract class SecCtxAwareRunnable
    implements Runnable {
        private Authentication auth;

        private SecCtxAwareRunnable(Authentication auth) {
            this.auth = auth;
        }

        @Override
        public void run() {
            SecurityContextHolder.getContext().setAuthentication(this.auth);
            this.doRun();
        }

        abstract void doRun();
    }
}

