/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.service;

import com.nedap.archie.query.RMPathQuery;
import com.nedap.archie.rm.composition.Composition;
import com.nedap.archie.rm.ehr.EhrStatus;
import com.nedap.archie.rmobjectvalidator.APathQueryCache;
import com.nedap.archie.rmobjectvalidator.RMObjectValidationMessage;
import com.nedap.archie.rmobjectvalidator.RMObjectValidator;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.ehrbase.api.definitions.ServerConfig;
import org.ehrbase.api.exception.UnprocessableEntityException;
import org.ehrbase.api.exception.ValidationException;
import org.ehrbase.api.service.ValidationService;
import org.ehrbase.service.KnowledgeCacheService;
import org.ehrbase.terminology.openehr.TerminologyService;
import org.ehrbase.validation.CompositionValidator;
import org.ehrbase.validation.ConstraintViolationException;
import org.ehrbase.validation.terminology.ExternalTerminologyValidation;
import org.ehrbase.validation.terminology.ItemStructureVisitor;
import org.ehrbase.webtemplate.model.WebTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ValidationServiceImp
implements ValidationService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final Pattern NAMESPACE_PATTERN = Pattern.compile("[a-zA-Z][a-zA-Z0-9-_:/&+?]*");
    private final KnowledgeCacheService knowledgeCacheService;
    private final TerminologyService terminologyService;
    private final ThreadLocal<CompositionValidator> compositionValidator;
    private final Map<String, RMPathQuery> rmPathQueryCache = new ConcurrentHashMap<String, RMPathQuery>();

    public ValidationServiceImp(KnowledgeCacheService knowledgeCacheService, TerminologyService terminologyService, ServerConfig serverConfig, ObjectProvider<ExternalTerminologyValidation> objectProvider, @Value(value="${cache.validation.useSharedRMPathQueryCache:true}") boolean sharedAqlQueryCache) {
        APathQueryCache delegator;
        this.knowledgeCacheService = knowledgeCacheService;
        this.terminologyService = terminologyService;
        boolean disableStrictValidation = serverConfig.isDisableStrictValidation();
        if (disableStrictValidation) {
            this.logger.warn("Disabling strict invariant validation. Caution is advised.");
        }
        if (sharedAqlQueryCache) {
            delegator = new APathQueryCache(){

                public RMPathQuery getApathQuery(String query) {
                    return ValidationServiceImp.this.rmPathQueryCache.computeIfAbsent(query, RMPathQuery::new);
                }
            };
        } else {
            this.logger.warn("shared RMPathQueryCache is disabled");
            delegator = null;
        }
        this.compositionValidator = ThreadLocal.withInitial(() -> {
            CompositionValidator validator = ValidationServiceImp.createCompositionValidator(objectProvider, disableStrictValidation, delegator);
            return validator;
        });
    }

    private static CompositionValidator createCompositionValidator(ObjectProvider<ExternalTerminologyValidation> objectProvider, boolean disableStrictValidation, APathQueryCache delegator) {
        CompositionValidator validator = new CompositionValidator();
        objectProvider.ifAvailable(arg_0 -> ((CompositionValidator)validator).setExternalTerminologyValidation(arg_0));
        validator.setRunInvariantChecks(!disableStrictValidation);
        ValidationServiceImp.setSharedAqlQueryCache(validator, delegator);
        return validator;
    }

    private static void setSharedAqlQueryCache(CompositionValidator validator, APathQueryCache delegator) {
        if (delegator == null) {
            return;
        }
        try {
            Field queryCacheField = RMObjectValidator.class.getDeclaredField("queryCache");
            queryCacheField.setAccessible(true);
            queryCacheField.set(validator.getRmObjectValidator(), delegator);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException("Failed to inject shared RMPathQuery cache", e);
        }
    }

    public void check(String templateID, Composition composition) throws Exception {
        WebTemplate webTemplate;
        try {
            webTemplate = this.knowledgeCacheService.getQueryOptMetaData(templateID);
        }
        catch (IllegalArgumentException e) {
            throw new UnprocessableEntityException(e.getMessage());
        }
        List constraintViolations = this.compositionValidator.get().validate(composition, webTemplate);
        if (!constraintViolations.isEmpty()) {
            throw new ConstraintViolationException(constraintViolations);
        }
        ItemStructureVisitor itemStructureVisitor = new ItemStructureVisitor(this.terminologyService);
        itemStructureVisitor.validate(composition);
    }

    public void check(Composition composition) throws Exception {
        if (composition.getName() == null) {
            throw new IllegalArgumentException("Composition missing mandatory attribute: name");
        }
        if (composition.getArchetypeNodeId() == null) {
            throw new IllegalArgumentException("Composition missing mandatory attribute: archetype_node_id");
        }
        if (composition.getLanguage() == null) {
            throw new IllegalArgumentException("Composition missing mandatory attribute: language");
        }
        if (composition.getCategory() == null) {
            throw new IllegalArgumentException("Composition missing mandatory attribute: category");
        }
        if (composition.getComposer() == null) {
            throw new IllegalArgumentException("Composition missing mandatory attribute: composer");
        }
        if (composition.getArchetypeDetails() == null) {
            throw new IllegalArgumentException("Composition missing mandatory attribute: archetype details");
        }
        if (composition.getArchetypeDetails().getTemplateId() == null) {
            throw new IllegalArgumentException("Composition missing mandatory attribute: archetype details/template_id");
        }
        this.check(composition.getArchetypeDetails().getTemplateId().getValue(), composition);
        this.logger.debug("Composition validated successfully");
    }

    public void check(EhrStatus ehrStatus) {
        if (ehrStatus == null) {
            return;
        }
        List rmObjectValidationMessages = this.compositionValidator.get().getRmObjectValidator().validate((Object)ehrStatus);
        if (!rmObjectValidationMessages.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (RMObjectValidationMessage rmObjectValidationMessage : rmObjectValidationMessages) {
                stringBuilder.append(rmObjectValidationMessage.toString());
                stringBuilder.append("\n");
            }
            throw new ValidationException(stringBuilder.toString());
        }
        if (ehrStatus.getSubject() == null) {
            throw new ValidationException("subject is required");
        }
        if (ehrStatus.getSubject().getExternalRef() != null) {
            if (ehrStatus.getSubject().getExternalRef().getId() == null || ehrStatus.getSubject().getExternalRef().getId().getValue().isEmpty()) {
                throw new ValidationException("ExternalRef ID is required");
            }
            if (ehrStatus.getSubject().getExternalRef().getNamespace() == null) {
                throw new ValidationException("ExternalRef namespace is required");
            }
            if (!NAMESPACE_PATTERN.matcher(ehrStatus.getSubject().getExternalRef().getNamespace()).matches()) {
                throw new ValidationException("Subject's namespace format invalid");
            }
        }
    }
}

