/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.sql.queryimpl;

import java.util.List;
import org.ehrbase.aql.sql.queryimpl.IQueryImpl;
import org.ehrbase.aql.sql.queryimpl.ItemInfo;
import org.ehrbase.aql.sql.queryimpl.PGType;
import org.ehrbase.aql.sql.queryimpl.SegmentedPath;
import org.ehrbase.service.IntrospectService;
import org.jooq.DataType;

public class DataTypeFromTemplate {
    private final IntrospectService introspectCache;
    private String itemType;
    private String itemCategory;
    private DataType identifiedType = null;
    private final boolean ignoreUnresolvedIntrospect;
    private final IQueryImpl.Clause clause;

    public DataTypeFromTemplate(IntrospectService introspectCache, boolean ignoreUnresolvedIntrospect, IQueryImpl.Clause clause) {
        this.introspectCache = introspectCache;
        this.ignoreUnresolvedIntrospect = ignoreUnresolvedIntrospect;
        this.clause = clause;
    }

    public void evaluate(String templateId, List<String> referenceItemPathArray) {
        block4: {
            try {
                if (this.introspectCache == null) {
                    throw new IllegalArgumentException("MetaDataCache is not initialized");
                }
                String reducedItemPathArray = new SegmentedPath(referenceItemPathArray).reduce();
                if (reducedItemPathArray != null && !reducedItemPathArray.isEmpty()) {
                    ItemInfo info = this.introspectCache.getInfo(templateId, reducedItemPathArray);
                    this.itemType = info.getItemType();
                    this.itemCategory = info.getItemCategory();
                    this.identifiedType = this.itemType != null ? new PGType(referenceItemPathArray, this.clause).forRmType(this.itemType) : new PGType(referenceItemPathArray, this.clause).forRmType("UNKNOWN");
                }
            }
            catch (Exception e) {
                if (this.ignoreUnresolvedIntrospect) break block4;
                throw new IllegalArgumentException("Unresolved type, missing template?(" + templateId + "), reason:" + e);
            }
        }
    }

    public String getItemType() {
        return this.itemType;
    }

    public String getItemCategory() {
        return this.itemCategory;
    }

    public DataType getIdentifiedType() {
        return this.identifiedType;
    }
}

