/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.sql.queryimpl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.aql.sql.queryimpl.IIterativeNode;
import org.ehrbase.dao.access.interfaces.I_DomainAccess;
import org.ehrbase.ehr.util.LocatableHelper;
import org.ehrbase.service.IntrospectService;

public class IterativeNode
implements IIterativeNode {
    public static final String SLASH = "/";
    public static final String ACTIVITIES = "/activities";
    public static final String COMPOSITION = "/composition";
    public static final String EVENTS = "/events";
    public static final String CONTENT = "/content";
    private Optional<Pattern> ignorePattern;
    private final List<String> unbounded;
    private final int depth;
    private final I_DomainAccess domainAccess;

    public IterativeNode(I_DomainAccess domainAccess, String templateId, IntrospectService introspectCache) {
        this.domainAccess = domainAccess;
        this.unbounded = introspectCache.multiValued(templateId);
        this.ignorePattern = this.initIgnorePattern();
        this.depth = this.initAqlDepth();
    }

    int[] iterativeAt(List<String> segmentedPath) {
        if (this.unbounded.isEmpty()) {
            return null;
        }
        TreeSet<Integer> retarray = new TreeSet<Integer>();
        for (int i = this.unbounded.size() - 1; i >= 0; --i) {
            String path;
            String aqlPath = this.unbounded.get(i);
            List<String> aqlPathSegments = LocatableHelper.dividePathIntoSegments(aqlPath);
            boolean ignoreThisAqlPath = this.ignorePattern.map(p -> p.matcher((CharSequence)aqlPathSegments.get(aqlPathSegments.size() - 1))).map(Matcher::matches).orElse(false);
            if (ignoreThisAqlPath || !(path = IterativeNode.compact(segmentedPath).stream().collect(Collectors.joining(SLASH, SLASH, ""))).startsWith(aqlPath) || StringUtils.endsWithAny((CharSequence)aqlPath, (CharSequence[])new CharSequence[]{"value", "name"})) continue;
            int pos = IterativeNode.aqlPathInJsonbArray(aqlPathSegments, segmentedPath);
            retarray.add(pos);
            if (retarray.size() >= this.depth) break;
        }
        return retarray.stream().mapToInt(Integer::intValue).toArray();
    }

    List<String> clipInIterativeMarkers(List<String> segmentedPath, int[] clipPos) {
        ArrayList<String> resultingPath = new ArrayList<String>(segmentedPath);
        ArrayUtils.reverse((int[])clipPos);
        Arrays.stream(clipPos).forEach(pos -> {
            if (pos == resultingPath.size()) {
                resultingPath.add("$AQL_NODE_ITERATIVE$");
            } else {
                String segment = (String)resultingPath.get(pos);
                if (!segment.equals("$AQL_NODE_NAME_PREDICATE$")) {
                    if (segment.equals("0")) {
                        resultingPath.set(pos, "$AQL_NODE_ITERATIVE$");
                    } else {
                        resultingPath.add(pos, "$AQL_NODE_ITERATIVE$");
                    }
                }
            }
        });
        return resultingPath;
    }

    public List<String> insertIterativeMarkers(List<String> segmentedPath) {
        int[] pos = this.iterativeAt(segmentedPath);
        if (pos == null) {
            return null;
        }
        if (ArrayUtils.isEmpty((int[])pos)) {
            return segmentedPath;
        }
        return this.clipInIterativeMarkers(segmentedPath, pos);
    }

    static List<String> compact(List<String> segmentedPath) {
        return segmentedPath.stream().filter(item -> !StringUtils.isNumeric((CharSequence)item)).filter(item -> !item.startsWith(COMPOSITION)).filter(item -> !Set.of(EVENTS, ACTIVITIES).contains(item)).map(item -> StringUtils.removeStart((String)item, (String)SLASH)).collect(Collectors.toList());
    }

    static int aqlPathInJsonbArray(List<String> aqlSegmented, List<String> jsonbSegmented) {
        int jsonbIndex = 0;
        int aqlSegIndex = 0;
        while (aqlSegIndex < aqlSegmented.size()) {
            String segment = jsonbSegmented.get(jsonbIndex);
            if (!(segment.startsWith(COMPOSITION) || StringUtils.isNumeric((CharSequence)segment) || StringUtils.isNumeric((CharSequence)segment) || Set.of(EVENTS, ACTIVITIES).contains(segment))) {
                try {
                    if (segment.startsWith(SLASH) ? !$assertionsDisabled && !segment.substring(1).equals(aqlSegmented.get(aqlSegIndex)) : !$assertionsDisabled && !segment.equals(aqlSegmented.get(aqlSegIndex))) {
                        throw new AssertionError();
                    }
                }
                catch (AssertionError e1) {
                    throw new AssertionError((Object)("Drift in locating array marker: aql:" + aqlSegmented.get(aqlSegIndex) + ", jsonb:" + segment + ", @index:" + jsonbIndex));
                }
                ++aqlSegIndex;
            }
            ++jsonbIndex;
        }
        return jsonbIndex;
    }

    private Optional<Pattern> initIgnorePattern() {
        String ignoreIterativeNode = System.getenv("aql.ignoreIterativeNodeList");
        if (ignoreIterativeNode == null && StringUtils.isBlank((CharSequence)(ignoreIterativeNode = this.domainAccess.getServerConfig().getAqlIterationSkipList()))) {
            ignoreIterativeNode = "/content,/events";
        }
        return Optional.ofNullable(ignoreIterativeNode).filter(StringUtils::isNotBlank).map(String::trim).map(s -> s.replace(',', '|')).map(s -> "^(" + s + ").*").map(Pattern::compile);
    }

    private int initAqlDepth() {
        if (System.getenv("aql.iterationScanDepth") != null) {
            return Integer.parseInt(System.getenv("aql.iterationScanDepth"));
        }
        if (this.domainAccess.getServerConfig().getAqlDepth() != null) {
            return this.domainAccess.getServerConfig().getAqlDepth();
        }
        return 1;
    }
}

