/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.dao.access.util;

import java.util.function.ToIntFunction;
import org.ehrbase.dao.access.util.SemVer;
import org.ehrbase.dao.access.util.VersionConflictException;
import org.springframework.lang.NonNull;

public class SemVerUtil {
    @NonNull
    public static SemVer determineVersion(@NonNull SemVer requestSemVer, @NonNull SemVer dbSemVer) throws VersionConflictException {
        int patch;
        int minor;
        int major;
        if (requestSemVer.isNoVersion()) {
            major = SemVerUtil.incrementOrDefault(dbSemVer, SemVer::major, 1);
            minor = 0;
            patch = 0;
        } else {
            if (!requestSemVer.isPartial()) {
                if (!dbSemVer.isNoVersion() && !requestSemVer.isPreRelease()) {
                    throw new VersionConflictException("Release versions must not be replaced");
                }
                return requestSemVer;
            }
            if (requestSemVer.minor() == null) {
                major = requestSemVer.major();
                minor = SemVerUtil.incrementOrDefault(dbSemVer, SemVer::minor, 0);
                patch = 0;
            } else {
                major = requestSemVer.major();
                minor = requestSemVer.minor();
                patch = SemVerUtil.incrementOrDefault(dbSemVer, SemVer::patch, 0);
            }
        }
        return new SemVer(major, minor, patch, null);
    }

    private static int incrementOrDefault(SemVer semVer, ToIntFunction<SemVer> func, int fallback) {
        if (semVer.isNoVersion()) {
            return fallback;
        }
        return func.applyAsInt(semVer) + 1;
    }
}

