/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.repository;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.ehrbase.api.exception.InternalServerException;
import org.jooq.DSLContext;
import org.jooq.Loader;
import org.jooq.Record;
import org.jooq.Table;

public class RepositoryHelper {
    private RepositoryHelper() {
    }

    public static <T extends Record> void executeBulkInsert(DSLContext context, List<T> recordList, Table<?> table) {
        try {
            Loader execute = context.loadInto(table).bulkAfter(500).loadRecords(recordList).fields(table.fields()).execute();
            if (!execute.result().errors().isEmpty()) {
                throw new InternalServerException(execute.result().errors().stream().map(e -> e.exception().getMessage()).collect(Collectors.joining(";")));
            }
        }
        catch (IOException e2) {
            throw new InternalServerException((Throwable)e2);
        }
    }
}

