/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.util;

import com.nedap.archie.rm.generic.PartyIdentified;
import com.nedap.archie.rm.generic.PartyProxy;
import com.nedap.archie.rm.generic.PartyRelated;
import com.nedap.archie.rm.generic.PartySelf;
import com.nedap.archie.rm.support.identification.PartyRef;
import java.util.Objects;
import org.ehrbase.api.exception.InternalServerException;

public class PartyUtils {
    private PartyUtils() {
    }

    public static boolean isEmpty(PartyProxy partyProxy) {
        if (partyProxy == null) {
            return true;
        }
        if (PartyUtils.isPartySelf(partyProxy)) {
            return PartyUtils.isEmpty((PartySelf)partyProxy);
        }
        if (PartyUtils.isPartyIdentified(partyProxy)) {
            return PartyUtils.isEmpty((PartyIdentified)partyProxy);
        }
        if (PartyUtils.isPartyRelated(partyProxy)) {
            return PartyUtils.isEmpty((PartyRelated)partyProxy);
        }
        throw new InternalServerException("Unhandled Party type detected:" + partyProxy.getClass().getSimpleName());
    }

    public static boolean isEmpty(PartyIdentified partyIdentified) {
        if (partyIdentified == null) {
            return true;
        }
        return partyIdentified.getName() == null && partyIdentified.getIdentifiers().isEmpty() && (partyIdentified.getExternalRef() == null || PartyUtils.isEmpty(partyIdentified.getExternalRef()));
    }

    public static boolean isEmpty(PartySelf partySelf) {
        if (partySelf == null) {
            return true;
        }
        return partySelf.getExternalRef() == null || PartyUtils.isEmpty(partySelf.getExternalRef());
    }

    public static boolean isEmpty(PartyRef partyRef) {
        if (partyRef == null) {
            return true;
        }
        return partyRef.getId() == null && partyRef.getNamespace() == null && partyRef.getType() == null;
    }

    public static boolean isEmpty(PartyRelated partyRelated) {
        if (partyRelated == null) {
            return true;
        }
        return partyRelated.getName() == null && partyRelated.getIdentifiers().isEmpty() && partyRelated.getRelationship() == null && (partyRelated.getExternalRef() == null || PartyUtils.isEmpty(partyRelated.getExternalRef()));
    }

    public static boolean isPartySelf(PartyProxy partyProxy) {
        return Objects.equals(partyProxy.getClass().getSimpleName(), "PartySelf");
    }

    public static boolean isPartyIdentified(PartyProxy partyProxy) {
        return Objects.equals(partyProxy.getClass().getSimpleName(), "PartyIdentified");
    }

    public static boolean isPartyRelated(PartyProxy partyProxy) {
        return Objects.equals(partyProxy.getClass().getSimpleName(), "PartyRelated");
    }
}

