/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.dao.access.interfaces;

import com.nedap.archie.rm.datastructures.ItemStructure;
import com.nedap.archie.rm.ehr.EhrStatus;
import com.nedap.archie.rm.support.identification.ObjectVersionId;
import java.sql.Timestamp;
import java.util.Map;
import java.util.UUID;
import org.ehrbase.dao.access.interfaces.I_AuditDetailsAccess;
import org.ehrbase.dao.access.interfaces.I_Compensatable;
import org.ehrbase.dao.access.interfaces.I_ConceptAccess;
import org.ehrbase.dao.access.interfaces.I_ContributionAccess;
import org.ehrbase.dao.access.interfaces.I_DomainAccess;
import org.ehrbase.dao.access.interfaces.I_VersionedCRUD;
import org.ehrbase.dao.access.jooq.StatusAccess;
import org.ehrbase.jooq.pg.tables.records.StatusHistoryRecord;
import org.ehrbase.jooq.pg.tables.records.StatusRecord;

public interface I_StatusAccess
extends I_VersionedCRUD,
I_Compensatable {
    public static I_StatusAccess retrieveByVersion(I_DomainAccess domainAccess, UUID statusId, int version) {
        return StatusAccess.retrieveByVersion(domainAccess, statusId, version);
    }

    public static I_StatusAccess retrieveInstance(I_DomainAccess domainAccess, UUID statusId) {
        return StatusAccess.retrieveInstance(domainAccess, statusId);
    }

    public static I_StatusAccess retrieveInstanceByParty(I_DomainAccess domainAccess, UUID partyIdentified) {
        return StatusAccess.retrieveInstanceByParty(domainAccess, partyIdentified);
    }

    public static I_StatusAccess retrieveInstanceByEhrId(I_DomainAccess domainAccess, UUID ehrId) {
        return StatusAccess.retrieveInstanceByEhrId(domainAccess, ehrId);
    }

    public static I_StatusAccess retrieveInstanceByNamedSubject(I_DomainAccess domainAccess, String partyName) {
        return StatusAccess.retrieveInstanceByNamedSubject(domainAccess, partyName);
    }

    public static Map<ObjectVersionId, I_StatusAccess> retrieveInstanceByContribution(I_DomainAccess domainAccess, UUID contributionId, String node) {
        return StatusAccess.retrieveInstanceByContribution(domainAccess, contributionId, node);
    }

    @Override
    public UUID getId();

    public void setStatusRecord(StatusRecord var1);

    public void setStatusRecord(StatusHistoryRecord var1);

    public StatusRecord getStatusRecord();

    public void setAuditDetailsAccess(I_AuditDetailsAccess var1);

    public void setContributionAccess(I_ContributionAccess var1);

    public I_AuditDetailsAccess getAuditDetailsAccess();

    public UUID getAuditDetailsId();

    public void setContributionId(UUID var1);

    @Override
    public UUID getContributionId();

    public void setAuditAndContributionAuditValues(UUID var1, UUID var2, String var3, I_ConceptAccess.ContributionChangeType var4);

    public static Integer getLatestVersionNumber(I_DomainAccess domainAccess, UUID statusId) {
        return StatusAccess.getLatestVersionNumber(domainAccess, statusId);
    }

    public int getEhrStatusVersionFromTimeStamp(Timestamp var1);

    public Timestamp getInitialTimeOfVersionedEhrStatus();

    public static boolean exists(I_DomainAccess domainAccess, UUID ehrStatusId) {
        return StatusAccess.exists(domainAccess, ehrStatusId);
    }

    public static Map<Integer, I_StatusAccess> getVersionMapOfStatus(I_DomainAccess domainAccess, UUID statusId) {
        return StatusAccess.getVersionMapOfStatus(domainAccess, statusId);
    }

    public EhrStatus getStatus();

    public void setOtherDetails(ItemStructure var1);

    public ItemStructure getOtherDetails();

    public void setEhrId(UUID var1);

    public UUID getEhrId();
}

