/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.service;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.ehrbase.api.definitions.ServerConfig;
import org.ehrbase.dao.access.interfaces.I_DomainAccess;
import org.ehrbase.dao.access.interfaces.I_TemplateStoreAccess;
import org.ehrbase.dao.access.support.ServiceDataAccess;
import org.ehrbase.ehr.knowledge.TemplateMetaData;
import org.ehrbase.service.TemplateStorage;
import org.jooq.DSLContext;
import org.openehr.schemas.v1.OPERATIONALTEMPLATE;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class TemplateDBStorageService
implements TemplateStorage {
    private final DSLContext context;
    private final ServerConfig serverConfig;

    public TemplateDBStorageService(DSLContext context, ServerConfig serverConfig) {
        this.context = context;
        this.serverConfig = serverConfig;
    }

    @Override
    public List<TemplateMetaData> listAllOperationalTemplates() {
        return I_TemplateStoreAccess.fetchAll(this.getDataAccess());
    }

    @Override
    public Set<String> findAllTemplateIds() {
        return I_TemplateStoreAccess.fetchAllTemplateIds(this.getDataAccess());
    }

    @Override
    public void storeTemplate(OPERATIONALTEMPLATE template, Short sysTenant) {
        if (this.readOperationaltemplate(template.getTemplateId().getValue()).isPresent()) {
            I_TemplateStoreAccess.getInstance(this.getDataAccess(), template, sysTenant).update();
        } else {
            I_TemplateStoreAccess.getInstance(this.getDataAccess(), template, sysTenant).commit();
        }
    }

    @Override
    public Optional<OPERATIONALTEMPLATE> readOperationaltemplate(String templateId) {
        return Optional.ofNullable(I_TemplateStoreAccess.retrieveInstanceByTemplateId(this.getDataAccess(), templateId).getTemplate());
    }

    @Override
    public String adminUpdateTemplate(OPERATIONALTEMPLATE template) {
        return I_TemplateStoreAccess.adminUpdateTemplate(this.getDataAccess(), template);
    }

    @Override
    public boolean deleteTemplate(String templateId) {
        return I_TemplateStoreAccess.deleteTemplate(this.getDataAccess(), templateId);
    }

    @Override
    public int adminDeleteAllTemplates(List<TemplateMetaData> templateMetaDataList) {
        return I_TemplateStoreAccess.adminDeleteAllTemplates(this.getDataAccess());
    }

    protected I_DomainAccess getDataAccess() {
        return new ServiceDataAccess(this.context, null, null, this.serverConfig);
    }
}

