/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.containment;

import java.util.List;
import org.apache.commons.collections4.set.ListOrderedSet;
import org.ehrbase.aql.containment.ContainOperator;
import org.ehrbase.aql.containment.Containment;

public class ContainmentSet {
    private int serial;
    private Containment enclosing;
    private ContainmentSet parentSet;
    private ListOrderedSet<Object> containmentList = new ListOrderedSet();

    public ContainmentSet(int serial, Containment enclosing) {
        this.serial = serial;
        this.enclosing = enclosing;
    }

    public void add(Containment containment) {
        this.containmentList.add((Object)containment);
    }

    public void addAll(List<Containment> containments) {
        this.containmentList.addAll(containments);
    }

    public void add(String operator) {
        this.containmentList.add((Object)new ContainOperator(operator));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.serial + "|");
        if (!this.containmentList.isEmpty()) {
            boolean comma = false;
            for (Object item : this.containmentList) {
                if (comma) {
                    sb.append(",");
                }
                comma = true;
                if (item instanceof Containment) {
                    sb.append(item);
                    continue;
                }
                if (item instanceof ContainOperator) {
                    sb.append(((ContainOperator)item).getOperator());
                    continue;
                }
                if (item instanceof String) {
                    sb.append(item);
                    continue;
                }
                sb.append("-- Unhandled Item Type --");
            }
        } else {
            sb.append("--EMPTY SET--");
        }
        if (this.parentSet != null) {
            sb.append("<<<IN PARENT#" + this.parentSet.serial);
        } else {
            sb.append("<<< ROOT");
        }
        return sb.toString();
    }

    public int size() {
        return this.containmentList.size();
    }

    public boolean isEmpty() {
        return this.containmentList.isEmpty() && this.enclosing.getSymbol() == null && this.enclosing.getClassName() == null;
    }

    public void setParentSet(ContainmentSet parentSet) {
        this.parentSet = parentSet;
    }

    public ListOrderedSet<Object> getContainmentList() {
        return this.containmentList;
    }

    public ContainmentSet getParentSet() {
        return this.parentSet;
    }

    public Containment getEnclosing() {
        return this.enclosing;
    }
}

