/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.sql.queryimpl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.ehrbase.aql.sql.queryimpl.EntryAttributeMapper;
import org.ehrbase.aql.sql.queryimpl.JsonbEntryQuery;
import org.ehrbase.aql.sql.queryimpl.NodeNameValuePredicate;
import org.ehrbase.aql.sql.queryimpl.value_field.NodePredicate;
import org.ehrbase.ehr.util.LocatableHelper;

public final class JqueryPath {
    private final JsonbEntryQuery.PATH_PART pathPart;
    private final String path;
    private final String defaultIndex;
    private static final String[] listIdentifier = new String[]{"/content", "/items", "/activities", "/events"};
    private static final Pattern INDEX_PATTERN = Pattern.compile("[0-9]*|#");

    public JqueryPath(JsonbEntryQuery.PATH_PART pathPart, String path, String defaultIndex) {
        this.pathPart = pathPart;
        this.path = path;
        this.defaultIndex = defaultIndex;
    }

    public List<String> evaluate() {
        return JqueryPath.evaluate(this.pathPart, this.path, this.defaultIndex);
    }

    public static List<String> evaluate(JsonbEntryQuery.PATH_PART pathPart, String path, String defaultIndex) {
        if (path == null) {
            return new ArrayList<String>();
        }
        int offset = 0;
        List<String> segments = LocatableHelper.dividePathIntoSegments(path);
        List<String> jqueryPath = new ArrayList<String>();
        for (int i = offset; i < segments.size(); ++i) {
            Object nodeId = segments.get(i);
            if (!((String)nodeId).equals("/other_context".substring(1))) {
                nodeId = "/" + (String)nodeId;
            }
            JqueryPath.encodeTreeMapNodeId(jqueryPath, (String)nodeId);
            NodePredicate nodePredicate = new NodePredicate((String)nodeId);
            if (nodePredicate.hasPredicate()) {
                jqueryPath = new NodeNameValuePredicate(nodePredicate).path(jqueryPath, (String)nodeId);
            } else {
                nodeId = nodePredicate.removeNameValuePredicate();
                jqueryPath.add((String)nodeId);
            }
            if (!JqueryPath.isList((String)nodeId)) continue;
            jqueryPath.add(defaultIndex);
        }
        if (pathPart.equals((Object)JsonbEntryQuery.PATH_PART.VARIABLE_PATH_PART)) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = jqueryPath.size() - 1; !(i < 0 || INDEX_PATTERN.matcher((CharSequence)jqueryPath.get(i)).matches() || ((String)jqueryPath.get(i)).contains("[") || jqueryPath.get(i).startsWith("'")); --i) {
                String item = jqueryPath.remove(i);
                stringBuilder.insert(0, item);
            }
            String nodeId = EntryAttributeMapper.map(stringBuilder.toString());
            if (nodeId != null) {
                if (defaultIndex.equals("#")) {
                    if (nodeId.contains(",")) {
                        String[] parts = nodeId.split(",");
                        jqueryPath.addAll(Arrays.asList(parts));
                    } else {
                        jqueryPath.add(nodeId);
                    }
                } else {
                    jqueryPath.add(nodeId);
                }
            }
        }
        return jqueryPath;
    }

    private static void encodeTreeMapNodeId(List<String> jqueryPath, String nodeId) {
        if (nodeId.startsWith("/events")) {
            jqueryPath.add("/events");
        } else if (nodeId.startsWith("/activities")) {
            jqueryPath.add("/activities");
        }
    }

    private static boolean isList(String predicate) {
        if (predicate.equals("/activities")) {
            return false;
        }
        for (String identifier : listIdentifier) {
            if (!predicate.startsWith(identifier)) continue;
            return true;
        }
        return false;
    }
}

