/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.dao.access.jooq.party;

import com.nedap.archie.rm.generic.PartyProxy;
import com.nedap.archie.rm.support.identification.GenericId;
import com.nedap.archie.rm.support.identification.ObjectId;
import com.nedap.archie.rm.support.identification.PartyRef;
import java.util.Optional;
import org.ehrbase.dao.access.jooq.party.PersistedObjectId;
import org.ehrbase.jooq.pg.enums.PartyRefIdType;

public class PartyRefValue {
    private final PartyProxy partyProxy;
    private String namespace = null;
    private String value = null;
    private String scheme = null;
    private String type = null;
    private PartyRefIdType objectIdType = PartyRefIdType.undefined;

    public PartyRefValue(PartyProxy partyProxy) {
        this.partyProxy = partyProxy;
    }

    public PartyRefValue attributes() {
        if (this.partyProxy.getExternalRef() != null) {
            PartyRef partyRef = this.partyProxy.getExternalRef();
            this.namespace = partyRef.getNamespace();
            ObjectId objectId = partyRef.getId();
            this.value = Optional.ofNullable(objectId).map(ObjectId::getValue).orElse(null);
            if (objectId instanceof GenericId) {
                GenericId genericId = (GenericId)objectId;
                this.scheme = genericId.getScheme();
            }
            this.type = partyRef.getType();
            this.objectIdType = PartyRefIdType.valueOf((String)new PersistedObjectId().objectIdClassSnakeCase(partyRef));
        }
        return this;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getValue() {
        return this.value;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getType() {
        return this.type;
    }

    public PartyRefIdType getObjectIdType() {
        return this.objectIdType;
    }
}

