/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.service;

import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.archetyped.Locatable;
import com.nedap.archie.rm.archetyped.TemplateId;
import com.nedap.archie.rm.changecontrol.Version;
import com.nedap.archie.rm.composition.Composition;
import com.nedap.archie.rm.datatypes.CodePhrase;
import com.nedap.archie.rm.datavalues.DvCodedText;
import com.nedap.archie.rm.datavalues.DvText;
import com.nedap.archie.rm.datavalues.quantity.datetime.DvDateTime;
import com.nedap.archie.rm.directory.Folder;
import com.nedap.archie.rm.ehr.EhrStatus;
import com.nedap.archie.rm.generic.AuditDetails;
import com.nedap.archie.rm.generic.PartyProxy;
import com.nedap.archie.rm.support.identification.ObjectVersionId;
import com.nedap.archie.rm.support.identification.TerminologyId;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.TemporalAccessor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.ehrbase.api.definitions.ServerConfig;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.api.exception.InvalidApiParameterException;
import org.ehrbase.api.exception.ObjectNotFoundException;
import org.ehrbase.api.exception.PreconditionFailedException;
import org.ehrbase.api.exception.UnexpectedSwitchCaseException;
import org.ehrbase.api.exception.UnprocessableEntityException;
import org.ehrbase.api.exception.ValidationException;
import org.ehrbase.api.service.CompositionService;
import org.ehrbase.api.service.ContributionService;
import org.ehrbase.api.service.EhrService;
import org.ehrbase.api.service.TenantService;
import org.ehrbase.dao.access.interfaces.I_AuditDetailsAccess;
import org.ehrbase.dao.access.interfaces.I_CompositionAccess;
import org.ehrbase.dao.access.interfaces.I_ConceptAccess;
import org.ehrbase.dao.access.interfaces.I_ContributionAccess;
import org.ehrbase.dao.access.interfaces.I_StatusAccess;
import org.ehrbase.dao.access.jooq.AuditDetailsAccess;
import org.ehrbase.dao.access.jooq.party.PersistedPartyProxy;
import org.ehrbase.openehr.sdk.response.dto.ehrscape.CompositionFormat;
import org.ehrbase.openehr.sdk.response.dto.ehrscape.ContributionDto;
import org.ehrbase.repository.ContributionRepository;
import org.ehrbase.service.BaseServiceImp;
import org.ehrbase.service.ContributionServiceHelper;
import org.ehrbase.service.InternalDirectoryService;
import org.ehrbase.service.KnowledgeCacheService;
import org.jooq.DSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ContributionServiceImp
extends BaseServiceImp
implements ContributionService {
    public static final String TYPE_COMPOSITION = "COMPOSITION";
    public static final String TYPE_EHRSTATUS = "EHR_STATUS";
    public static final String TYPE_FOLDER = "FOLDER";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final CompositionService compositionService;
    private final EhrService ehrService;
    private final InternalDirectoryService folderService;
    private final TenantService tenantService;
    private final ContributionRepository contributionRepository;

    @Autowired
    public ContributionServiceImp(KnowledgeCacheService knowledgeCacheService, CompositionService compositionService, EhrService ehrService, InternalDirectoryService folderService, DSLContext context, ServerConfig serverConfig, TenantService tenantService, ContributionRepository contributionRepository) {
        super(knowledgeCacheService, context, serverConfig);
        this.compositionService = compositionService;
        this.ehrService = ehrService;
        this.folderService = folderService;
        this.tenantService = tenantService;
        this.contributionRepository = contributionRepository;
    }

    public boolean hasContribution(UUID ehrId, UUID contributionId) {
        I_ContributionAccess contributionAccess;
        if (!this.ehrService.hasEhr(ehrId)) {
            throw new ObjectNotFoundException("ehr", "No EHR found with given ID: " + ehrId.toString());
        }
        try {
            contributionAccess = I_ContributionAccess.retrieveInstance(this.getDataAccess(), contributionId);
        }
        catch (InternalServerException e) {
            return false;
        }
        if (contributionAccess == null) {
            return false;
        }
        return contributionAccess.getEhrId().equals(ehrId);
    }

    public Optional<ContributionDto> getContribution(UUID ehrId, UUID contributionId) {
        if (!this.hasContribution(ehrId, contributionId)) {
            throw new ObjectNotFoundException("contribution", "Contribution with given ID does not exist");
        }
        ContributionDto contribution = new ContributionDto(contributionId, this.retrieveUuidsOfContributionObjects(ehrId, contributionId), this.retrieveAuditDetails(contributionId));
        return Optional.of(contribution);
    }

    public UUID commitContribution(UUID ehrId, String content, CompositionFormat format) {
        if (!this.ehrService.hasEhr(ehrId)) {
            throw new ObjectNotFoundException("ehr", "No EHR found with given ID: " + ehrId.toString());
        }
        Short sysTenant = this.tenantService.getCurrentSysTenant();
        I_ContributionAccess contributionAccess = I_ContributionAccess.getInstance(this.getDataAccess(), ehrId, sysTenant);
        AuditDetails audit = ContributionServiceHelper.parseAuditDetails(content, format);
        contributionAccess.setAuditDetailsValues(audit);
        UUID contributionId = contributionAccess.commit(null, null, null);
        List<Version> versions = ContributionServiceHelper.parseVersions(content, format);
        if (versions.isEmpty()) {
            throw new InvalidApiParameterException("Invalid Contribution, must have at least one Version object.");
        }
        for (Version version : versions) {
            Object versionData = version.getData();
            if (versionData != null) {
                SupportedClasses versionClass;
                if (!(versionData instanceof LinkedHashMap)) {
                    throw new IllegalArgumentException("Contribution input can't be processed");
                }
                RMObject versionRmObject = ContributionServiceHelper.unmarshalMapContentToRmObject((LinkedHashMap)versionData, format);
                try {
                    versionClass = SupportedClasses.valueOf(versionRmObject.getClass().getSimpleName().toUpperCase());
                }
                catch (Exception e) {
                    throw new InvalidApiParameterException("Invalid version object in contribution. " + versionRmObject.getClass().getSimpleName().toUpperCase() + " not supported.");
                }
                switch (versionClass) {
                    case COMPOSITION: {
                        try {
                            this.processCompositionVersion(ehrId, contributionId, version, (Composition)versionRmObject);
                            break;
                        }
                        catch (UnprocessableEntityException e) {
                            throw new ValidationException(e.getMessage());
                        }
                    }
                    case EHRSTATUS: {
                        this.processEhrStatusVersion(ehrId, contributionId, version, (EhrStatus)versionRmObject);
                        break;
                    }
                    case FOLDER: {
                        this.processFolderVersion(ehrId, contributionId, version, (Folder)versionRmObject);
                        break;
                    }
                    default: {
                        throw new UnexpectedSwitchCaseException((Enum)versionClass);
                    }
                }
                continue;
            }
            this.processMetadataVersion(ehrId, contributionId, version);
        }
        return contributionId;
    }

    private void processCompositionVersion(UUID ehrId, UUID contributionId, Version version, Composition versionRmObject) {
        I_ConceptAccess.ContributionChangeType changeType = I_ConceptAccess.ContributionChangeType.valueOf(version.getCommitAudit().getChangeType().getValue().toUpperCase());
        this.checkContributionRules(version, changeType);
        UUID audit = this.contributionRepository.createAudit(version.getCommitAudit());
        switch (changeType) {
            case CREATION: {
                this.compositionService.create(ehrId, (Locatable)versionRmObject, contributionId, audit);
                break;
            }
            case AMENDMENT: 
            case MODIFICATION: {
                String actualPreceding = this.getAndCheckActualPreceding(version);
                this.compositionService.update(ehrId, new ObjectVersionId(actualPreceding), (Locatable)versionRmObject, contributionId, audit);
                break;
            }
            case DELETED: {
                String actualPreceding2 = this.getAndCheckActualPreceding(version);
                this.compositionService.delete(ehrId, new ObjectVersionId(actualPreceding2), contributionId, audit);
                break;
            }
            default: {
                throw new UnexpectedSwitchCaseException((Enum)changeType);
            }
        }
    }

    private String getAndCheckActualPreceding(Version version) {
        Integer latestVersion = this.compositionService.getLastVersionNumber(this.getVersionedUidFromVersion(version));
        String id = version.getPrecedingVersionUid().toString();
        String actualPreceding = id.substring(0, id.lastIndexOf("::") + 2).concat(latestVersion.toString());
        if (!actualPreceding.equals(version.getPrecedingVersionUid().toString())) {
            throw new PreconditionFailedException("Given preceding_version_uid for COMPOSITION object does not match latest existing version");
        }
        return actualPreceding;
    }

    private void processEhrStatusVersion(UUID ehrId, UUID contributionId, Version version, EhrStatus versionRmObject) {
        I_ConceptAccess.ContributionChangeType changeType = I_ConceptAccess.ContributionChangeType.valueOf(version.getCommitAudit().getChangeType().getValue().toUpperCase());
        this.checkContributionRules(version, changeType);
        UUID audit = this.contributionRepository.createAudit(version.getCommitAudit());
        switch (changeType) {
            case CREATION: {
                throw new InvalidApiParameterException("Invalid change type. EHR_STATUS can't be manually created.");
            }
            case AMENDMENT: 
            case MODIFICATION: {
                String latestVersionUid = this.ehrService.getLatestVersionUidOfStatus(ehrId);
                if (!latestVersionUid.equals(version.getPrecedingVersionUid().toString())) {
                    throw new PreconditionFailedException("Given preceding_version_uid for EHR_STATUS object does not match latest existing version");
                }
                this.ehrService.updateStatus(ehrId, versionRmObject, contributionId, audit);
                break;
            }
            case DELETED: {
                throw new InvalidApiParameterException("Invalid change type. EHR_STATUS can't be deleted.");
            }
            default: {
                throw new UnexpectedSwitchCaseException((Enum)changeType);
            }
        }
    }

    private void processFolderVersion(UUID ehrId, UUID contributionId, Version version, Folder versionRmObject) {
        I_ConceptAccess.ContributionChangeType changeType = I_ConceptAccess.ContributionChangeType.valueOf(version.getCommitAudit().getChangeType().getValue().toUpperCase());
        this.checkContributionRules(version, changeType);
        UUID audit = this.contributionRepository.createAudit(version.getCommitAudit());
        switch (changeType) {
            case CREATION: {
                this.folderService.create(ehrId, versionRmObject, contributionId, audit);
                break;
            }
            case AMENDMENT: 
            case MODIFICATION: {
                this.folderService.update(ehrId, versionRmObject, version.getPrecedingVersionUid(), contributionId, audit);
                break;
            }
            case DELETED: {
                this.folderService.delete(ehrId, version.getPrecedingVersionUid(), contributionId, audit);
                break;
            }
            default: {
                throw new UnexpectedSwitchCaseException((Enum)changeType);
            }
        }
    }

    private void checkContributionRules(Version version, I_ConceptAccess.ContributionChangeType changeType) {
        switch (changeType) {
            case CREATION: {
                if (version.getPrecedingVersionUid() == null) break;
                throw new InvalidApiParameterException("Invalid version. Change type CREATION, but also set \"preceding_version_uid\" attribute");
            }
            case AMENDMENT: 
            case MODIFICATION: {
                if (version.getPrecedingVersionUid() != null) break;
                throw new InvalidApiParameterException("Invalid version. Change type MODIFICATION, but without \"preceding_version_uid\" attribute");
            }
            case DELETED: 
            case SYNTHESIS: 
            case UNKNOWN: {
                break;
            }
            default: {
                throw new InvalidApiParameterException("Change type \"" + changeType + "\" not valid");
            }
        }
    }

    private void processMetadataVersion(UUID ehrId, UUID contributionId, Version version) {
        I_ConceptAccess.ContributionChangeType changeType = I_ConceptAccess.ContributionChangeType.valueOf(version.getCommitAudit().getChangeType().getValue().toUpperCase());
        UUID audit = this.contributionRepository.createAudit(version.getCommitAudit());
        switch (changeType) {
            case DELETED: {
                UUID objectUid = this.getVersionedUidFromVersion(version);
                try {
                    if (this.compositionService.retrieve(ehrId, objectUid, null).isEmpty()) {
                        throw new RuntimeException();
                    }
                    String actualPreceding = this.getAndCheckActualPreceding(version);
                    this.compositionService.delete(ehrId, new ObjectVersionId(actualPreceding), contributionId, audit);
                }
                catch (Exception exception) {}
                break;
            }
            default: {
                throw new UnexpectedSwitchCaseException((Enum)changeType);
            }
        }
    }

    private UUID getVersionedUidFromVersion(Version version) {
        ObjectVersionId precedingVersionUid = version.getPrecedingVersionUid();
        if (precedingVersionUid == null) {
            throw new IllegalArgumentException("Input invalid. Composition can't be modified without pointer to precedingVersionUid in Version container.");
        }
        if (precedingVersionUid.toString().split("::").length != 3) {
            throw new IllegalArgumentException("Input invalid. Given precedingVersionUid is not a versionUid.");
        }
        String versionedUid = precedingVersionUid.toString().split("::")[0];
        return UUID.fromString(versionedUid);
    }

    private Map<String, String> retrieveUuidsOfContributionObjects(UUID ehrId, UUID contribution) {
        HashMap<String, String> objRefs = new HashMap<String, String>();
        Map<ObjectVersionId, I_CompositionAccess> compositions = I_CompositionAccess.retrieveInstancesInContribution(this.getDataAccess(), contribution, this.getServerConfig().getNodename());
        compositions.forEach((k, v) -> objRefs.put(k.getValue(), TYPE_COMPOSITION));
        Map<ObjectVersionId, I_StatusAccess> statuses = I_StatusAccess.retrieveInstanceByContribution(this.getDataAccess(), contribution, this.getServerConfig().getNodename());
        statuses.forEach((k, v) -> objRefs.put(k.getValue(), TYPE_EHRSTATUS));
        HashSet<ObjectVersionId> folders = new HashSet<ObjectVersionId>(this.folderService.findForContribution(ehrId, contribution));
        folders.forEach(f -> objRefs.put(f.toString(), TYPE_FOLDER));
        return objRefs;
    }

    private AuditDetails retrieveAuditDetails(UUID contributionId) {
        UUID auditId = I_ContributionAccess.retrieveInstance(this.getDataAccess(), contributionId).getHasAuditDetails();
        Short sysTenant = this.tenantService.getCurrentSysTenant();
        I_AuditDetailsAccess auditDetailsAccess = new AuditDetailsAccess(this.getDataAccess(), sysTenant).retrieveInstance(this.getDataAccess(), auditId);
        String systemId = auditDetailsAccess.getSystemId().toString();
        PartyProxy committer = new PersistedPartyProxy(this.getDataAccess()).retrieve(auditDetailsAccess.getCommitter());
        DvDateTime timeCommitted = new DvDateTime((TemporalAccessor)LocalDateTime.ofInstant(auditDetailsAccess.getTimeCommitted().toInstant(), ZoneId.of(auditDetailsAccess.getTimeCommittedTzId())));
        int changeTypeCode = I_ConceptAccess.ContributionChangeType.valueOf(auditDetailsAccess.getChangeType().getLiteral().toUpperCase()).getCode();
        DvCodedText changeType = new DvCodedText(auditDetailsAccess.getChangeType().getLiteral(), new CodePhrase(new TerminologyId("audit change type"), String.valueOf(changeTypeCode)));
        DvText description = new DvText(auditDetailsAccess.getDescription());
        return new AuditDetails(systemId, committer, timeCommitted, changeType, description);
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    public void adminDelete(UUID contributionId) {
        I_ContributionAccess contributionAccess = I_ContributionAccess.retrieveInstance(this.getDataAccess(), contributionId);
        contributionAccess.adminDelete();
    }

    public Set<String> getListOfTemplates(String contribution, CompositionFormat format) {
        List<Version> versions = ContributionServiceHelper.parseVersions(contribution, format);
        HashSet<String> templates = new HashSet<String>();
        block5: for (Version version : versions) {
            SupportedClasses versionClass;
            Object versionData = version.getData();
            if (versionData == null) continue;
            if (!(versionData instanceof LinkedHashMap)) {
                throw new IllegalArgumentException("Contribution input can't be processed");
            }
            RMObject versionRmObject = ContributionServiceHelper.unmarshalMapContentToRmObject((LinkedHashMap)versionData, format);
            try {
                versionClass = SupportedClasses.valueOf(versionRmObject.getClass().getSimpleName().toUpperCase());
            }
            catch (Exception e) {
                throw new InvalidApiParameterException("Invalid version object in contribution. " + versionRmObject.getClass().getSimpleName().toUpperCase() + " not supported.");
            }
            switch (versionClass) {
                case COMPOSITION: {
                    TemplateId templateId = ((Composition)versionRmObject).getArchetypeDetails().getTemplateId();
                    if (templateId == null) continue block5;
                    templates.add(templateId.getValue());
                    continue block5;
                }
            }
            throw new IllegalArgumentException("Contribution input contains invalid version class");
        }
        return templates;
    }

    private static /* synthetic */ void lambda$processMetadataVersion$0(Version version, EhrStatus st) {
        if (st.getUid().equals((Object)version.getPrecedingVersionUid())) {
            throw new InvalidApiParameterException("Invalid change type. EHR_STATUS can't be deleted.");
        }
    }

    static enum SupportedClasses {
        COMPOSITION,
        EHRSTATUS,
        FOLDER;

    }
}

