/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.sql.queryimpl;

import java.util.ArrayList;
import java.util.List;
import org.ehrbase.jooq.pg.Tables;

public class JsonbFunctionCall {
    private final List<String> resolvedPath;
    private final String marker;
    private final String function;
    private String rightJsonbExpressionPart;

    public JsonbFunctionCall(List<String> itemPathArray, String marker, String function) {
        this.function = function;
        this.marker = marker;
        List<String> p = itemPathArray;
        while (p.contains(marker)) {
            p = this.resolveIterativeCall(p);
        }
        this.resolvedPath = p;
    }

    public List<String> resolve() {
        return this.resolvedPath;
    }

    private List<String> resolveIterativeCall(List<String> itemPathArray) {
        int startPos;
        StringBuilder expression = new StringBuilder();
        int markerPos = itemPathArray.indexOf(this.marker);
        expression.append("(");
        expression.append(this.function);
        expression.append("(");
        if (!itemPathArray.get(0).contains(this.function)) {
            expression.append("(");
            expression.append(Tables.ENTRY.ENTRY_);
            startPos = 0;
        } else {
            expression.append(itemPathArray.get(0));
            startPos = 1;
        }
        expression.append("#>>");
        expression.append("'{");
        expression.append(String.join((CharSequence)",", itemPathArray.subList(startPos, markerPos)));
        expression.append("}'");
        expression.append(")");
        expression.append("::jsonb");
        expression.append(")");
        ArrayList<String> resultList = new ArrayList<String>();
        List<String> rightList = itemPathArray.subList(markerPos + 1, itemPathArray.size());
        if (rightList.contains(this.marker)) {
            resultList.add(expression.toString());
            resultList.addAll(rightList);
        } else {
            this.rightJsonbExpressionPart = this.rightJsonExpression(rightList);
            expression.append(")");
            resultList.add(expression.toString());
        }
        return resultList;
    }

    private String rightJsonExpression(List<String> pathItems) {
        if (pathItems.isEmpty()) {
            return "";
        }
        StringBuilder expression = new StringBuilder();
        expression.append("#>>");
        expression.append("'");
        expression.append("{");
        expression.append(String.join((CharSequence)",", pathItems));
        expression.append("}");
        expression.append("'");
        return expression.toString();
    }

    public boolean hasRightMostJsonbExpression() {
        return this.rightJsonbExpressionPart != null;
    }

    public String getRightMostJsonbExpression() {
        return this.rightJsonbExpressionPart;
    }
}

