/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.dao.access.jooq;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.dao.access.interfaces.I_DomainAccess;
import org.ehrbase.dao.access.interfaces.I_StoredQueryAccess;
import org.ehrbase.dao.access.support.DataAccess;
import org.ehrbase.dao.access.util.SemVer;
import org.ehrbase.dao.access.util.StoredQueryQualifiedName;
import org.ehrbase.jooq.pg.Tables;
import org.ehrbase.jooq.pg.tables.records.StoredQueryRecord;
import org.joda.time.DateTime;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.LikeEscapeStep;
import org.jooq.OrderField;
import org.jooq.SelectConditionStep;
import org.jooq.SelectSeekStepN;
import org.jooq.SelectWhereStep;
import org.jooq.SortField;
import org.jooq.SortOrder;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;

public class StoredQueryAccess
extends DataAccess
implements I_StoredQueryAccess {
    static final Logger log = LoggerFactory.getLogger(StoredQueryAccess.class);
    private StoredQueryRecord storedQueryRecord;

    public StoredQueryAccess(I_DomainAccess domainAccess, StoredQueryRecord queryRecord, Short sysTenant) {
        super(domainAccess);
        this.storedQueryRecord = queryRecord;
        this.storedQueryRecord.setSysTenant(sysTenant);
    }

    public StoredQueryAccess(I_DomainAccess domainAccess, String qualifiedQueryName, SemVer version, String sourceAqlText, Short sysTenant) {
        super(domainAccess);
        this.storedQueryRecord = (StoredQueryRecord)domainAccess.getContext().newRecord((Table)Tables.STORED_QUERY);
        this.storedQueryRecord.setSysTenant(sysTenant);
        StoredQueryQualifiedName qn = new StoredQueryQualifiedName(qualifiedQueryName, version);
        this.storedQueryRecord.setReverseDomainName(qn.reverseDomainName());
        this.storedQueryRecord.setSemanticId(qn.semanticId());
        this.storedQueryRecord.setSemver(version.toVersionString());
        this.storedQueryRecord.setQueryText(sourceAqlText);
        this.storedQueryRecord.setType("AQL");
    }

    public static Optional<StoredQueryAccess> retrieveQualified(I_DomainAccess domainAccess, String qualifiedName, @NonNull SemVer version) {
        Optional queryRecord;
        StoredQueryQualifiedName qn = new StoredQueryQualifiedName(qualifiedName, version);
        SemVer semVer = qn.semVer();
        Condition condition = StoredQueryAccess.nameConstraint(qn);
        condition = condition.and(StoredQueryAccess.versionConstraint(semVer));
        SelectConditionStep unordered = domainAccess.getContext().selectFrom((TableLike)Tables.STORED_QUERY).where(condition);
        if (semVer.isRelease() || semVer.isPreRelease()) {
            queryRecord = unordered.fetchOptional();
        } else {
            SelectSeekStepN ordered = unordered.orderBy(StoredQueryAccess.orderBySemVerStream(SortOrder.DESC).toList());
            queryRecord = ordered.limit((Number)1).fetchOptional();
        }
        return queryRecord.map(r -> new StoredQueryAccess(domainAccess, (StoredQueryRecord)r, r.getSysTenant()));
    }

    @NonNull
    private static Condition versionConstraint(SemVer semVer) {
        if (semVer.isRelease() || semVer.isPreRelease()) {
            return Tables.STORED_QUERY.SEMVER.eq((Object)semVer.toVersionString());
        }
        Condition noPreRelease = Tables.STORED_QUERY.SEMVER.notContains((Object)"-");
        if (semVer.isNoVersion()) {
            return noPreRelease;
        }
        LikeEscapeStep prefixMatch = Tables.STORED_QUERY.SEMVER.like(semVer.toVersionString() + ".%");
        return prefixMatch.and(noPreRelease);
    }

    private static Condition nameConstraint(StoredQueryQualifiedName storedQueryQualifiedName) {
        return Tables.STORED_QUERY.REVERSE_DOMAIN_NAME.eq((Object)storedQueryQualifiedName.reverseDomainName()).and(Tables.STORED_QUERY.SEMANTIC_ID.eq((Object)storedQueryQualifiedName.semanticId()));
    }

    public static List<StoredQueryAccess> retrieveQualifiedList(I_DomainAccess domainAccess, String qualifiedQueryName) {
        String reverseDomainName;
        String semanticId;
        SelectWhereStep selection = domainAccess.getContext().selectFrom((TableLike)Tables.STORED_QUERY);
        if (StringUtils.isEmpty((CharSequence)qualifiedQueryName)) {
            semanticId = null;
            reverseDomainName = null;
        } else {
            int pos = qualifiedQueryName.indexOf("::");
            if (pos < 0) {
                reverseDomainName = null;
                semanticId = qualifiedQueryName;
            } else {
                reverseDomainName = (String)StringUtils.defaultIfEmpty((CharSequence)qualifiedQueryName.substring(0, pos), null);
                semanticId = (String)StringUtils.defaultIfEmpty((CharSequence)qualifiedQueryName.substring(pos + 2), null);
            }
        }
        ArrayList<Condition> constraints = new ArrayList<Condition>();
        ArrayList<SortField> orderFields = new ArrayList<SortField>();
        if (reverseDomainName == null) {
            orderFields.add(Tables.STORED_QUERY.REVERSE_DOMAIN_NAME.sort(SortOrder.ASC));
        } else {
            constraints.add(Tables.STORED_QUERY.REVERSE_DOMAIN_NAME.eq((Object)reverseDomainName));
        }
        if (semanticId == null) {
            orderFields.add(Tables.STORED_QUERY.SEMANTIC_ID.sort(SortOrder.ASC));
        } else {
            constraints.add(Tables.STORED_QUERY.SEMANTIC_ID.eq((Object)semanticId));
        }
        Object unordered = constraints.isEmpty() ? selection : selection.where(constraints);
        List<OrderField<?>> sortOrder = Stream.concat(orderFields.stream(), StoredQueryAccess.orderBySemVerStream(SortOrder.DESC)).toList();
        try (Stream stream = unordered.orderBy(sortOrder).stream();){
            List<StoredQueryAccess> list = stream.map(r -> new StoredQueryAccess(domainAccess, (StoredQueryRecord)r, r.getSysTenant())).toList();
            return list;
        }
    }

    private static Stream<OrderField<?>> orderBySemVerStream(SortOrder sortOrder) {
        return Stream.of(DSL.splitPart((Field)Tables.STORED_QUERY.SEMVER, (String)".", (Number)1).cast(Integer.class).sort(sortOrder), DSL.splitPart((Field)Tables.STORED_QUERY.SEMVER, (String)".", (Number)2).cast(Integer.class).sort(sortOrder), DSL.splitPart((Field)DSL.splitPart((Field)Tables.STORED_QUERY.SEMVER, (String)".", (Number)3), (String)"-", (Number)1).cast(Integer.class).sort(sortOrder), DSL.splitPart((Field)DSL.splitPart((Field)Tables.STORED_QUERY.SEMVER, (String)".", (Number)3), (String)"-", (Number)2).sort(sortOrder));
    }

    @Override
    public StoredQueryAccess commit(Timestamp transactionTime) {
        this.storedQueryRecord.setCreationDate(transactionTime);
        this.storedQueryRecord.store();
        return this;
    }

    @Override
    public StoredQueryAccess commit() {
        return this.commit(new Timestamp(DateTime.now().getMillis()));
    }

    @Override
    public Boolean update(Timestamp transactionTime) {
        this.storedQueryRecord.setCreationDate(transactionTime);
        if (this.storedQueryRecord.changed()) {
            return this.storedQueryRecord.update() > 0;
        }
        return false;
    }

    @Override
    public Boolean update(Timestamp transactionTime, boolean force) {
        return this.update(transactionTime);
    }

    @Override
    public Integer delete() {
        return this.storedQueryRecord.delete();
    }

    @Override
    public String getReverseDomainName() {
        return this.storedQueryRecord.getReverseDomainName();
    }

    @Override
    public String getSemanticId() {
        return this.storedQueryRecord.getSemanticId();
    }

    @Override
    public String getSemver() {
        return this.storedQueryRecord.getSemver();
    }

    @Override
    public String getQueryText() {
        return this.storedQueryRecord.getQueryText();
    }

    @Override
    public void setQueryText(String queryText) {
        this.storedQueryRecord.setQueryText(queryText);
    }

    @Override
    public Timestamp getCreationDate() {
        return this.storedQueryRecord.getCreationDate();
    }

    @Override
    public String getQueryType() {
        return this.storedQueryRecord.getType();
    }

    @Override
    public DataAccess getDataAccess() {
        return this;
    }
}

