/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.dao.access.support;

import java.util.function.BiFunction;
import java.util.function.Function;

public class SafeNav<T> {
    private final T obj;

    public static <T1> SafeNav<T1> of(T1 obj) {
        return new SafeNav<T1>(obj);
    }

    private SafeNav(T obj) {
        this.obj = obj;
    }

    public <T1> SafeNav<T1> get(Function<T, T1> accessor) {
        if (this.obj == null) {
            return new SafeNav<Object>(null);
        }
        try {
            return new SafeNav<T1>(accessor.apply(this.obj));
        }
        catch (NullPointerException e) {
            return new SafeNav<Object>(null);
        }
    }

    public T get() {
        return this.obj;
    }

    public boolean isSafe() {
        return this.obj != null;
    }

    public <T1> CombineSafeNav<T1> use(SafeNav<T1> s) {
        return new CombineSafeNav<T1>(s);
    }

    public class CombineSafeNav<T1> {
        private final SafeNav<T1> safe;

        private CombineSafeNav(SafeNav<T1> safe) {
            this.safe = safe;
        }

        public SafeNav<T> get(BiFunction<T1, T, T> accessor) {
            if (!SafeNav.this.isSafe()) {
                return null;
            }
            try {
                return SafeNav.of(accessor.apply(this.safe.get(), SafeNav.this.obj));
            }
            catch (NullPointerException e) {
                return new SafeNav<Object>(null);
            }
        }
    }
}

