/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase;

import java.util.List;
import org.ehrbase.api.tenant.TenantIdExtractionStrategy;
import org.ehrbase.tenant.DefaultTenantAspect;
import org.ehrbase.tenant.extraction.AuthenticatedExtractionStrategy;
import org.ehrbase.tenant.extraction.DefaultExtractionStrategy;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;

@Configuration
@ComponentScan(basePackages={"org.ehrbase.service", "org.ehrbase.plugin", "org.ehrbase.repository"})
@EnableAspectJAutoProxy
public class ServiceModuleConfiguration {
    @Bean
    public DefaultTenantAspect tenantAspect(List<TenantIdExtractionStrategy<?>> strategies) {
        return new DefaultTenantAspect(strategies);
    }

    @Bean
    public TenantIdExtractionStrategy<String> defaultStrategy() {
        return new DefaultExtractionStrategy();
    }

    @Bean
    public TenantIdExtractionStrategy<String> tokenAuthenticatedExtractionStrategy() {
        return new AuthenticatedExtractionStrategy.TokenAuthenticatedExtractionStrategy();
    }

    @Bean
    public TenantIdExtractionStrategy<String> authenticationExtractionStrategy() {
        return new AuthenticatedExtractionStrategy.AuthenticationExtractionStrategy();
    }
}

