/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.compiler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.RuleNode;
import org.antlr.v4.runtime.tree.TerminalNodeImpl;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.aql.compiler.WhereClauseUtil;
import org.ehrbase.aql.definition.VariableDefinition;
import org.ehrbase.aql.parser.AqlBaseVisitor;
import org.ehrbase.aql.parser.AqlParser;
import org.ehrbase.openehr.sdk.util.functional.Try;
import org.ehrbase.openehr.sdk.validation.terminology.ExternalTerminologyValidation;
import org.ehrbase.openehr.sdk.validation.terminology.TerminologyParam;

public class WhereVisitor
extends AqlBaseVisitor<List<Object>> {
    private static final String MATCHES = "MATCHES";
    public static final String IN = " IN ";
    private static final String OPEN_CURL = "{";
    private static final String OPEN_PAR = "(";
    private static final String CLOSING_CURL = "}";
    private static final String CLOSING_PAR = ")";
    private static final String COMMA = ",";
    private List<Object> whereExpression = new ArrayList<Object>();
    private ExternalTerminologyValidation tsAdapter;

    public WhereVisitor(ExternalTerminologyValidation tsAdapter) {
        this.tsAdapter = tsAdapter;
    }

    @Override
    public List<Object> visitWhere(AqlParser.WhereContext ctx) {
        this.visitIdentifiedExpr(ctx.identifiedExpr());
        return this.whereExpression;
    }

    @Override
    public List<Object> visitIdentifiedExpr(AqlParser.IdentifiedExprContext context) {
        for (ParseTree tree : context.children) {
            if (tree instanceof TerminalNodeImpl) {
                String what = tree.getText().trim();
                this.whereExpression.add(what);
                continue;
            }
            if (!(tree instanceof AqlParser.IdentifiedEqualityContext)) continue;
            this.visitIdentifiedEquality((AqlParser.IdentifiedEqualityContext)tree);
        }
        return this.whereExpression;
    }

    @Override
    public List<Object> visitMatchesOperand(AqlParser.MatchesOperandContext context) {
        for (ParseTree tree : context.children) {
            if (tree instanceof AqlParser.ValueListItemsContext) {
                this.whereExpression.addAll((Collection<Object>)this.visitValueListItems((AqlParser.ValueListItemsContext)tree));
                continue;
            }
            if (tree instanceof AqlParser.IdentifiedEqualityContext) {
                this.visitIdentifiedEquality((AqlParser.IdentifiedEqualityContext)tree);
                continue;
            }
            if (!(tree instanceof AqlParser.IdentifiedPathContext)) continue;
            this.parsePathContext((AqlParser.IdentifiedPathContext)tree);
        }
        return this.whereExpression;
    }

    private void parsePathContext(AqlParser.IdentifiedPathContext identifiedPathContext) {
        if (identifiedPathContext.objectPath() == null) {
            throw new IllegalArgumentException("WHERE variable should be a path, found:'" + identifiedPathContext.getText() + "'");
        }
        String path = identifiedPathContext.objectPath().getText();
        String identifier = identifiedPathContext.IDENTIFIER().getText();
        String alias = null;
        VariableDefinition variable = new VariableDefinition(path, alias, identifier, false);
        this.whereExpression.add(variable);
    }

    @Override
    public List<Object> visitValueListItems(AqlParser.ValueListItemsContext ctx) {
        ArrayList<Object> operand = new ArrayList<Object>();
        int counter = 0;
        for (ParseTree tree : ctx.children) {
            if (tree instanceof AqlParser.OperandContext) {
                AqlParser.OperandContext operandContext = (AqlParser.OperandContext)tree;
                if (operandContext.STRING() != null) {
                    operand.add(operandContext.STRING().getText());
                } else if (operandContext.BOOLEAN() != null) {
                    operand.add(operandContext.BOOLEAN().getText());
                } else if (operandContext.INTEGER() != null) {
                    operand.add(operandContext.INTEGER().getText());
                } else if (operandContext.DATE() != null) {
                    operand.add(operandContext.DATE().getText());
                } else if (operandContext.FLOAT() != null) {
                    operand.add(operandContext.FLOAT().getText());
                } else if (operandContext.invokeOperand() != null) {
                    Iterator iterator = this.visitInvokeOperand(operandContext.invokeOperand()).iterator();
                    while (iterator.hasNext()) {
                        Object obj = iterator.next();
                        operand.add(obj);
                        operand.add(COMMA);
                    }
                    operand.remove(operand.size() - 1);
                } else if (operandContext.PARAMETER() != null) {
                    operand.add("** unsupported operand: PARAMETER **");
                } else {
                    operand.add("** unsupported operand: " + operandContext.getText());
                }
                if (++counter >= ctx.children.size()) continue;
                operand.add(COMMA);
                continue;
            }
            if (!(tree instanceof AqlParser.ValueListItemsContext)) continue;
            Object token = this.visitValueListItems((AqlParser.ValueListItemsContext)tree);
            operand.addAll((Collection<Object>)token);
        }
        return operand;
    }

    @Override
    public List<Object> visitInvokeOperand(AqlParser.InvokeOperandContext ctx) {
        return (List)this.visitChildren((RuleNode)ctx);
    }

    @Override
    public List<Object> visitInvokeExpr(AqlParser.InvokeExprContext ctx) {
        ArrayList<Object> invokeExpr = new ArrayList<Object>();
        assert (ctx.TERMINOLOGY().getText().equals("TERMINOLOGY"));
        assert (ctx.OPEN_PAR().getText().equals(OPEN_PAR));
        assert (ctx.CLOSE_PAR().getText().equals(CLOSING_PAR));
        ArrayList codesList = new ArrayList();
        String operation = ctx.STRING(0).getText().replace("'", "");
        String adapter = ctx.STRING(1).getText().replace("'", "");
        String parameters = ctx.STRING(2).getText().replace("'", "");
        TerminologyParam tp = TerminologyParam.ofServiceApi((String)adapter);
        tp.setOperation(operation);
        tp.setParameter(parameters);
        if (StringUtils.equals((CharSequence)operation, (CharSequence)"expand")) {
            try {
                tp.useValueSet();
                List expansion = this.tsAdapter.expand(tp);
                expansion.forEach(dvCode -> codesList.add("'" + dvCode.getDefiningCode().getCodeString() + "'"));
                invokeExpr.addAll(codesList);
            }
            catch (Exception e2) {
                throw new IllegalArgumentException("Terminology server operation failed:'" + e2.getMessage() + "'");
            }
        }
        if (StringUtils.equals((CharSequence)operation, (CharSequence)"validate")) {
            try {
                Try expansion = this.tsAdapter.validate(tp);
                if (expansion.isSuccess()) {
                    expansion.getAsSuccess().consume((b, e) -> invokeExpr.add(b));
                } else {
                    expansion.getAsFailure().consume((b, e) -> invokeExpr.add(Boolean.FALSE));
                }
            }
            catch (Exception e3) {
                throw new IllegalArgumentException("Terminology server operation failed:'" + e3.getMessage() + "'");
            }
        }
        return invokeExpr;
    }

    @Override
    public List<Object> visitIdentifiedEquality(AqlParser.IdentifiedEqualityContext context) {
        boolean isMatchExpr = false;
        for (ParseTree tree : context.children) {
            if (tree instanceof TerminalNodeImpl) {
                String token = ((TerminalNodeImpl)tree).getSymbol().getText();
                if (token.equalsIgnoreCase(MATCHES)) {
                    isMatchExpr = true;
                    this.whereExpression.add(IN);
                    continue;
                }
                if (token.equals(OPEN_CURL) && isMatchExpr) {
                    this.whereExpression.add(OPEN_PAR);
                    continue;
                }
                if (token.equals(CLOSING_CURL) && isMatchExpr) {
                    if (this.whereExpression.get(this.whereExpression.size() - 1).equals(COMMA)) {
                        this.whereExpression.set(this.whereExpression.size() - 1, CLOSING_PAR);
                    } else {
                        this.whereExpression.add(CLOSING_PAR);
                    }
                    isMatchExpr = false;
                    continue;
                }
                this.whereExpression.add(token);
                continue;
            }
            if (tree instanceof AqlParser.IdentifiedOperandContext) {
                AqlParser.IdentifiedOperandContext operandContext = (AqlParser.IdentifiedOperandContext)tree;
                for (ParseTree child : operandContext.children) {
                    if (child instanceof AqlParser.OperandContext || child instanceof TerminalNodeImpl) {
                        this.whereExpression.add(child.getText());
                        continue;
                    }
                    if (!(child instanceof AqlParser.IdentifiedPathContext)) continue;
                    AqlParser.IdentifiedPathContext identifiedPathContext = (AqlParser.IdentifiedPathContext)child;
                    this.parsePathContext(identifiedPathContext);
                }
                continue;
            }
            if (tree instanceof AqlParser.IdentifiedEqualityContext) {
                this.visitIdentifiedEquality((AqlParser.IdentifiedEqualityContext)tree);
                continue;
            }
            if (tree instanceof AqlParser.MatchesOperandContext) {
                this.visitMatchesOperand((AqlParser.MatchesOperandContext)tree);
                continue;
            }
            if (tree instanceof AqlParser.IdentifiedPathContext) {
                this.parsePathContext((AqlParser.IdentifiedPathContext)tree);
                continue;
            }
            if (!(tree instanceof AqlParser.IdentifiedExprContext)) continue;
            this.visitIdentifiedExpr((AqlParser.IdentifiedExprContext)tree);
        }
        return this.whereExpression;
    }

    List<Object> getWhereExpression() {
        WhereClauseUtil whereClauseUtil = new WhereClauseUtil(this.whereExpression);
        if (!whereClauseUtil.isBalancedBlocks()) {
            throw new IllegalArgumentException("Unbalanced block in WHERE clause missing:'" + whereClauseUtil.getUnbalanced() + "'");
        }
        return this.whereExpression;
    }
}

