/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.definition;

import java.util.ArrayList;
import java.util.List;
import org.ehrbase.aql.definition.I_FromEntityDefinition;

public class FromForeignDataDefinition
implements I_FromEntityDefinition {
    private final List<NodePredicate> fromNodePredicates = new ArrayList<NodePredicate>();
    private String identifier;
    private final FDType fdType;

    public FromForeignDataDefinition(String type) {
        this.fdType = FDType.valueOf(type);
    }

    @Override
    public void add(String identifier, String value, String operator) {
        this.fromNodePredicates.add(new NodePredicate(identifier, value, operator));
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public FDType getFdType() {
        return this.fdType;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (NodePredicate predicate : this.fromNodePredicates) {
            builder.append(predicate).append(" ");
        }
        return builder.toString();
    }

    public List<NodePredicate> getFDPredicates() {
        return this.fromNodePredicates;
    }

    public static enum FDType {
        PERSON,
        AGENT,
        ORGANISATION,
        GROUP;

    }

    public static class NodePredicate {
        String field;
        String value;
        String identifier;
        String operator;

        public NodePredicate(String field, String value, String operator) {
            this.field = field;
            this.value = value;
            this.operator = operator;
        }

        public NodePredicate(String identifier) {
            this.identifier = identifier;
        }

        public void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public String getField() {
            return this.field;
        }

        public String getValue() {
            return this.value;
        }

        public String getOperator() {
            return this.operator;
        }

        public String toString() {
            return "ForeignData::" + this.getIdentifier() + "::" + this.getIdentifier() + "::" + this.getValue();
        }
    }
}

