/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.definition;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ehrbase.aql.definition.FuncParameter;
import org.ehrbase.aql.definition.I_VariableDefinition;
import org.ehrbase.aql.definition.LateralJoinDefinition;
import org.ehrbase.aql.definition.PredicateDefinition;
import org.jooq.DataType;

public class VariableDefinition
implements I_VariableDefinition {
    private String path;
    private String alias;
    private boolean isVoidAlias = true;
    private String identifier;
    private String substituteFieldVariable;
    private boolean isDistinct;
    private boolean isHidden;
    private Map<String, Set<LateralJoinDefinition>> lateralJoinDefinitions = new HashMap<String, Set<LateralJoinDefinition>>();
    private PredicateDefinition predicateDefinition;
    private DataType selectDataType;

    public VariableDefinition(String path, String alias, String identifier, boolean isDistinct) {
        this.path = path;
        this.alias = alias;
        this.identifier = identifier;
        this.isDistinct = isDistinct;
        this.isHidden = false;
    }

    public VariableDefinition(String path, String alias, String identifier, boolean isDistinct, PredicateDefinition predicateDefinition) {
        this.path = path;
        this.alias = alias;
        this.identifier = identifier;
        this.isDistinct = isDistinct;
        this.isHidden = false;
        this.predicateDefinition = predicateDefinition;
    }

    public VariableDefinition(String path, String alias, String identifier, boolean isDistinct, boolean isHidden) {
        this.path = path;
        this.alias = alias;
        this.identifier = identifier;
        this.isDistinct = isDistinct;
        this.isHidden = isHidden;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public String toString() {
        return this.identifier + "::" + this.path;
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public boolean isLateralJoin(String templateId) {
        return !this.lateralJoinDefinitions.isEmpty() && this.lateralJoinDefinitions.get(templateId) != null;
    }

    @Override
    public Set<LateralJoinDefinition> getLateralJoinDefinitions(String templateId) {
        return this.lateralJoinDefinitions.get(templateId);
    }

    @Override
    public LateralJoinDefinition getLateralJoinDefinition(String templateId, int index) {
        Set<LateralJoinDefinition> definitions = this.getLateralJoinDefinitions(templateId);
        if (index > definitions.size() - 1) {
            return null;
        }
        return definitions.toArray(new LateralJoinDefinition[0])[index];
    }

    @Override
    public int getLateralJoinsSize(String templateId) {
        if (this.isLateralJoinsEmpty(templateId)) {
            return 0;
        }
        return this.lateralJoinDefinitions.get(templateId).size();
    }

    @Override
    public boolean isLateralJoinsEmpty(String templateId) {
        return this.lateralJoinDefinitions.isEmpty() || this.lateralJoinDefinitions.get(templateId) == null || this.lateralJoinDefinitions.get(templateId).isEmpty();
    }

    @Override
    public LateralJoinDefinition getLastLateralJoin(String templateId) {
        if (this.isLateralJoinsEmpty(templateId)) {
            return null;
        }
        return Arrays.asList(this.lateralJoinDefinitions.get(templateId).toArray(new LateralJoinDefinition[0])).get(this.getLateralJoinsSize(templateId) - 1);
    }

    @Override
    public void setLateralJoinTable(String templateId, LateralJoinDefinition lateralJoinDefinition) {
        this.lateralJoinDefinitions.computeIfAbsent(templateId, k -> new HashSet());
        this.lateralJoinDefinitions.get(templateId).add(lateralJoinDefinition);
    }

    @Override
    public boolean isDistinct() {
        return this.isDistinct;
    }

    @Override
    public boolean isFunction() {
        return false;
    }

    @Override
    public boolean isExtension() {
        return false;
    }

    @Override
    public boolean isHidden() {
        return this.isHidden;
    }

    @Override
    public List<FuncParameter> getFuncParameters() {
        return new ArrayList<FuncParameter>();
    }

    @Override
    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public void setDistinct(boolean distinct) {
        this.isDistinct = distinct;
    }

    @Override
    public void setHidden(boolean hidden) {
        this.isHidden = hidden;
    }

    @Override
    public I_VariableDefinition duplicate() {
        return new VariableDefinition(this.path, this.alias, this.identifier, this.isDistinct, this.isHidden);
    }

    @Override
    public void setAlias(String alias) {
        this.alias = alias;
    }

    @Override
    public PredicateDefinition getPredicateDefinition() {
        return this.predicateDefinition;
    }

    @Override
    public String getSubstituteFieldVariable() {
        return this.substituteFieldVariable;
    }

    @Override
    public void setSubstituteFieldVariable(String substituteFieldVariable) {
        this.substituteFieldVariable = substituteFieldVariable;
    }

    @Override
    public void setSelectType(DataType sqlDataType) {
        this.selectDataType = sqlDataType;
    }

    @Override
    public DataType getSelectType() {
        return this.selectDataType;
    }

    @Override
    public boolean isVoidAlias() {
        return this.isVoidAlias;
    }

    @Override
    public void setVoidAlias(boolean isVoidAlias) {
        this.isVoidAlias = isVoidAlias;
    }
}

