/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.sql;

import java.util.List;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.aql.definition.LateralJoinDefinition;
import org.jooq.Condition;
import org.jooq.SelectQuery;

public class QuerySteps {
    private final SelectQuery selectQuery;
    private Condition whereCondition;
    private final List<LateralJoinDefinition> lateralJoins;
    private final String templateId;

    public QuerySteps(SelectQuery selectQuery, Condition whereCondition, List<LateralJoinDefinition> lateralJoins, String templateId) {
        this.selectQuery = selectQuery;
        this.whereCondition = whereCondition;
        this.lateralJoins = lateralJoins;
        this.templateId = templateId;
    }

    public SelectQuery getSelectQuery() {
        return this.selectQuery;
    }

    public Condition getWhereCondition() {
        return this.whereCondition;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public List<LateralJoinDefinition> getLateralJoins() {
        return this.lateralJoins;
    }

    public void setWhereCondition(Condition whereCondition) {
        this.whereCondition = whereCondition;
    }

    public static boolean compare(QuerySteps querySteps1, QuerySteps querySteps2) {
        if (!querySteps1.getTemplateId().equals(querySteps2.getTemplateId())) {
            return false;
        }
        if (!querySteps1.getSelectQuery().getSQL().equals(querySteps2.getSelectQuery().getSQL())) {
            return false;
        }
        if (querySteps1.getLateralJoins().size() != querySteps2.getLateralJoins().size()) {
            return false;
        }
        boolean isEquals = IntStream.range(0, querySteps1.getLateralJoins().size()).allMatch(j -> querySteps1.getLateralJoins().get(j).getSqlExpression().equals(querySteps2.getLateralJoins().get(j).getSqlExpression()));
        if (!isEquals) {
            return false;
        }
        return StringUtils.equals((CharSequence)(querySteps1.getWhereCondition() == null ? null : querySteps1.getWhereCondition().toString()), querySteps2.getWhereCondition() == null ? null : querySteps2.getWhereCondition().toString());
    }

    public static boolean isIncludedInList(QuerySteps querySteps, List<QuerySteps> queryStepsList) {
        for (QuerySteps queryStepsToCompare : queryStepsList) {
            if (!QuerySteps.compare(querySteps, queryStepsToCompare)) continue;
            return true;
        }
        return false;
    }
}

