/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.sql.binding;

import java.util.Iterator;
import org.ehrbase.aql.definition.I_VariableDefinition;
import org.ehrbase.aql.sql.binding.CompositionAttribute;
import org.ehrbase.aql.sql.queryimpl.CompositionAttributeQuery;
import org.ehrbase.aql.sql.queryimpl.IQueryImpl;
import org.ehrbase.aql.sql.queryimpl.JsonbEntryQuery;
import org.ehrbase.aql.sql.queryimpl.MultiFields;
import org.ehrbase.aql.sql.queryimpl.QualifiedAqlField;
import org.ehrbase.aql.sql.queryimpl.UnknownVariableException;

public class ContextualAttribute {
    private final CompositionAttributeQuery compositionAttributeQuery;
    private final JsonbEntryQuery jsonbEntryQuery;
    private final IQueryImpl.Clause clause;

    public ContextualAttribute(CompositionAttributeQuery compositionAttributeQuery, JsonbEntryQuery jsonbEntryQuery, IQueryImpl.Clause clause) {
        this.compositionAttributeQuery = compositionAttributeQuery;
        this.jsonbEntryQuery = jsonbEntryQuery;
        this.clause = clause;
    }

    public MultiFields toSql(String templateId, I_VariableDefinition variableDefinition) throws UnknownVariableException {
        String inTemplatePath = this.compositionAttributeQuery.variableTemplatePath(templateId, variableDefinition.getIdentifier());
        if (inTemplatePath.startsWith("/")) {
            inTemplatePath = inTemplatePath.substring(1);
        }
        String originalPath = variableDefinition.getPath();
        variableDefinition.setPath(inTemplatePath + (String)(variableDefinition.getPath() == null ? "" : "/" + variableDefinition.getPath()));
        CompositionAttribute compositionAttribute = new CompositionAttribute(this.compositionAttributeQuery, this.jsonbEntryQuery, this.clause);
        MultiFields fields = compositionAttribute.toSql(variableDefinition, templateId, variableDefinition.getIdentifier());
        if (this.clause.equals((Object)IQueryImpl.Clause.SELECT)) {
            Iterator<QualifiedAqlField> qualifiedAqlFieldIterator = fields.iterator();
            while (qualifiedAqlFieldIterator.hasNext()) {
                QualifiedAqlField field = qualifiedAqlFieldIterator.next();
                variableDefinition.setPath(originalPath);
                if (originalPath != null) {
                    if (variableDefinition.getAlias() != null) {
                        field.setField(field.getSQLField().as(variableDefinition.getAlias()));
                        continue;
                    }
                    field.setField(field.getSQLField().as("/" + originalPath));
                    continue;
                }
                field.setField(field.getSQLField().as(variableDefinition.getIdentifier()));
            }
        }
        return fields;
    }
}

