/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.sql.queryimpl;

import java.util.Collection;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplate;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplateInput;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplateNode;

public final class WebTemplateAqlPath {
    private static final String TERMINAL_NODE_PATH_PART = "]/";

    private WebTemplateAqlPath() {
    }

    public static boolean isValid(WebTemplate webTemplate, String containerPart, String variablePart) {
        if (containerPart.contains("other_participations")) {
            return true;
        }
        Pair<String, String> nodeAttributrePair = WebTemplateAqlPath.identifyPathParts(variablePart);
        String nodePart = (String)nodeAttributrePair.getLeft();
        String attributePart = (String)nodeAttributrePair.getRight();
        String pathToCheck = containerPart + nodePart;
        if (pathToCheck.contains("other_context") || pathToCheck.contains("other_details")) {
            return true;
        }
        Optional webTemplateNode = webTemplate.findByAqlPath(pathToCheck);
        if (webTemplateNode.isEmpty() && !WebTemplateAqlPath.isMissingAttributeFromWebTemplate(webTemplate, pathToCheck)) {
            return false;
        }
        if (attributePart == null || !attributePart.startsWith("value")) {
            return true;
        }
        String[] attributePartBits = attributePart.split("value/");
        if (attributePartBits.length == 1) {
            return true;
        }
        return webTemplateNode.stream().map(WebTemplateNode::getInputs).flatMap(Collection::stream).map(WebTemplateInput::getSuffix).anyMatch(attributePartBits[1]::equals);
    }

    private static Pair<String, String> identifyPathParts(String path) {
        Object nodePart;
        String attributePart;
        if (StringUtils.isEmpty((CharSequence)path)) {
            attributePart = null;
            nodePart = "";
        } else if (path.startsWith("content")) {
            attributePart = "";
            nodePart = "";
        } else if (path.contains(TERMINAL_NODE_PATH_PART)) {
            int lastNodeSegmentIndex = path.lastIndexOf(TERMINAL_NODE_PATH_PART);
            attributePart = path.substring(lastNodeSegmentIndex + 2).split("/")[0];
            nodePart = "/" + path.substring(0, lastNodeSegmentIndex + 1) + "/" + attributePart;
        } else if (path.contains("/")) {
            attributePart = path.split("/")[0];
            nodePart = attributePart.isEmpty() ? "" : "/" + attributePart;
        } else {
            attributePart = "";
            nodePart = "";
        }
        return Pair.of((Object)nodePart, (Object)attributePart);
    }

    private static boolean isMissingAttributeFromWebTemplate(WebTemplate webTemplate, String pathToCheck) {
        if (pathToCheck.lastIndexOf(TERMINAL_NODE_PATH_PART) <= 0) {
            return false;
        }
        int lastNodeSegmentIndex = pathToCheck.lastIndexOf(TERMINAL_NODE_PATH_PART);
        return webTemplate.findByAqlPath(pathToCheck.substring(0, lastNodeSegmentIndex + 1)).filter(n -> n.getRmType().equals("ELEMENT")).isPresent();
    }
}

