/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.sql.queryimpl.attribute.ehr;

import java.util.Optional;
import java.util.UUID;
import org.ehrbase.aql.sql.binding.JoinBinder;
import org.ehrbase.aql.sql.queryimpl.AqlRoutines;
import org.ehrbase.aql.sql.queryimpl.IQueryImpl;
import org.ehrbase.aql.sql.queryimpl.attribute.FieldResolutionContext;
import org.ehrbase.aql.sql.queryimpl.attribute.GenericJsonPath;
import org.ehrbase.aql.sql.queryimpl.attribute.IRMObjectAttribute;
import org.ehrbase.aql.sql.queryimpl.attribute.JoinSetup;
import org.ehrbase.aql.sql.queryimpl.attribute.ehr.EhrAttribute;
import org.ehrbase.jooq.pg.Routines;
import org.ehrbase.jooq.pg.Tables;
import org.jooq.Configuration;
import org.jooq.Field;
import org.jooq.JSONB;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.TableField;
import org.jooq.impl.DSL;

public class FullEhrJson
extends EhrAttribute {
    protected TableField tableField;
    protected Optional<String> jsonPath;

    public FullEhrJson(FieldResolutionContext fieldContext, JoinSetup joinSetup) {
        super(fieldContext, joinSetup);
        this.tableField = Tables.EHR_.ID;
        this.jsonPath = Optional.empty();
    }

    @Override
    public Field<?> sqlField() {
        this.fieldContext.setJsonDatablock(true);
        this.fieldContext.setRmType("EHR");
        Configuration configuration = this.fieldContext.getContext().configuration();
        Field jsonFullEhr = null;
        if (this.jsonPath.isPresent()) {
            String path = this.jsonPath.get();
            String[] suffix = null;
            String[] prefix = null;
            if (path.startsWith("'{compositions") && path.length() > "'{compositions}'".length() || path.startsWith("'{contributions") && path.length() > "'{contributions}'".length() || path.startsWith("'{folders") && path.length() > "'{folders}'".length()) {
                String[] tokens = path.split(",", 2);
                if (tokens.length != 2) {
                    throw new IllegalArgumentException("Could not interpret:" + path);
                }
                prefix = AqlRoutines.jsonpathParameters(tokens[0]);
                suffix = AqlRoutines.jsonpathParameters(tokens[1]);
                if (this.isValuePath(suffix)) {
                    this.fieldContext.setJsonDatablock(false);
                }
            }
            if (prefix != null) {
                jsonFullEhr = DSL.field((String)AqlRoutines.jsonpathItemAsText(configuration, AqlRoutines.jsonArraySplitElements(configuration, AqlRoutines.jsonpathItem(configuration, (Field<JSONB>)Routines.jsEhr((Field)DSL.field((String)JoinBinder.ehrRecordTable.getName().concat(".").concat(this.tableField.getName())).cast(UUID.class), (Field)DSL.val((String)this.fieldContext.getServerNodeId())).cast(JSONB.class), prefix)), suffix));
                if (this.fieldContext.getClause().equals((Object)IQueryImpl.Clause.WHERE)) {
                    jsonFullEhr = DSL.field((Select)DSL.select((SelectField)jsonFullEhr));
                }
            } else if (this.jsonPath.isPresent()) {
                jsonFullEhr = DSL.field(AqlRoutines.jsonpathItem(configuration, (Field<JSONB>)Routines.jsEhr((Field)DSL.field((String)JoinBinder.ehrRecordTable.getName().concat(".").concat(this.tableField.getName())).cast(UUID.class), (Field)DSL.val((String)this.fieldContext.getServerNodeId())).cast(JSONB.class), AqlRoutines.jsonpathParameters(this.jsonPath.get())));
            }
        } else {
            jsonFullEhr = DSL.field((SelectField)Routines.jsEhr((Field)DSL.field((String)JoinBinder.ehrRecordTable.getName().concat(".").concat(this.tableField.getName())).cast(UUID.class), (Field)DSL.val((String)this.fieldContext.getServerNodeId())).cast(String.class));
        }
        if (this.fieldContext.isWithAlias()) {
            return this.aliased(DSL.field((SelectField)jsonFullEhr));
        }
        return this.defaultAliased(jsonFullEhr);
    }

    @Override
    public IRMObjectAttribute forTableField(TableField tableField) {
        this.tableField = tableField;
        return this;
    }

    public FullEhrJson forJsonPath(String jsonPath) {
        if (jsonPath == null || jsonPath.isEmpty()) {
            this.jsonPath = Optional.empty();
            return this;
        }
        this.jsonPath = Optional.of(new GenericJsonPath(jsonPath).jqueryPath().replace("/name,0,value", "name,value"));
        return this;
    }

    private boolean isValuePath(String[] pathItems) {
        return pathItems[pathItems.length - 1].equals("'value'");
    }
}

