/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.dao.access.jooq;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.aql.compiler.AqlExpression;
import org.ehrbase.aql.compiler.AqlExpressionWithParameters;
import org.ehrbase.aql.compiler.AuditVariables;
import org.ehrbase.aql.compiler.Contains;
import org.ehrbase.aql.compiler.Statements;
import org.ehrbase.aql.definition.I_VariableDefinition;
import org.ehrbase.aql.sql.AqlResult;
import org.ehrbase.aql.sql.QueryProcessor;
import org.ehrbase.dao.access.interfaces.I_DomainAccess;
import org.ehrbase.dao.access.support.DataAccess;
import org.ehrbase.openehr.sdk.validation.terminology.ExternalTerminologyValidation;
import org.ehrbase.service.KnowledgeCacheService;
import org.jooq.Record;
import org.jooq.Result;

public class AqlQueryHandler
extends DataAccess {
    private ExternalTerminologyValidation tsAdapter;
    private Map<String, Set<Object>> auditResultMap = new LinkedHashMap<String, Set<Object>>();

    public AqlQueryHandler(I_DomainAccess domainAccess, ExternalTerminologyValidation tsAdapter) {
        super(domainAccess);
        this.tsAdapter = tsAdapter;
    }

    public AqlResult process(String query) {
        AqlExpression aqlExpression = new AqlExpression().parse(query);
        return this.execute(aqlExpression);
    }

    public AqlResult process(String query, Map<String, Object> parameters) {
        AqlExpressionWithParameters aqlExpression = new AqlExpressionWithParameters().parse(query, parameters);
        return this.execute(aqlExpression);
    }

    private AqlResult execute(AqlExpression aqlExpression) {
        AuditVariables auditVariables = new AuditVariables();
        Contains contains = new Contains(aqlExpression.getParseTree(), (KnowledgeCacheService)this.getDataAccess().getIntrospectService()).process();
        Statements statements = new Statements(aqlExpression.getParseTree(), contains.getIdentifierMapper(), this.tsAdapter).process();
        QueryProcessor queryProcessor = new QueryProcessor(this, this.getIntrospectService(), contains, statements, this.getDataAccess().getServerConfig().getNodename());
        AqlResult aqlResult = queryProcessor.execute();
        LinkedHashMap<String, String> variables = new LinkedHashMap<String, String>();
        Iterator<I_VariableDefinition> iterator = statements.getVariables().iterator();
        int serial = 0;
        while (iterator.hasNext()) {
            I_VariableDefinition variableDefinition = iterator.next();
            if (auditVariables.isAuditVariable(variableDefinition)) {
                auditVariables.addResults(this.auditResultMap, variableDefinition.getPath(), this.resultSetForVariable(variableDefinition, aqlResult.getRecords()));
            }
            if (variableDefinition.isHidden()) continue;
            Object key = variableDefinition.getAlias() == null || variableDefinition.isVoidAlias() ? "#" + serial++ : variableDefinition.getAlias();
            Object value = StringUtils.isNotBlank((CharSequence)variableDefinition.getPath()) ? "/" + variableDefinition.getPath() : variableDefinition.getIdentifier();
            variables.put((String)key, (String)value);
        }
        aqlResult.setVariables(variables);
        aqlResult.setAuditResultMap(this.auditResultMap);
        return aqlResult;
    }

    @Override
    public DataAccess getDataAccess() {
        return this;
    }

    public Set<Object> resultSetForVariable(I_VariableDefinition variableDefinition, Result<Record> recordResult) {
        Optional<String> alias = Optional.of(variableDefinition).map(I_VariableDefinition::getAlias);
        boolean fctAlias = alias.filter(a -> a.startsWith("_FCT")).isPresent();
        if (fctAlias) {
            return new LinkedHashSet<Object>();
        }
        String columnIdentifier = alias.orElseGet(() -> "/" + variableDefinition.getPath());
        return recordResult.stream().map(r -> r.get(columnIdentifier)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public Map<String, Set<Object>> getAuditResultMap() {
        return this.auditResultMap;
    }
}

