/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.dao.access.jooq;

import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.archetyped.Archetyped;
import com.nedap.archie.rm.archetyped.FeederAudit;
import com.nedap.archie.rm.archetyped.TemplateId;
import com.nedap.archie.rm.composition.Action;
import com.nedap.archie.rm.composition.AdminEntry;
import com.nedap.archie.rm.composition.Composition;
import com.nedap.archie.rm.composition.Evaluation;
import com.nedap.archie.rm.composition.EventContext;
import com.nedap.archie.rm.composition.Instruction;
import com.nedap.archie.rm.composition.Observation;
import com.nedap.archie.rm.composition.Section;
import com.nedap.archie.rm.datatypes.CodePhrase;
import com.nedap.archie.rm.datavalues.DvCodedText;
import com.nedap.archie.rm.datavalues.DvText;
import com.nedap.archie.rm.generic.PartyProxy;
import com.nedap.archie.rm.support.identification.ArchetypeID;
import com.nedap.archie.rm.support.identification.ObjectVersionId;
import com.nedap.archie.rm.support.identification.TerminologyId;
import com.nedap.archie.rm.support.identification.UIDBasedId;
import java.sql.Timestamp;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.dao.access.interfaces.I_CompositionAccess;
import org.ehrbase.dao.access.interfaces.I_ContextAccess;
import org.ehrbase.dao.access.interfaces.I_DomainAccess;
import org.ehrbase.dao.access.interfaces.I_EntryAccess;
import org.ehrbase.dao.access.jooq.SystemValue;
import org.ehrbase.dao.access.jooq.party.PersistedPartyProxy;
import org.ehrbase.dao.access.support.DataAccess;
import org.ehrbase.dao.access.support.SafeNav;
import org.ehrbase.jooq.dbencoding.RawJson;
import org.ehrbase.jooq.dbencoding.rmobject.FeederAuditEncoding;
import org.ehrbase.jooq.dbencoding.rmobject.LinksEncoding;
import org.ehrbase.jooq.pg.Tables;
import org.ehrbase.jooq.pg.enums.EntryType;
import org.ehrbase.jooq.pg.tables.records.EntryHistoryRecord;
import org.ehrbase.jooq.pg.tables.records.EntryRecord;
import org.ehrbase.jooq.pg.tables.records.TerritoryRecord;
import org.ehrbase.jooq.pg.udt.records.DvCodedTextRecord;
import org.ehrbase.service.RecordedDvCodedText;
import org.ehrbase.service.RecordedDvText;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.JSONB;
import org.jooq.Record;
import org.jooq.SelectField;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.UpdateQuery;
import org.jooq.impl.DSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntryAccess
extends DataAccess
implements I_EntryAccess {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String DB_INCONSISTENCY = "DB inconsistency:";
    private EntryRecord entryRecord;
    private Composition composition;

    public EntryAccess(I_DomainAccess domainAccess, String templateId, Integer sequence, UUID compositionId, Composition composition, Short sysTenant) {
        super(domainAccess.getContext(), domainAccess.getKnowledgeManager(), domainAccess.getIntrospectService(), domainAccess.getServerConfig());
        this.setFields(templateId, sequence, compositionId, composition, sysTenant);
    }

    private EntryAccess(I_DomainAccess domainAccess) {
        super(domainAccess);
    }

    public static String fetchTemplateIdByCompositionId(I_DomainAccess domainAccess, UUID compositionId) {
        return domainAccess.getContext().select((SelectField)Tables.ENTRY.TEMPLATE_ID).from((TableLike)Tables.ENTRY).where(Tables.ENTRY.COMPOSITION_ID.equal((Object)compositionId)).fetchOptional((Field)Tables.ENTRY.TEMPLATE_ID).orElse(null);
    }

    public static I_EntryAccess retrieveInstanceInComposition(I_DomainAccess domainAccess, I_CompositionAccess compositionAccess) {
        Optional existingEntry = domainAccess.getContext().fetchOptional((Table)Tables.ENTRY, Tables.ENTRY.COMPOSITION_ID.eq((Object)compositionAccess.getId()));
        if (existingEntry.isEmpty()) {
            return null;
        }
        EnumMap<SystemValue, Object> values = new EnumMap<SystemValue, Object>(SystemValue.class);
        values.put(SystemValue.COMPOSER, new PersistedPartyProxy(domainAccess).retrieve(compositionAccess.getComposerId()));
        Optional<I_ContextAccess> opContextAccess = compositionAccess.getContextId().map(id -> I_ContextAccess.retrieveInstance(domainAccess, id));
        opContextAccess.ifPresent(context -> values.put(SystemValue.CONTEXT, context.mapRmEventContext()));
        values.put(SystemValue.LANGUAGE, new CodePhrase(new TerminologyId("ISO_639-1"), compositionAccess.getLanguageCode()));
        String territory2letters = ((TerritoryRecord)domainAccess.getContext().fetchSingle((Table)Tables.TERRITORY, Tables.TERRITORY.CODE.eq((Object)compositionAccess.getTerritoryCode()))).getTwoletter();
        values.put(SystemValue.TERRITORY, new CodePhrase(new TerminologyId("ISO_3166-1"), territory2letters));
        if (compositionAccess.getFeederAudit() != null) {
            values.put(SystemValue.FEEDER_AUDIT, new FeederAuditEncoding().fromDB(compositionAccess.getFeederAudit()));
        }
        if (compositionAccess.getLinks() != null) {
            values.put(SystemValue.LINKS, new LinksEncoding().fromDB(compositionAccess.getLinks()));
        }
        try {
            EntryRecord entryRecord;
            EntryAccess entryAccess = new EntryAccess(domainAccess);
            Integer version = I_CompositionAccess.getLastVersionNumber(domainAccess, compositionAccess.getId());
            values.put(SystemValue.UID, new ObjectVersionId(compositionAccess.getId().toString() + "::" + domainAccess.getServerConfig().getNodename() + "::" + version));
            entryAccess.entryRecord = entryRecord = (EntryRecord)existingEntry.get();
            String value = entryRecord.getEntry().data();
            entryAccess.composition = (Composition)new RawJson().unmarshal(value, Composition.class);
            opContextAccess.map(I_ContextAccess::mapRmEventContext).ifPresent(ec -> values.put(SystemValue.CONTEXT, ec));
            values.put(SystemValue.CATEGORY, new RecordedDvCodedText().fromDB((Record)entryRecord, (Field<DvCodedTextRecord>)Tables.ENTRY.CATEGORY));
            EntryAccess.setCompositionAttributes(entryAccess.composition, values);
            EntryAccess.buildArchetypeDetails(entryAccess);
            return entryAccess;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(DB_INCONSISTENCY + e);
        }
    }

    private static void buildArchetypeDetails(EntryAccess entryAccess) {
        Archetyped archetypeDetails = new Archetyped();
        TemplateId templateId = new TemplateId();
        templateId.setValue(entryAccess.getTemplateId());
        archetypeDetails.setTemplateId(templateId);
        archetypeDetails.setArchetypeId(new ArchetypeID(entryAccess.getArchetypeId()));
        archetypeDetails.setRmVersion(entryAccess.getRmVersion());
        entryAccess.composition.setArchetypeDetails(archetypeDetails);
    }

    public static I_EntryAccess retrieveInstanceInCompositionVersion(I_DomainAccess domainAccess, I_CompositionAccess compositionHistoryAccess, int version) {
        Condition condition = Tables.ENTRY_HISTORY.COMPOSITION_ID.eq((Object)compositionHistoryAccess.getId()).and(Tables.ENTRY_HISTORY.SYS_TRANSACTION.eq((Object)compositionHistoryAccess.getSysTransaction()));
        Optional existingEntryHistory = domainAccess.getContext().fetchOptional((Table)Tables.ENTRY_HISTORY, condition);
        if (existingEntryHistory.isEmpty()) {
            return null;
        }
        EnumMap<SystemValue, Object> values = new EnumMap<SystemValue, Object>(SystemValue.class);
        values.put(SystemValue.COMPOSER, new PersistedPartyProxy(domainAccess).retrieve(compositionHistoryAccess.getComposerId()));
        EventContext context = I_ContextAccess.retrieveHistoricalEventContext(domainAccess, compositionHistoryAccess.getId(), compositionHistoryAccess.getSysTransaction());
        if (context == null) {
            compositionHistoryAccess.getContextId().ifPresent(uuid -> I_ContextAccess.retrieveInstance(domainAccess, uuid).mapRmEventContext());
        }
        values.put(SystemValue.CONTEXT, context);
        values.put(SystemValue.LANGUAGE, new CodePhrase(new TerminologyId("ISO_639-1"), compositionHistoryAccess.getLanguageCode()));
        String territory2letters = ((TerritoryRecord)domainAccess.getContext().fetchSingle((Table)Tables.TERRITORY, Tables.TERRITORY.CODE.eq((Object)compositionHistoryAccess.getTerritoryCode()))).getTwoletter();
        values.put(SystemValue.TERRITORY, new CodePhrase(new TerminologyId("ISO_3166-1"), territory2letters));
        values.put(SystemValue.FEEDER_AUDIT, new FeederAuditEncoding().fromDB(compositionHistoryAccess.getFeederAudit()));
        try {
            EntryAccess entryAccess = new EntryAccess(domainAccess);
            UUID compositionId = compositionHistoryAccess.getId();
            values.put(SystemValue.UID, new ObjectVersionId(compositionId.toString() + "::" + domainAccess.getServerConfig().getNodename() + "::" + version));
            EntryHistoryRecord entryHistoryRecord = (EntryHistoryRecord)existingEntryHistory.get();
            entryAccess.entryRecord = (EntryRecord)domainAccess.getContext().newRecord((Table)Tables.ENTRY);
            entryAccess.entryRecord.setSysTenant(entryHistoryRecord.getSysTenant());
            entryAccess.entryRecord.from((Object)entryHistoryRecord);
            entryAccess.composition = (Composition)new RawJson().unmarshal(entryHistoryRecord.getEntry().data(), Composition.class);
            DvCodedTextRecord category = entryHistoryRecord.getCategory();
            SafeNav<DvCodedText> safeDvCodedText = SafeNav.of(category).get(c -> new DvCodedText(c.getValue(), c.getDefiningCode().getCodeString()));
            values.put(SystemValue.CATEGORY, safeDvCodedText.get());
            EntryAccess.setCompositionAttributes(entryAccess.composition, values);
            EntryAccess.buildArchetypeDetails(entryAccess);
            return entryAccess;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(DB_INCONSISTENCY + e);
        }
    }

    private static void setCompositionAttributes(Composition composition, Map<SystemValue, Object> values) {
        if (values == null) {
            return;
        }
        block12: for (Map.Entry<SystemValue, Object> systemValue : values.entrySet()) {
            switch (systemValue.getKey()) {
                case CATEGORY: {
                    composition.setCategory((DvCodedText)systemValue.getValue());
                    continue block12;
                }
                case LANGUAGE: {
                    composition.setLanguage((CodePhrase)systemValue.getValue());
                    continue block12;
                }
                case TERRITORY: {
                    composition.setTerritory((CodePhrase)systemValue.getValue());
                    continue block12;
                }
                case COMPOSER: {
                    composition.setComposer((PartyProxy)systemValue.getValue());
                    continue block12;
                }
                case UID: {
                    composition.setUid((UIDBasedId)systemValue.getValue());
                    continue block12;
                }
                case CONTEXT: {
                    composition.setContext((EventContext)systemValue.getValue());
                    continue block12;
                }
                case NAME: {
                    composition.setName((DvText)systemValue.getValue());
                    continue block12;
                }
                case RM_VERSION: {
                    composition.getArchetypeDetails().setRmVersion((String)systemValue.getValue());
                    continue block12;
                }
                case FEEDER_AUDIT: {
                    composition.setFeederAudit((FeederAudit)systemValue.getValue());
                    continue block12;
                }
                case LINKS: {
                    composition.setLinks((List)systemValue.getValue());
                    continue block12;
                }
            }
            throw new IllegalArgumentException("Could not handle composition attribute:" + (Object)((Object)systemValue.getKey()));
        }
    }

    private void setCompositionFields(EntryRecord entryRecord, Composition composition) {
        entryRecord.setCategory(entryRecord.getCategory());
        if (composition.getContent() != null && !composition.getContent().isEmpty()) {
            Object node = composition.getContent().get(0);
            if (node instanceof Section) {
                entryRecord.setItemType(EntryType.valueOf((String)"section"));
            } else if (node instanceof Evaluation || node instanceof Observation || node instanceof Instruction || node instanceof Action) {
                entryRecord.setItemType(EntryType.valueOf((String)"care_entry"));
            } else if (node instanceof AdminEntry) {
                entryRecord.setItemType(EntryType.valueOf((String)"admin"));
            }
        } else {
            entryRecord.setItemType(EntryType.valueOf((String)"admin"));
        }
        entryRecord.setArchetypeId(composition.getArchetypeNodeId());
        RawJson rawJson = new RawJson();
        entryRecord.setEntry(JSONB.valueOf((String)rawJson.marshal((RMObject)composition)));
    }

    private void setFields(String templateId, Integer sequence, UUID compositionId, Composition composition, Short sysTenant) {
        this.entryRecord = (EntryRecord)this.getContext().newRecord((Table)Tables.ENTRY);
        this.entryRecord.setTemplateId(templateId);
        this.entryRecord.setSequence(sequence);
        this.entryRecord.setCompositionId(compositionId);
        this.entryRecord.setRmVersion(composition.getArchetypeDetails().getRmVersion());
        this.entryRecord.setSysTenant(sysTenant);
        new RecordedDvCodedText().toDB((Record)this.entryRecord, (Field<DvCodedTextRecord>)Tables.ENTRY.CATEGORY, composition.getCategory());
        this.setCompositionFields(this.entryRecord, composition);
        this.setCompositionName(composition.getName());
        this.composition = composition;
    }

    @Override
    public Composition getComposition() {
        return this.composition;
    }

    @Override
    public UUID commit(Timestamp transactionTime) {
        Record result = this.getContext().insertInto((Table)Tables.ENTRY, (Field)Tables.ENTRY.SEQUENCE, (Field)Tables.ENTRY.COMPOSITION_ID, (Field)Tables.ENTRY.TEMPLATE_ID, (Field)Tables.ENTRY.ITEM_TYPE, (Field)Tables.ENTRY.ARCHETYPE_ID, (Field)Tables.ENTRY.CATEGORY, (Field)Tables.ENTRY.ENTRY_, (Field)Tables.ENTRY.SYS_TRANSACTION, (Field)Tables.ENTRY.NAME, (Field)Tables.ENTRY.RM_VERSION, (Field)Tables.ENTRY.SYS_TENANT).values((Field)DSL.val((Integer)this.getSequence()), (Field)DSL.val((UUID)this.getCompositionId()), (Field)DSL.val((String)this.getTemplateId()), (Field)DSL.val((Object)EntryType.valueOf((String)this.getItemType())), (Field)DSL.val((String)this.getArchetypeId()), (Field)DSL.val((Object)this.getCategory()), (Field)DSL.val((JSONB)this.getEntryJson()), (Field)DSL.val((Timestamp)transactionTime), (Field)DSL.val((Object)this.getCompositionName()), (Field)DSL.val((String)this.getRmVersion()), (Field)DSL.val((Short)this.entryRecord.getSysTenant())).returning(new SelectFieldOrAsterisk[]{Tables.ENTRY.ID}).fetchOne();
        return (UUID)result.getValue((Field)Tables.ENTRY.ID);
    }

    @Override
    @Deprecated(forRemoval=true)
    public UUID commit() {
        throw new InternalServerException("INTERNAL: commit without transaction time is not legal");
    }

    @Override
    public Boolean update(Timestamp transactionTime) {
        return this.update(transactionTime, false);
    }

    @Override
    public Boolean update(Timestamp transactionTime, boolean force) {
        this.logger.debug("updating entry with force flag: {} and changed flag: {}", (Object)force, (Object)this.entryRecord.changed());
        if (!force && !this.entryRecord.changed()) {
            this.logger.debug("No updateComposition took place, returning...");
            return false;
        }
        this.entryRecord.changed((Field)Tables.ENTRY.SYS_PERIOD, false);
        UpdateQuery updateQuery = this.getContext().updateQuery((Table)Tables.ENTRY);
        updateQuery.addValue((Field)Tables.ENTRY.COMPOSITION_ID, (Object)this.getCompositionId());
        updateQuery.addValue((Field)Tables.ENTRY.SEQUENCE, DSL.field((SelectField)DSL.val((Integer)this.getSequence())));
        updateQuery.addValue((Field)Tables.ENTRY.TEMPLATE_ID, DSL.field((SelectField)DSL.val((String)this.getTemplateId())));
        updateQuery.addValue((Field)Tables.ENTRY.ITEM_TYPE, DSL.field((SelectField)DSL.val((Object)EntryType.valueOf((String)this.getItemType()))));
        updateQuery.addValue((Field)Tables.ENTRY.ARCHETYPE_ID, DSL.field((SelectField)DSL.val((String)this.getArchetypeId())));
        updateQuery.addValue((Field)Tables.ENTRY.CATEGORY, DSL.field((SelectField)DSL.val((Object)this.getCategory())));
        updateQuery.addValue((Field)Tables.ENTRY.ENTRY_, DSL.field((SelectField)DSL.val((JSONB)this.getEntryJson())));
        updateQuery.addValue((Field)Tables.ENTRY.SYS_TRANSACTION, DSL.field((SelectField)DSL.val((Timestamp)transactionTime)));
        updateQuery.addValue((Field)Tables.ENTRY.NAME, DSL.field((SelectField)DSL.val((Object)this.getCompositionName())));
        updateQuery.addValue((Field)Tables.ENTRY.RM_VERSION, DSL.field((SelectField)DSL.val((String)this.getRmVersion())));
        updateQuery.addConditions(Tables.ENTRY.ID.eq((Object)this.getId()));
        this.logger.debug("Update done...");
        return updateQuery.execute() > 0;
    }

    @Override
    @Deprecated(forRemoval=true)
    public Boolean update() {
        throw new InternalServerException("INTERNAL: Invalid updateComposition call to updateComposition without Transaction time and/or force flag arguments");
    }

    @Override
    @Deprecated(forRemoval=true)
    public Boolean update(Boolean force) {
        throw new InternalServerException("INTERNAL: Invalid updateComposition call to updateComposition without Transaction time and/or force flag arguments");
    }

    @Override
    public Integer delete() {
        if (this.entryRecord != null) {
            return this.entryRecord.delete();
        }
        return 0;
    }

    @Override
    public UUID getId() {
        return this.entryRecord.getId();
    }

    @Override
    public JSONB getEntryJson() {
        return this.entryRecord.getEntry();
    }

    @Override
    public DvCodedTextRecord getCategory() {
        return this.entryRecord.getCategory();
    }

    public DvCodedTextRecord getCompositionName() {
        return this.entryRecord.getName();
    }

    public void setCompositionName(DvText compositionName) {
        new RecordedDvText().toDB((Record)this.entryRecord, (Field<DvCodedTextRecord>)Tables.ENTRY.NAME, compositionName);
    }

    @Override
    public UUID getCompositionId() {
        return this.entryRecord.getCompositionId();
    }

    @Override
    public void setCompositionId(UUID compositionId) {
        this.entryRecord.setCompositionId(compositionId);
    }

    @Override
    public String getTemplateId() {
        return this.entryRecord.getTemplateId();
    }

    @Override
    public void setTemplateId(String templateId) {
        this.entryRecord.setTemplateId(templateId);
    }

    @Override
    public Integer getSequence() {
        return this.entryRecord.getSequence();
    }

    @Override
    public void setSequence(Integer sequence) {
        this.entryRecord.setSequence(sequence);
    }

    @Override
    public String getArchetypeId() {
        return this.entryRecord.getArchetypeId();
    }

    @Override
    public String getRmVersion() {
        return this.entryRecord.getRmVersion();
    }

    @Override
    public String getItemType() {
        return this.entryRecord.getItemType().getLiteral();
    }

    @Override
    public void setCompositionData(Composition composition) {
        this.setCompositionFields(this.entryRecord, composition);
    }

    @Override
    public DataAccess getDataAccess() {
        return this;
    }
}

