/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.dao.access.jooq;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.api.exception.UnprocessableEntityException;
import org.ehrbase.dao.access.interfaces.I_DomainAccess;
import org.ehrbase.dao.access.interfaces.I_TemplateStoreAccess;
import org.ehrbase.dao.access.support.DataAccess;
import org.ehrbase.dao.access.util.TransactionTime;
import org.ehrbase.ehr.knowledge.TemplateMetaData;
import org.ehrbase.jooq.pg.Routines;
import org.ehrbase.jooq.pg.tables.TemplateStore;
import org.ehrbase.jooq.pg.tables.records.TemplateStoreRecord;
import org.ehrbase.util.UuidGenerator;
import org.jooq.Configuration;
import org.jooq.Record1;
import org.jooq.Result;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.openehr.schemas.v1.OPERATIONALTEMPLATE;
import org.openehr.schemas.v1.TemplateDocument;

public class TemplateStoreAccess
extends DataAccess
implements I_TemplateStoreAccess {
    private TemplateStoreRecord templateStoreRecord;

    public TemplateStoreAccess(I_DomainAccess domainAccess, OPERATIONALTEMPLATE operationaltemplate, Short sysTenant) {
        super(domainAccess);
        this.templateStoreRecord = (TemplateStoreRecord)domainAccess.getContext().newRecord((Table)TemplateStore.TEMPLATE_STORE);
        this.templateStoreRecord.setSysTenant(sysTenant);
        this.setTemplate(operationaltemplate);
    }

    public TemplateStoreAccess(I_DomainAccess domainAccess, OPERATIONALTEMPLATE operationaltemplate, Short sysTenant, UUID id) {
        super(domainAccess);
        this.templateStoreRecord = (TemplateStoreRecord)domainAccess.getContext().newRecord((Table)TemplateStore.TEMPLATE_STORE);
        this.templateStoreRecord.setSysTenant(sysTenant);
        this.setTemplate(operationaltemplate, id);
    }

    private TemplateStoreAccess(I_DomainAccess domainAccess) {
        super(domainAccess);
    }

    @Override
    public UUID commit(Timestamp transactionTime) {
        this.templateStoreRecord.setSysTransaction(transactionTime);
        this.templateStoreRecord.store();
        return this.templateStoreRecord.getId();
    }

    @Override
    public UUID commit() {
        return this.commit(TransactionTime.millis());
    }

    @Override
    public Boolean update(Timestamp transactionTime) {
        return this.update(transactionTime, false);
    }

    @Override
    public Boolean update(Timestamp transactionTime, boolean force) {
        boolean updated = false;
        if (force || this.templateStoreRecord.changed()) {
            if (!this.templateStoreRecord.changed()) {
                this.templateStoreRecord.changed(true);
            }
            this.templateStoreRecord.setSysTransaction(transactionTime);
            updated = this.templateStoreRecord.update() == 1;
        }
        return updated;
    }

    @Override
    public Boolean update() {
        return this.update(TransactionTime.millis(), false);
    }

    @Override
    public Boolean update(Boolean force) {
        return this.update(TransactionTime.millis(), force);
    }

    @Override
    public Integer delete() {
        int count = 0;
        return count += this.templateStoreRecord.delete();
    }

    @Override
    public DataAccess getDataAccess() {
        return this;
    }

    @Override
    public OPERATIONALTEMPLATE getTemplate() {
        return Optional.ofNullable(this.templateStoreRecord).map(TemplateStoreRecord::getContent).map(TemplateStoreAccess::buildOperationaltemplate).orElse(null);
    }

    @Override
    public UUID getId() {
        return Optional.ofNullable(this.templateStoreRecord).map(TemplateStoreRecord::getId).orElse(null);
    }

    private static OPERATIONALTEMPLATE buildOperationaltemplate(String content) {
        TemplateDocument document;
        ByteArrayInputStream inputStream = new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8));
        try {
            document = TemplateDocument.Factory.parse((InputStream)inputStream);
        }
        catch (IOException | XmlException e) {
            throw new InternalServerException(e.getMessage());
        }
        return document.getTemplate();
    }

    @Override
    public void setTemplate(OPERATIONALTEMPLATE template) {
        this.setTemplate(template, UuidGenerator.randomUUID());
    }

    private void setTemplate(OPERATIONALTEMPLATE template, UUID id) {
        this.templateStoreRecord.setId(id != null ? id : UuidGenerator.randomUUID());
        this.templateStoreRecord.setTemplateId(template.getTemplateId().getValue());
        XmlOptions opts = new XmlOptions();
        opts.setSaveSyntheticDocumentElement(new QName("http://schemas.openehr.org/v1", "template"));
        this.templateStoreRecord.setContent(template.xmlText(opts));
    }

    public static I_TemplateStoreAccess retrieveInstanceByTemplateId(I_DomainAccess domainAccess, String templateId) {
        TemplateStoreAccess templateStoreAccess = new TemplateStoreAccess(domainAccess);
        templateStoreAccess.templateStoreRecord = (TemplateStoreRecord)domainAccess.getContext().fetchOne((Table)TemplateStore.TEMPLATE_STORE, TemplateStore.TEMPLATE_STORE.TEMPLATE_ID.eq((Object)templateId));
        return templateStoreAccess;
    }

    public static List<TemplateMetaData> fetchAll(I_DomainAccess domainAccess) {
        Result records = domainAccess.getContext().selectFrom((TableLike)TemplateStore.TEMPLATE_STORE).fetch();
        return records.parallelStream().map(TemplateStoreAccess::buildMetadata).collect(Collectors.toList());
    }

    public static Set<String> fetchAllTemplateIds(I_DomainAccess domainAccess) {
        Result records = domainAccess.getContext().select((SelectField)TemplateStore.TEMPLATE_STORE.TEMPLATE_ID).from((TableLike)TemplateStore.TEMPLATE_STORE).fetch();
        return records.parallelStream().map(Record1::component1).collect(Collectors.toSet());
    }

    public static String adminUpdateTemplate(I_DomainAccess domainAccess, OPERATIONALTEMPLATE template) {
        Result usingCompositions = Routines.adminGetTemplateUsage((Configuration)domainAccess.getContext().configuration(), (String)template.getTemplateId().getValue());
        if (usingCompositions.isNotEmpty()) {
            throw new UnprocessableEntityException(String.format("Cannot delete template %s since the following compositions are still using it %s", template.getTemplateId().getValue(), usingCompositions.toString()));
        }
        XmlOptions opts = new XmlOptions();
        opts.setSaveSyntheticDocumentElement(new QName("http://schemas.openehr.org/v1", "template"));
        return Routines.adminUpdateTemplate((Configuration)domainAccess.getContext().configuration(), (String)template.getTemplateId().getValue(), (String)template.xmlText(opts));
    }

    public static boolean deleteTemplate(I_DomainAccess domainAccess, String templateId) {
        Result usingCompositions = Routines.adminGetTemplateUsage((Configuration)domainAccess.getContext().configuration(), (String)templateId);
        if (usingCompositions.isNotEmpty()) {
            throw new UnprocessableEntityException(String.format("Cannot delete template %s since the following compositions are still using it %s", templateId, usingCompositions.toString()));
        }
        return Routines.adminDeleteTemplate((Configuration)domainAccess.getContext().configuration(), (String)templateId) > 0;
    }

    public static int adminDeleteAllTemplates(I_DomainAccess domainAccess) {
        return Routines.adminDeleteAllTemplates((Configuration)domainAccess.getContext().configuration());
    }

    private static TemplateMetaData buildMetadata(TemplateStoreRecord record) {
        TemplateMetaData templateMetaData = new TemplateMetaData();
        templateMetaData.setInternalId(record.getId());
        templateMetaData.setOperationalTemplate(TemplateStoreAccess.buildOperationaltemplate(record.getContent()));
        templateMetaData.setCreatedOn(OffsetDateTime.ofInstant(record.getSysTransaction().toInstant(), ZoneId.systemDefault()));
        return templateMetaData;
    }
}

