/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.dao.access.jooq.party;

import com.nedap.archie.rm.support.identification.GenericId;
import com.nedap.archie.rm.support.identification.HierObjectId;
import com.nedap.archie.rm.support.identification.ObjectId;
import com.nedap.archie.rm.support.identification.ObjectVersionId;
import com.nedap.archie.rm.support.identification.PartyRef;
import org.ehrbase.jooq.pg.tables.records.PartyIdentifiedRecord;
import org.ehrbase.openehr.sdk.util.SnakeCase;

public class PersistedObjectId {
    public ObjectId fromDB(PartyIdentifiedRecord identifiedRecord) {
        HierObjectId objectId = null;
        switch (identifiedRecord.getObjectIdType()) {
            case generic_id: {
                objectId = new GenericId(identifiedRecord.getPartyRefValue(), identifiedRecord.getPartyRefScheme());
                break;
            }
            case hier_object_id: {
                objectId = new HierObjectId(identifiedRecord.getPartyRefValue());
                break;
            }
            case object_version_id: {
                objectId = new ObjectVersionId(identifiedRecord.getPartyRefValue());
            }
        }
        return objectId;
    }

    public String objectIdClassSnakeCase(PartyRef externalRef) {
        ObjectId objectId = externalRef.getId();
        String objectIdType = null;
        if (objectId != null) {
            objectIdType = new SnakeCase(objectId.getClass().getSimpleName()).camelToSnake();
        }
        return objectIdType;
    }
}

