/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.dao.access.jooq.party;

import com.nedap.archie.rm.datavalues.DvIdentifier;
import com.nedap.archie.rm.generic.PartyIdentified;
import com.nedap.archie.rm.generic.PartyProxy;
import com.nedap.archie.rm.support.identification.PartyRef;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.dao.access.interfaces.I_DomainAccess;
import org.ehrbase.dao.access.jooq.party.PartyIdentifiers;
import org.ehrbase.dao.access.jooq.party.PartyRefValue;
import org.ehrbase.dao.access.jooq.party.PersistedObjectId;
import org.ehrbase.dao.access.jooq.party.PersistedParty;
import org.ehrbase.dao.access.jooq.party.PersistedPartyRef;
import org.ehrbase.jooq.pg.Tables;
import org.ehrbase.jooq.pg.enums.PartyType;
import org.ehrbase.jooq.pg.tables.records.PartyIdentifiedRecord;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.Table;

public class PersistedPartyIdentified
extends PersistedParty {
    public static final String SECURITY_USER_TYPE = "EHRbase Security Authentication User";
    public static final String EHRBASE = "EHRbase";
    private static final String ERR_MISSING_PROXY = "Missing PartyProxy for PartyIdentifiedRecord[%s]";

    public PersistedPartyIdentified(I_DomainAccess domainAccess) {
        super(domainAccess);
    }

    @Override
    public PartyProxy render(PartyIdentifiedRecord partyIdentifiedRecord) {
        return (PartyProxy)this.renderMultiple(List.of(partyIdentifiedRecord)).stream().findFirst().orElseThrow(() -> new IllegalArgumentException(String.format(ERR_MISSING_PROXY, partyIdentifiedRecord.getId())));
    }

    @Override
    public List<PartyProxy> renderMultiple(Collection<PartyIdentifiedRecord> partyIdentifiedRecords) {
        List<Pair<PartyIdentifiedRecord, List<DvIdentifier>>> partyIdPair = new PartyIdentifiers(this.domainAccess).retrieveMultiple(partyIdentifiedRecords);
        return partyIdPair.stream().map(pair -> {
            PartyIdentifiedRecord pir = (PartyIdentifiedRecord)pair.getLeft();
            PartyRef partyRef = Optional.ofNullable(pir.getPartyRefType()).map(ref -> new PartyRef(new PersistedObjectId().fromDB(pir), pir.getPartyRefNamespace(), pir.getPartyRefType())).orElse(null);
            List identifierList = (List)pair.getRight();
            return new PartyIdentified(partyRef, pir.getName(), identifierList.isEmpty() ? null : identifierList);
        }).collect(Collectors.toList());
    }

    @Override
    public UUID store(PartyProxy partyProxy, Short sysTenant) {
        PartyRefValue partyRefValue = new PartyRefValue(partyProxy).attributes();
        UUID partyIdentifiedUuid = ((PartyIdentifiedRecord)this.domainAccess.getContext().insertInto((Table)Tables.PARTY_IDENTIFIED, (Field)Tables.PARTY_IDENTIFIED.NAME, (Field)Tables.PARTY_IDENTIFIED.PARTY_REF_NAMESPACE, (Field)Tables.PARTY_IDENTIFIED.PARTY_REF_VALUE, (Field)Tables.PARTY_IDENTIFIED.PARTY_REF_SCHEME, (Field)Tables.PARTY_IDENTIFIED.PARTY_REF_TYPE, (Field)Tables.PARTY_IDENTIFIED.PARTY_TYPE, (Field)Tables.PARTY_IDENTIFIED.OBJECT_ID_TYPE, (Field)Tables.PARTY_IDENTIFIED.SYS_TENANT).values((Object)((PartyIdentified)partyProxy).getName(), (Object)partyRefValue.getNamespace(), (Object)partyRefValue.getValue(), (Object)partyRefValue.getScheme(), (Object)partyRefValue.getType(), (Object)PartyType.party_identified, (Object)partyRefValue.getObjectIdType(), (Object)sysTenant).returning(new SelectFieldOrAsterisk[]{Tables.PARTY_IDENTIFIED.ID}).fetchOne()).getId();
        new PartyIdentifiers(this.domainAccess).store((PartyIdentified)partyProxy, partyIdentifiedUuid, sysTenant);
        return partyIdentifiedUuid;
    }

    @Override
    public UUID findInDB(PartyProxy partyProxy) {
        UUID uuid = new PersistedPartyRef(this.domainAccess).findInDB(partyProxy.getExternalRef());
        if (uuid != null) {
            Record record = this.domainAccess.getContext().fetchAny((Table)Tables.PARTY_IDENTIFIED, Tables.PARTY_IDENTIFIED.ID.eq((Object)uuid));
            if (record == null) {
                throw new InternalServerException("Inconsistent PartyIdentified UUID:" + uuid);
            }
            if (!((String)record.get((Field)Tables.PARTY_IDENTIFIED.NAME)).equals(((PartyIdentified)partyProxy).getName())) {
                throw new IllegalArgumentException("Conflicting identification, existing name was:" + (String)record.get((Field)Tables.PARTY_IDENTIFIED.NAME) + ", but found passed name:" + ((PartyIdentified)partyProxy).getName());
            }
        }
        return uuid;
    }
}

