/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.dao.access.util;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.dao.access.util.InvalidVersionFormatException;
import org.springframework.lang.NonNull;

public record SemVer(Integer major, Integer minor, Integer patch, String suffix) {
    public static final Pattern SEMVER_REGEX;
    public static final SemVer NO_VERSION;

    private static String capturing(String content) {
        return "(" + content + ")";
    }

    private static String nonCapturing(String content) {
        return "(?:" + content + ")";
    }

    private static String optionalNonCapturing(String content) {
        return SemVer.nonCapturing(content) + "?";
    }

    @NonNull
    public static SemVer parse(String semVerStr) throws InvalidVersionFormatException {
        if (StringUtils.isBlank((CharSequence)semVerStr) || "LATEST".equalsIgnoreCase(semVerStr)) {
            return NO_VERSION;
        }
        Matcher matcher = SEMVER_REGEX.matcher(semVerStr);
        if (!matcher.matches()) {
            throw new InvalidVersionFormatException(semVerStr);
        }
        return new SemVer(SemVer.integerFromGroup(matcher, 1), SemVer.integerFromGroup(matcher, 2), SemVer.integerFromGroup(matcher, 3), SemVer.group(matcher, 4).orElse(null));
    }

    public String toVersionString() {
        if (this.isNoVersion()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.major);
        if (this.minor != null) {
            sb.append('.').append(this.minor);
            if (this.patch != null) {
                sb.append('.').append(this.patch);
                if (this.suffix != null) {
                    sb.append('-').append(this.suffix);
                }
            }
        }
        return sb.toString();
    }

    public boolean isNoVersion() {
        return this.major == null;
    }

    public boolean isPartial() {
        return this.patch == null;
    }

    public boolean isRelease() {
        return this.patch != null && this.suffix == null;
    }

    public boolean isPreRelease() {
        return this.suffix != null;
    }

    private static Optional<String> group(Matcher matcher, int groupNr) {
        return Optional.of(matcher).filter(m -> m.groupCount() >= groupNr).map(m -> m.group(groupNr));
    }

    private static Integer integerFromGroup(Matcher matcher, int groupNr) {
        return SemVer.group(matcher, groupNr).map(Integer::parseInt).orElse(null);
    }

    @Override
    public String toString() {
        return this.toVersionString();
    }

    static {
        String dot = "\\.";
        String versionPart = "0|[1-9]\\d*";
        String versionGroup = SemVer.capturing(versionPart);
        String preReleaseIdentifier = SemVer.nonCapturing(versionPart + "|\\d*[a-zA-Z-][0-9a-zA-Z-]*");
        String dotSeparatedPreReleaseIdentifiers = preReleaseIdentifier + SemVer.nonCapturing(dot + preReleaseIdentifier) + "*";
        SEMVER_REGEX = Pattern.compile(versionGroup + SemVer.optionalNonCapturing(dot + versionGroup + SemVer.optionalNonCapturing(dot + versionGroup + SemVer.optionalNonCapturing("-" + SemVer.capturing(dotSeparatedPreReleaseIdentifiers)))));
        NO_VERSION = new SemVer(null, null, null, null);
    }
}

