/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.repository;

import java.util.Optional;
import java.util.UUID;
import org.ehrbase.jooq.pg.tables.System;
import org.ehrbase.jooq.pg.tables.records.SystemRecord;
import org.ehrbase.util.UuidGenerator;
import org.jooq.DSLContext;
import org.jooq.Record;
import org.jooq.Record1;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class SystemRepository {
    private final DSLContext context;

    public SystemRepository(DSLContext context) {
        this.context = context;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void commit(SystemRecord systemRecord) {
        this.context.insertInto((Table)System.SYSTEM).set((Record)systemRecord).execute();
    }

    public Optional<UUID> findSystemId(String system) {
        return Optional.ofNullable((Record1)this.context.select((SelectField)System.SYSTEM.ID).from((TableLike)System.SYSTEM).where(System.SYSTEM.SETTINGS.eq((Object)system)).fetchOne()).map(Record1::value1);
    }

    public SystemRecord toRecord(String system, String description) {
        SystemRecord systemRecord = (SystemRecord)this.context.newRecord((Table)System.SYSTEM);
        systemRecord.setId(UuidGenerator.randomUUID());
        systemRecord.setSettings(system);
        systemRecord.setDescription(description);
        return systemRecord;
    }
}

