/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.service;

import java.util.UUID;
import org.ehrbase.api.definitions.ServerConfig;
import org.ehrbase.api.service.BaseService;
import org.ehrbase.dao.access.interfaces.I_DomainAccess;
import org.ehrbase.dao.access.interfaces.I_SystemAccess;
import org.ehrbase.dao.access.support.ServiceDataAccess;
import org.ehrbase.service.IUserService;
import org.ehrbase.service.KnowledgeCacheService;
import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;

public class BaseServiceImp
implements BaseService {
    public static final String DEMOGRAPHIC = "DEMOGRAPHIC";
    public static final String PARTY = "PARTY";
    private final ServerConfig serverConfig;
    private final KnowledgeCacheService knowledgeCacheService;
    private final DSLContext context;
    private UUID systemId;
    @Lazy
    @Autowired
    private IUserService userService;

    public BaseServiceImp(KnowledgeCacheService knowledgeCacheService, DSLContext context, ServerConfig serverConfig) {
        this.knowledgeCacheService = knowledgeCacheService;
        this.context = context;
        this.serverConfig = serverConfig;
    }

    protected I_DomainAccess getDataAccess() {
        return new ServiceDataAccess(this.context, this.knowledgeCacheService, this.knowledgeCacheService, this.serverConfig);
    }

    public UUID getSystemUuid() {
        if (this.systemId == null) {
            this.systemId = I_SystemAccess.createOrRetrieveLocalSystem(this.getDataAccess());
        }
        return this.systemId;
    }

    protected UUID getCurrentUserId() {
        return this.userService.getCurrentUserId();
    }

    public ServerConfig getServerConfig() {
        return this.serverConfig;
    }
}

